/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.radar.painter.radar;

import java.awt.Graphics2D;
import java.util.List;
import org.jensoft.core.glyphmetrics.GeneralMetricsPath;
import org.jensoft.core.glyphmetrics.GlyphMetric;
import org.jensoft.core.plugin.radar.Radar;
import org.jensoft.core.plugin.radar.RadarDimension;
import org.jensoft.core.plugin.radar.RadarSurface;
import org.jensoft.core.plugin.radar.painter.AbstractRadarPainter;

public class RadarDefaultPainter
extends AbstractRadarPainter {
    @Override
    public void paintRadar(Graphics2D g2d, Radar radar) {
        for (RadarDimension dimension : radar.getDimensions()) {
            if (dimension.getDimensionPainter() != null) {
                dimension.getDimensionPainter().paintRadarDimension(g2d, radar, dimension);
            }
            if (dimension.getDimensionLabel() == null) continue;
            dimension.getDimensionLabel().paintRadarDimension(g2d, radar, dimension);
        }
        for (RadarSurface surface : radar.getSurfaces()) {
            if (surface.getSurfacePainter() == null) continue;
            surface.getSurfacePainter().paintRadarSurface(g2d, radar, surface);
        }
        for (RadarDimension dimension : radar.getDimensions()) {
            GeneralMetricsPath metricsPath = dimension.getMetricsPath();
            metricsPath.setProjection(radar.getHost().getProjection());
            metricsPath.setFontRenderContext(g2d.getFontRenderContext());
            List<GlyphMetric> metrics = metricsPath.getMetrics();
            for (GlyphMetric glyphMetric : metrics) {
                if (glyphMetric.getGlyphMetricMarkerPainter() != null) {
                    glyphMetric.getGlyphMetricMarkerPainter().paintGlyphMetric(g2d, glyphMetric);
                }
                if (glyphMetric.getGlyphMetricFill() != null) {
                    glyphMetric.getGlyphMetricFill().paintGlyphMetric(g2d, glyphMetric);
                }
                if (glyphMetric.getGlyphMetricDraw() == null) continue;
                glyphMetric.getGlyphMetricDraw().paintGlyphMetric(g2d, glyphMetric);
            }
        }
    }
}

