/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.radar.painter.surface;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.List;
import org.jensoft.core.plugin.radar.Radar;
import org.jensoft.core.plugin.radar.RadarMetrics;
import org.jensoft.core.plugin.radar.RadarSurface;
import org.jensoft.core.plugin.radar.RadarSurfaceAnchor;
import org.jensoft.core.plugin.radar.painter.AbstractRadarSurfacePainter;

public class RadarSurfaceDefaultPainter
extends AbstractRadarSurfacePainter {
    private Color outlineColor;
    private Stroke outlineStroke;
    private Color fillColor;
    private SurfaceStyle style = SurfaceStyle.Both;
    private Stroke defaultStroke = new BasicStroke();

    public RadarSurfaceDefaultPainter(Color outlineColor, Color fillColor) {
        this.outlineColor = outlineColor;
        this.fillColor = fillColor;
    }

    public RadarSurfaceDefaultPainter(Color outlineColor, Stroke outlineStroke, Color fillColor) {
        this.outlineColor = outlineColor;
        this.outlineStroke = outlineStroke;
        this.fillColor = fillColor;
    }

    @Override
    public final void paintRadarSurface(Graphics2D g2d, Radar radar, RadarSurface radarSurface) {
        radarSurface.solveSurfaceGeometry();
        if (radarSurface.getSurfacePath() == null) {
            return;
        }
        if (this.style == SurfaceStyle.Fill || this.style == SurfaceStyle.Both) {
            if (this.fillColor != null) {
                g2d.setColor(this.fillColor);
            } else {
                g2d.setColor(radar.getThemeColor());
            }
            g2d.fill(radarSurface.getSurfacePath());
        }
        if (this.style == SurfaceStyle.Stroke || this.style == SurfaceStyle.Both) {
            if (this.outlineColor != null) {
                g2d.setColor(this.outlineColor);
            } else {
                g2d.setColor(radar.getThemeColor());
            }
            g2d.draw(radarSurface.getSurfacePath());
        }
        List<RadarSurfaceAnchor> anchors = radarSurface.getAnchors();
        for (int i = 0; i < anchors.size(); ++i) {
            RadarSurfaceAnchor anchor = anchors.get(i);
            RadarMetrics radarMetrics = anchor.getRadarMetrics();
            if (radarMetrics == null || !anchor.isMetricsEnable()) continue;
            anchor.getDimension().solveMetrics(radarMetrics);
            if (radarMetrics.getGlyphMetricMarkerPainter() != null) {
                radarMetrics.getGlyphMetricMarkerPainter().paintGlyphMetric(g2d, radarMetrics);
            }
            if (radarMetrics.getGlyphMetricFill() != null) {
                radarMetrics.getGlyphMetricFill().paintGlyphMetric(g2d, radarMetrics);
            }
            if (radarMetrics.getGlyphMetricDraw() == null) continue;
            radarMetrics.getGlyphMetricDraw().paintGlyphMetric(g2d, radarMetrics);
        }
    }

    public static enum SurfaceStyle {
        Stroke,
        Fill,
        Both;

    }
}

