/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.ray;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import org.jensoft.core.plugin.ray.RayPlugin;
import org.jensoft.core.plugin.ray.painter.axis.AbstractRayAxisLabel;
import org.jensoft.core.plugin.ray.painter.draw.AbstractRayDraw;
import org.jensoft.core.plugin.ray.painter.effect.AbstractRayEffect;
import org.jensoft.core.plugin.ray.painter.fill.AbstractRayFill;
import org.jensoft.core.plugin.ray.painter.label.AbstractRayLabel;
import org.jensoft.core.view.View;

public class Ray {
    private String name;
    private Color themeColor;
    private double thickness;
    private ThicknessType thicknessType;
    private double ray;
    private double rayBase;
    private double rayValue;
    private boolean ascent = false;
    private boolean descent = false;
    private RayNature rayNature;
    private Rectangle2D rayShape;
    private AbstractRayDraw rayDraw;
    private AbstractRayFill rayFill;
    private AbstractRayEffect rayEffect;
    private AbstractRayLabel rayLabel;
    private AbstractRayAxisLabel rayAxisLabel;
    private RayPlugin host;
    private boolean lockEnter = false;
    private boolean inflating = false;
    private boolean deflating = false;

    public Ray() {
    }

    public Ray(String name) {
        this.name = name;
    }

    public AbstractRayDraw getRayDraw() {
        return this.rayDraw;
    }

    public void setRayDraw(AbstractRayDraw rayDraw) {
        this.rayDraw = rayDraw;
    }

    public AbstractRayFill getRayFill() {
        return this.rayFill;
    }

    public void setRayFill(AbstractRayFill rayFill) {
        this.rayFill = rayFill;
    }

    public AbstractRayEffect getRayEffect() {
        return this.rayEffect;
    }

    public void setRayEffect(AbstractRayEffect rayEffect) {
        this.rayEffect = rayEffect;
    }

    public AbstractRayLabel getRayLabel() {
        return this.rayLabel;
    }

    public void setRayLabel(AbstractRayLabel rayLabel) {
        this.rayLabel = rayLabel;
    }

    public AbstractRayAxisLabel getRayAxisLabel() {
        return this.rayAxisLabel;
    }

    public void setRayAxisLabel(AbstractRayAxisLabel rayAxisLabel) {
        this.rayAxisLabel = rayAxisLabel;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Color getThemeColor() {
        return this.themeColor;
    }

    public void setThemeColor(Color themeColor) {
        this.themeColor = themeColor;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public ThicknessType getThicknessType() {
        return this.thicknessType;
    }

    public void setThicknessType(ThicknessType thicknessType) {
        this.thicknessType = thicknessType;
    }

    public RayNature getRayNature() {
        return this.rayNature;
    }

    public void setRayNature(RayNature rayNature) {
        this.rayNature = rayNature;
    }

    public double getRay() {
        return this.ray;
    }

    public void setRay(double ray) {
        this.ray = ray;
    }

    public double getRayValue() {
        return this.rayValue;
    }

    public void setAscentValue(double value) {
        this.ascent = true;
        this.descent = false;
        if (value < 0.0) {
            throw new IllegalArgumentException("ray value should be greater than 0");
        }
        this.rayValue = value;
    }

    public void setDescentValue(double value) {
        this.ascent = false;
        this.descent = true;
        if (value < 0.0) {
            throw new IllegalArgumentException("ray value should be greater than 0");
        }
        this.rayValue = value;
    }

    public double getRayBase() {
        return this.rayBase;
    }

    public void setRayBase(double rayBase) {
        this.rayBase = rayBase;
    }

    public boolean isAscent() {
        return this.ascent;
    }

    public boolean isDescent() {
        return this.descent;
    }

    public Rectangle2D getRayShape() {
        return this.rayShape;
    }

    public void setRayShape(Rectangle2D rayShape) {
        this.rayShape = rayShape;
    }

    public RayPlugin getHost() {
        return this.host;
    }

    public void setHost(RayPlugin host) {
        this.host = host;
    }

    public boolean isLockEnter() {
        return this.lockEnter;
    }

    public void lockEnter() {
        if (!this.isLockEnter()) {
            this.lockEnter = true;
        }
    }

    public void unlockEnter() {
        if (this.isLockEnter()) {
            this.lockEnter = false;
        }
    }

    public boolean isInflating() {
        return this.inflating;
    }

    public void setInflating(boolean inflating) {
        this.inflating = inflating;
    }

    public boolean isDeflating() {
        return this.deflating;
    }

    public void setDeflating(boolean deflating) {
        this.deflating = deflating;
    }

    public void setLockEnter(boolean lockEnter) {
        this.lockEnter = lockEnter;
    }

    public void inflate(double deltaValue, int waitBeforeStarting, int delay, int step) {
        if (this.isInflating() || this.isDeflating()) {
            return;
        }
        Inflate inflate = new Inflate(deltaValue, waitBeforeStarting, delay, step);
        inflate.start();
    }

    public void deflate(double deltaValue, int waitBeforeStarting, int delay, int step) {
        if (this.isInflating() || this.isDeflating()) {
            return;
        }
        Deflate deflate = new Deflate(deltaValue, waitBeforeStarting, delay, step);
        deflate.start();
    }

    class Deflate
    extends Thread {
        private int waitBeforeStarting;
        private int step;
        private int delay;
        private double deltaValue;

        public Deflate(double deltaValue, int waitBeforeStarting, int delay, int step) {
            this.waitBeforeStarting = waitBeforeStarting;
            this.deltaValue = deltaValue;
            this.delay = delay;
            this.step = step;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Ray.this.setDeflating(true);
            try {
                Thread.sleep(this.waitBeforeStarting);
                double val = Ray.this.getRayValue();
                double valueByStep = this.deltaValue / (double)this.step;
                int delayByStep = this.delay / this.step;
                for (int i = 0; i < this.step; ++i) {
                    val -= valueByStep;
                    if (Ray.this.isAscent()) {
                        Ray.this.setAscentValue(val);
                    } else if (Ray.this.isDescent()) {
                        Ray.this.setDescentValue(val);
                    }
                    if (Ray.this.getHost() != null) {
                        Ray.this.getHost().resolveRayComponent(Ray.this);
                    }
                    if (Ray.this.getRayNature() == RayNature.XRay) {
                        Ray.this.getHost().getProjection().getView().repaintDeviceBand(View.DeviceBand.XBand, (int)Ray.this.getRayShape().getBounds().getX(), (int)Ray.this.getRayShape().getBounds().getWidth() + 1);
                    } else if (Ray.this.getRayNature() == RayNature.YRay) {
                        Ray.this.getHost().getProjection().getView().repaintDeviceBand(View.DeviceBand.YBand, (int)Ray.this.getRayShape().getBounds().getY(), (int)Ray.this.getRayShape().getBounds().getHeight() + 1);
                    }
                    Thread.sleep(delayByStep);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                Ray.this.setDeflating(false);
            }
        }
    }

    class Inflate
    extends Thread {
        private int waitBeforeStarting;
        private int step;
        private int delay;
        private double deltaValue;

        public Inflate(double deltaValue, int waitBeforeStarting, int delay, int step) {
            this.waitBeforeStarting = waitBeforeStarting;
            this.deltaValue = deltaValue;
            this.delay = delay;
            this.step = step;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Ray.this.setInflating(true);
            try {
                Thread.sleep(this.waitBeforeStarting);
                double val = Ray.this.getRayValue();
                double valueByStep = this.deltaValue / (double)this.step;
                int delayByStep = this.delay / this.step;
                for (int i = 0; i < this.step; ++i) {
                    val += valueByStep;
                    if (Ray.this.isAscent()) {
                        Ray.this.setAscentValue(val);
                    } else if (Ray.this.isDescent()) {
                        Ray.this.setDescentValue(val);
                    }
                    if (Ray.this.getHost() != null) {
                        Ray.this.getHost().resolveRayComponent(Ray.this);
                    }
                    if (Ray.this.getHost() != null) {
                        if (Ray.this.getRayNature() == RayNature.XRay) {
                            Ray.this.getHost().getProjection().getView().repaintDeviceBand(View.DeviceBand.XBand, (int)Ray.this.getRayShape().getBounds().getX(), (int)Ray.this.getRayShape().getBounds().getWidth() + 1);
                        } else if (Ray.this.getRayNature() == RayNature.YRay) {
                            Ray.this.getHost().getProjection().getView().repaintDeviceBand(View.DeviceBand.YBand, (int)Ray.this.getRayShape().getBounds().getY(), (int)Ray.this.getRayShape().getBounds().getHeight() + 1);
                        }
                    }
                    Thread.sleep(delayByStep);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                Ray.this.setInflating(false);
            }
        }
    }

    public static enum RayInflate {
        Ascent,
        Descent;

    }

    public static enum RayNature {
        XRay,
        YRay;

    }

    public static enum ThicknessType {
        Device,
        User;

    }
}

