/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.ray;

import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.metrics.AxisMetricsPlugin;
import org.jensoft.core.plugin.outline.OutlinePlugin;
import org.jensoft.core.plugin.ray.Ray;
import org.jensoft.core.plugin.ray.RayPlugin;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;

public class RayView
extends View {
    private static final long serialVersionUID = 4610374377279625205L;
    private Projection.Linear projection;
    private RayPlugin rayPlugin;
    private AxisMetricsPlugin.ModeledMetrics axisMiliMetricsX;
    private AxisMetricsPlugin.ModeledMetrics axisMiliMetricsY;

    public RayView(double minx, double maxx, double miny, double maxy) {
        this.setPlaceHolderAxisNorth(60);
        this.setPlaceHolderAxisSouth(60);
        this.setPlaceHolderAxisWest(60);
        this.setPlaceHolderAxisEast(60);
        this.createProjection(minx, maxx, miny, maxy);
        this.registerPlugin();
    }

    public void registerPlugin(AbstractPlugin plugin) {
        this.projection.registerPlugin(plugin);
    }

    public void addRay(Ray ray) {
        this.rayPlugin.addRay(ray);
    }

    private void createProjection(double minx, double maxx, double miny, double maxy) {
        this.projection = new Projection.Linear(minx, maxx, miny, maxy);
        this.registerProjection(this.projection);
    }

    private void registerPlugin() {
        this.rayPlugin = new RayPlugin();
        this.rayPlugin.setPriority(10);
        this.projection.registerPlugin(this.rayPlugin);
        this.axisMiliMetricsY = new AxisMetricsPlugin.ModeledMetrics(AxisMetricsPlugin.Axis.AxisWest);
        this.axisMiliMetricsX = new AxisMetricsPlugin.ModeledMetrics(AxisMetricsPlugin.Axis.AxisSouth);
        this.projection.registerPlugin(this.axisMiliMetricsX);
        this.projection.registerPlugin(this.axisMiliMetricsY);
        this.projection.registerPlugin(new OutlinePlugin());
    }

    public Projection getProjection() {
        return this.projection;
    }

    public RayPlugin getRayPlugin() {
        return this.rayPlugin;
    }
}

