/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.ray;

import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.ray.Ray;
import org.jensoft.core.plugin.ray.RayStack;

public class StackedRay
extends Ray {
    private List<RayStack> stacks = new ArrayList<RayStack>();

    public double getStackBase(RayStack stack) {
        double base = super.getRayBase();
        for (RayStack s : this.stacks) {
            if (stack.equals(s)) {
                return base;
            }
            if (this.isAscent()) {
                base += s.getNormalizedValue();
                continue;
            }
            if (!this.isDescent()) continue;
            base -= s.getNormalizedValue();
        }
        return base;
    }

    public void addStack(RayStack rStack) {
        if (rStack == null) {
            throw new IllegalArgumentException("stack can not be null.");
        }
        if (rStack.getValue() < 0.0) {
            throw new IllegalArgumentException("stack value value should be greater than 0");
        }
        rStack.setHost(this);
        this.stacks.add(rStack);
    }

    public void normalize() {
        double deltaValue = Math.abs(this.getRayValue());
        double stacksValue = 0.0;
        for (RayStack s : this.stacks) {
            stacksValue += s.getValue();
        }
        for (RayStack s : this.stacks) {
            s.setNormalizedValue(s.getValue() * deltaValue / stacksValue);
        }
    }

    public List<RayStack> getStacks() {
        return this.stacks;
    }

    public void setStacks(List<RayStack> stacks) {
        this.stacks = stacks;
    }
}

