/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.shell;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jensoft.core.palette.color.Alpha;
import org.jensoft.core.palette.color.NanoChromatique;
import org.jensoft.core.palette.color.Spectral;
import org.jensoft.core.palette.color.TangoPalette;
import org.jensoft.core.plugin.shell.ShellPlugin;
import org.jensoft.core.sharedicon.SharedIcon;
import org.jensoft.core.sharedicon.common.Common;

public abstract class Shell
extends JComponent {
    static final long serialVersionUID = 2615212624870835049L;
    private ShellPlugin host;
    private boolean visibleMessage = false;
    private String title;
    private int shellWidth = 300;
    private int shellHeight = 150;
    private Header header;
    int xStartMove;
    int yStartMove;
    boolean move = false;
    boolean resize = false;
    private JPanel editor;
    private boolean lockDeleteBackground = false;
    private boolean lockMinimizeBackground = false;
    private boolean lockMaximizeBackground = false;
    private boolean lockMinimize = true;
    private boolean lockMaximize = false;
    private Rectangle2D miniFrame;
    private boolean lockMiniFrameRollover = false;
    private SizerComponent NSizer;
    private SizerComponent SSizer;
    private SizerComponent WSizer;
    private SizerComponent ESizer;
    private SizerComponent NESizer;
    private SizerComponent NWSizer;
    private SizerComponent SESizer;
    private SizerComponent SWSizer;
    private JComponent shellEditor = this.createShellEditor();

    public Shell() {
        this.editor = new JPanel();
        this.editor.setOpaque(false);
        this.NSizer = new SizerComponent(SizerPart.N);
        this.SSizer = new SizerComponent(SizerPart.S);
        this.WSizer = new SizerComponent(SizerPart.W);
        this.ESizer = new SizerComponent(SizerPart.E);
        this.NESizer = new SizerComponent(SizerPart.NE);
        this.NWSizer = new SizerComponent(SizerPart.NW);
        this.SESizer = new SizerComponent(SizerPart.SE);
        this.SWSizer = new SizerComponent(SizerPart.SW);
        this.header = new Header();
        this.header.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (Shell.this.move) {
                    int tx = e.getX();
                    int ty = e.getY();
                    int x = (int)(Shell.this.getBounds().getX() + (double)(tx - Shell.this.xStartMove));
                    int y = (int)(Shell.this.getBounds().getY() + (double)(ty - Shell.this.yStartMove));
                    int width = (int)Shell.this.getBounds().getWidth();
                    int height = (int)Shell.this.getBounds().getHeight();
                    if (x < 5) {
                        x = 5;
                    }
                    if (x + width > Shell.this.getHost().getProjection().getDevice2D().getDeviceWidth() - 5) {
                        x = Shell.this.getHost().getProjection().getDevice2D().getDeviceWidth() - width - 5;
                    }
                    if (y < 5) {
                        y = 5;
                    }
                    if (y + height > Shell.this.getHost().getProjection().getDevice2D().getDeviceHeight() - 5) {
                        y = Shell.this.getHost().getProjection().getDevice2D().getDeviceHeight() - height - 5;
                    }
                    Rectangle newBound = new Rectangle(x, y, width, height);
                    Shell.this.setBounds(newBound);
                }
            }
        });
        this.header.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Shell.this.move = true;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Shell.this.xStartMove = e.getX();
                Shell.this.yStartMove = e.getY();
                Shell.this.move = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Shell.this.move = true;
                Shell.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Shell.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.add(this.NSizer);
        this.add(this.SSizer);
        this.add(this.WSizer);
        this.add(this.ESizer);
        this.add(this.NESizer);
        this.add(this.NWSizer);
        this.add(this.SESizer);
        this.add(this.SWSizer);
        this.add(this.header);
        this.add(this.editor);
        this.editor.add(this.shellEditor);
    }

    public JPanel getEditor() {
        return this.editor;
    }

    public void setShellDimension(int width, int height) {
        this.shellWidth = width;
        this.shellHeight = height;
    }

    @Override
    public void setSize(Dimension d) {
        this.setShellDimension((int)d.getWidth(), (int)d.getHeight());
    }

    @Override
    public void setSize(int width, int height) {
        this.setShellDimension(width, height);
    }

    public int getShellWidth() {
        return this.shellWidth;
    }

    public void setShellWidth(int messageWidth) {
        this.shellWidth = messageWidth;
    }

    public int getShellHeight() {
        return this.shellHeight;
    }

    public void setShellHeight(int messageHeight) {
        this.shellHeight = messageHeight;
    }

    public Rectangle2D getMiniFrame() {
        return this.miniFrame;
    }

    public void setMessageTitleColor(Color fg) {
        this.header.titleLabel.setForeground(fg);
    }

    public void setMiniFrame(Rectangle2D miniFrame) {
        this.miniFrame = miniFrame;
    }

    public boolean isLockDeleteBackground() {
        return this.lockDeleteBackground;
    }

    public void setLockDeleteBackground(boolean lockDeleteBackground) {
        this.lockDeleteBackground = lockDeleteBackground;
    }

    public boolean isLockMinimizeBackground() {
        return this.lockMinimizeBackground;
    }

    public void setLockMinimizeBackground(boolean lockMinimizeBackground) {
        this.lockMinimizeBackground = lockMinimizeBackground;
    }

    public boolean isLockMaximize() {
        return this.lockMaximize;
    }

    public void setLockMaximize(boolean lockMaximize) {
        this.lockMaximize = lockMaximize;
    }

    public boolean isLockMaximizeBackground() {
        return this.lockMaximizeBackground;
    }

    public void setLockMaximizeBackground(boolean lockMaximizeBackground) {
        this.lockMaximizeBackground = lockMaximizeBackground;
    }

    public boolean isLockMinimize() {
        return this.lockMinimize;
    }

    public void setLockMinimize(boolean lockMinimize) {
        this.lockMinimize = lockMinimize;
    }

    public boolean isLockMiniFrameRollover() {
        return this.lockMiniFrameRollover;
    }

    public void setLockMiniFrameRollover(boolean lockMinimizedFrameRollover) {
        this.lockMiniFrameRollover = lockMinimizedFrameRollover;
    }

    public Shell(String title) {
        this();
        this.setTitle(title);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.header.setTitle(title);
    }

    public boolean isVisibleMessage() {
        return this.visibleMessage;
    }

    public void setVisibleMessage(boolean visibleMessage) {
        this.visibleMessage = visibleMessage;
    }

    public void onClose() {
    }

    protected abstract JComponent createShellEditor();

    @Override
    public void setBounds(int x, int y, int width, int height) {
        try {
            super.setBounds(x, y, width, height);
            int sizerSensible = 6;
            int headerHeight = 30;
            this.header.setBounds(sizerSensible, sizerSensible, width - 2 * sizerSensible, headerHeight);
            this.NSizer.setBounds(sizerSensible, 0, width - 2 * sizerSensible, sizerSensible);
            this.SSizer.setBounds(sizerSensible, height - sizerSensible, width - 2 * sizerSensible, sizerSensible);
            this.WSizer.setBounds(0, sizerSensible, sizerSensible, height - 2 * sizerSensible);
            this.ESizer.setBounds(width - sizerSensible, sizerSensible, sizerSensible, height - 2 * sizerSensible);
            this.NESizer.setBounds(width - sizerSensible, 0, sizerSensible, sizerSensible);
            this.NWSizer.setBounds(0, 0, sizerSensible, sizerSensible);
            this.SESizer.setBounds(width - sizerSensible, height - sizerSensible, sizerSensible, sizerSensible);
            this.SWSizer.setBounds(0, height - sizerSensible, sizerSensible, sizerSensible);
            this.editor.setBounds(sizerSensible, headerHeight + sizerSensible, width - 2 * sizerSensible, height - headerHeight - 2 * sizerSensible);
            this.shellEditor.setBounds(0, 0, width - 2 * sizerSensible, height - headerHeight - 2 * sizerSensible);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public ShellPlugin getHost() {
        return this.host;
    }

    public void setHost(ShellPlugin host) {
        this.host = host;
    }

    @Override
    protected void paintComponent(Graphics g) {
        RectangularShape r = null;
        r = !this.isLockMaximize() ? new RoundRectangle2D.Double(0.0, 0.0, this.getWidth() - 2, this.getHeight() - 2, 20.0, 20.0) : new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
        Graphics2D g2d = (Graphics2D)g;
        if (this.lockDeleteBackground) {
            g2d.setColor(new Alpha(Color.red, 80));
        } else if (this.lockMinimizeBackground) {
            g2d.setColor(new Alpha(Color.YELLOW, 80));
        } else if (this.lockMaximizeBackground) {
            g2d.setColor(new Alpha(TangoPalette.ORANGE3, 80));
        } else {
            g2d.setColor(new Alpha(Spectral.SPECTRAL_BLUE2, 80));
        }
        g2d.fill(r);
        g2d.setStroke(new BasicStroke(1.0f));
        if (this.lockDeleteBackground) {
            g2d.setColor(new Alpha(Color.red, 250));
        } else if (this.lockMinimizeBackground) {
            g2d.setColor(new Alpha(Color.WHITE, 240));
        } else if (!this.isLockMaximize()) {
            g2d.setColor(new Alpha(Color.WHITE, 240));
            g2d.draw(r);
        }
    }

    class SizerComponent
    extends JComponent {
        private SizerPart part;
        private int startX;
        private int startY;
        private int currentX;
        private int currentY;

        public SizerComponent(SizerPart part) {
            this.part = part;
            this.createSizerListener();
        }

        private void resizeMessage() {
            int deltaX = this.currentX - this.startX;
            int deltaY = this.currentY - this.startY;
            Rectangle r = Shell.this.getBounds();
            Rectangle newBound = null;
            if (this.part == SizerPart.N) {
                newBound = new Rectangle((int)r.getX(), (int)(r.getY() + (double)deltaY), (int)r.getWidth(), (int)(r.getHeight() - (double)deltaY));
            } else if (this.part == SizerPart.S) {
                newBound = new Rectangle((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)(r.getHeight() + (double)deltaY));
            } else if (this.part == SizerPart.W) {
                newBound = new Rectangle((int)(r.getX() + (double)deltaX), (int)r.getY(), (int)(r.getWidth() - (double)deltaX), (int)r.getHeight());
            } else if (this.part == SizerPart.E) {
                newBound = new Rectangle((int)r.getX(), (int)r.getY(), (int)(r.getWidth() + (double)deltaX), (int)r.getHeight());
            } else if (this.part == SizerPart.NE) {
                newBound = new Rectangle((int)r.getX(), (int)(r.getY() + (double)deltaY), (int)(r.getWidth() + (double)deltaX), (int)(r.getHeight() - (double)deltaY));
            } else if (this.part == SizerPart.NW) {
                newBound = new Rectangle((int)(r.getX() + (double)deltaX), (int)(r.getY() + (double)deltaY), (int)(r.getWidth() - (double)deltaX), (int)(r.getHeight() - (double)deltaY));
            } else if (this.part == SizerPart.SE) {
                newBound = new Rectangle((int)r.getX(), (int)r.getY(), (int)(r.getWidth() + (double)deltaX), (int)(r.getHeight() + (double)deltaY));
            } else if (this.part == SizerPart.SW) {
                newBound = new Rectangle((int)(r.getX() + (double)deltaX), (int)r.getY(), (int)(r.getWidth() - (double)deltaX), (int)(r.getHeight() + (double)deltaY));
            }
            if (newBound.getX() < 5.0 || newBound.getX() + newBound.getWidth() > (double)(Shell.this.getHost().getProjection().getDevice2D().getDeviceWidth() - 5)) {
                return;
            }
            if (newBound.getY() < 5.0 || newBound.getY() + newBound.getHeight() > (double)(Shell.this.getHost().getProjection().getDevice2D().getDeviceHeight() - 5)) {
                return;
            }
            Shell.this.setBounds(newBound);
        }

        private void createSizerListener() {
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (!Shell.this.resize) {
                        return;
                    }
                    if (SizerComponent.this.part == SizerPart.N) {
                        Shell.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(8));
                    } else if (SizerComponent.this.part == SizerPart.S) {
                        Shell.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(9));
                    } else if (SizerComponent.this.part == SizerPart.W) {
                        Shell.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(10));
                    } else if (SizerComponent.this.part == SizerPart.E) {
                        Shell.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(11));
                    } else if (SizerComponent.this.part == SizerPart.NE) {
                        Shell.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(7));
                    } else if (SizerComponent.this.part == SizerPart.NW) {
                        Shell.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(6));
                    } else if (SizerComponent.this.part == SizerPart.SE) {
                        Shell.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(5));
                    } else if (SizerComponent.this.part == SizerPart.SW) {
                        Shell.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(4));
                    }
                    SizerComponent.this.currentX = e.getX();
                    SizerComponent.this.currentY = e.getY();
                    SizerComponent.this.resizeMessage();
                }
            });
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    Shell.this.resize = false;
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    Shell.this.resize = true;
                    SizerComponent.this.startX = e.getX();
                    SizerComponent.this.startY = e.getY();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (Shell.this.resize) {
                        return;
                    }
                    Shell.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(0));
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (Shell.this.resize) {
                        return;
                    }
                    if (SizerComponent.this.part == SizerPart.N) {
                        Shell.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(8));
                    } else if (SizerComponent.this.part == SizerPart.S) {
                        Shell.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(9));
                    } else if (SizerComponent.this.part == SizerPart.W) {
                        Shell.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(10));
                    } else if (SizerComponent.this.part == SizerPart.E) {
                        Shell.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(11));
                    } else if (SizerComponent.this.part == SizerPart.NE) {
                        Shell.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(7));
                    } else if (SizerComponent.this.part == SizerPart.NW) {
                        Shell.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(6));
                    } else if (SizerComponent.this.part == SizerPart.SE) {
                        Shell.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(5));
                    } else if (SizerComponent.this.part == SizerPart.SW) {
                        Shell.this.getHost().getProjection().getView().setCursor(Cursor.getPredefinedCursor(4));
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }
            });
        }
    }

    public static enum SizerPart {
        N,
        S,
        W,
        E,
        NE,
        NW,
        SE,
        SW;

    }

    class Header
    extends JComponent {
        private static final long serialVersionUID = -6679725693988970902L;
        JLabel titleLabel;
        JLabel close;
        JLabel maximize;
        JLabel minimize;

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
            this.titleLabel.setBounds(10, y, 260, height);
            this.minimize.setBounds(width - 65, y, 20, height);
            this.maximize.setBounds(width - 45, y, 20, height);
            this.close.setBounds(width - 25, y, 20, height);
            this.add(this.titleLabel);
            this.add(this.minimize);
            this.add(this.maximize);
            this.add(this.close);
        }

        public void setTitle(String title) {
            this.titleLabel.setText(title);
        }

        public Header() {
            ImageIcon iconClose = SharedIcon.getCommon(Common.CLOSE_SQUARE);
            ImageIcon iconMaximize = SharedIcon.getCommon(Common.MAXIMIZE_SQUARE);
            ImageIcon iconMinimize = SharedIcon.getCommon(Common.MINIMIZE_SQUARE);
            this.titleLabel = new JLabel("");
            this.titleLabel.setForeground(NanoChromatique.ORANGE);
            this.add(this.titleLabel);
            this.close = new JLabel("");
            this.close.setIcon(iconClose);
            this.add(this.close);
            this.close.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Shell.this.getHost().closeCurrentMessage();
                    Shell.this.onClose();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    super.mouseEntered(e);
                    Shell.this.lockDeleteBackground = true;
                    if (Shell.this.getHost() != null) {
                        Shell.this.getHost().repaintDevice();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    super.mouseReleased(e);
                    Shell.this.lockDeleteBackground = false;
                    if (Shell.this.getHost() != null) {
                        Shell.this.getHost().repaintDevice();
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    super.mouseExited(e);
                    Shell.this.lockDeleteBackground = false;
                    Shell.this.getHost().repaintDevice();
                }
            });
            this.maximize = new JLabel("");
            this.maximize.setIcon(iconMaximize);
            this.add(this.maximize);
            this.maximize.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Shell.this.lockMaximize = true;
                    Shell.this.lockMinimize = false;
                    Shell.this.lockMaximizeBackground = false;
                    Shell.this.getHost().maximizeMessage(Shell.this);
                    Shell.this.getHost().repaintDevice();
                    Header.this.maximize.setEnabled(false);
                    Header.this.minimize.setEnabled(true);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    super.mouseEntered(e);
                    if (!Shell.this.lockMaximize) {
                        Shell.this.lockMaximizeBackground = true;
                        Shell.this.getHost().repaintDevice();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    super.mouseReleased(e);
                    if (!Shell.this.lockMaximize) {
                        Shell.this.lockMaximizeBackground = false;
                        Shell.this.getHost().repaintDevice();
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    super.mouseExited(e);
                    Shell.this.lockMaximizeBackground = false;
                    Shell.this.getHost().repaintDevice();
                }
            });
            this.minimize = new JLabel("");
            this.minimize.setIcon(iconMinimize);
            this.minimize.setEnabled(false);
            this.add(this.minimize);
            this.minimize.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Shell.this.lockMinimize = true;
                    Shell.this.lockMinimizeBackground = false;
                    if (Shell.this.lockMaximize) {
                        Shell.this.getHost().unMaximizeMessage(Shell.this);
                        Shell.this.lockMaximize = false;
                    }
                    Header.this.maximize.setEnabled(true);
                    Header.this.minimize.setEnabled(false);
                    Shell.this.getHost().repaintDevice();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    super.mouseEntered(e);
                    if (!Shell.this.lockMinimize) {
                        Shell.this.lockMinimizeBackground = true;
                        Shell.this.getHost().repaintDevice();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    super.mouseReleased(e);
                    if (!Shell.this.lockMinimize) {
                        Shell.this.lockMinimizeBackground = false;
                        Shell.this.getHost().repaintDevice();
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    super.mouseExited(e);
                    Shell.this.lockMinimizeBackground = false;
                    Shell.this.getHost().repaintDevice();
                }
            });
        }
    }
}

