/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.stock;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.palette.color.NanoChromatique;
import org.jensoft.core.palette.color.RosePalette;
import org.jensoft.core.plugin.stock.Stock;
import org.jensoft.core.plugin.stock.StockPlugin;
import org.jensoft.core.plugin.stock.geom.BollingerMovingAverageStockGeom;
import org.jensoft.core.plugin.stock.geom.CandleStickGeom;
import org.jensoft.core.plugin.stock.geom.CurveStockGeom;
import org.jensoft.core.plugin.stock.geom.ExponentialMovingAverageStockGeom;
import org.jensoft.core.plugin.stock.geom.FixingStockGeom;
import org.jensoft.core.plugin.stock.geom.MovingAverageStockGeom;
import org.jensoft.core.plugin.stock.geom.OhlcGeom;
import org.jensoft.core.plugin.stock.geom.StockGeometry;
import org.jensoft.core.plugin.stock.geom.StockGroupGeometry;
import org.jensoft.core.plugin.stock.geom.StockItemGeometry;
import org.jensoft.core.plugin.stock.geom.VolumeBarGeometry;
import org.jensoft.core.plugin.stock.geom.WeightedMovingAverageStockGeom;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public abstract class StockLayer<G extends StockGeometry> {
    private StockPlugin host;
    private List<G> geometries = new ArrayList<G>();

    public StockPlugin getHost() {
        return this.host;
    }

    public void setHost(StockPlugin host) {
        this.host = host;
    }

    public List<G> getGeometries() {
        return this.geometries;
    }

    public void setGeometries(List<G> geometries) {
        this.geometries = geometries;
    }

    public void addGeometry(G geometry) {
        this.geometries.add(geometry);
    }

    protected abstract void solveLayer();

    protected abstract void paintLayer(View var1, Graphics2D var2, ViewPart var3);

    public static class BollingerBands
    extends Curve<BollingerMovingAverageStockGeom> {
        private int moveCount = 20;
        private Color bollingerUpLineColor = RosePalette.INDIGO.brighter();
        private Color bollingerBottomLineColor = RosePalette.INDIGO.brighter();

        public BollingerBands(int moveCount) {
            this.moveCount = moveCount;
        }

        public BollingerBands(Color curveColor, int moveCount) {
            super(curveColor);
            this.moveCount = moveCount;
        }

        public BollingerBands(int moveCount, Color curveColor, Color bollingerUpLineColor, Color bollingerBottomLineColor) {
            super(curveColor);
            this.moveCount = moveCount;
            this.bollingerUpLineColor = bollingerUpLineColor;
            this.bollingerBottomLineColor = bollingerBottomLineColor;
        }

        @Override
        protected BollingerMovingAverageStockGeom getGeomInstance() {
            return new BollingerMovingAverageStockGeom(this.moveCount);
        }

        @Override
        protected void paintLayer(View view, Graphics2D g2d, ViewPart viewPart) {
            super.paintLayer(view, g2d, viewPart);
            if (viewPart == ViewPart.Device) {
                for (CurveStockGeom geom : this.getGeometries()) {
                    BollingerMovingAverageStockGeom bollingerGeom = (BollingerMovingAverageStockGeom)geom;
                    bollingerGeom.getPathFunctionUp().setSolveGeometryRequest(true);
                    bollingerGeom.getPathFunctionUp().setProjection(this.getHost().getProjection());
                    bollingerGeom.getPathFunctionUp().setFontRenderContext(g2d.getFontRenderContext());
                    bollingerGeom.getPathFunctionBottom().setSolveGeometryRequest(true);
                    bollingerGeom.getPathFunctionBottom().setProjection(this.getHost().getProjection());
                    bollingerGeom.getPathFunctionBottom().setFontRenderContext(g2d.getFontRenderContext());
                    g2d.setColor(this.bollingerUpLineColor);
                    Shape upFonction = bollingerGeom.getPathFunctionUp().getOrCreateGeometry().getPath();
                    g2d.draw(upFonction);
                    g2d.setColor(this.bollingerBottomLineColor);
                    Shape bottomFonction = bollingerGeom.getPathFunctionBottom().getOrCreateGeometry().getPath();
                    g2d.draw(bottomFonction);
                }
            }
        }
    }

    public static class ExponentialdMovingAverageCurve
    extends Curve<ExponentialMovingAverageStockGeom> {
        private int moveCount = 20;

        public ExponentialdMovingAverageCurve(int moveCount) {
            this.moveCount = moveCount;
        }

        public ExponentialdMovingAverageCurve(Color curveColor, int moveCount) {
            super(curveColor);
            this.moveCount = moveCount;
        }

        @Override
        protected ExponentialMovingAverageStockGeom getGeomInstance() {
            return new ExponentialMovingAverageStockGeom(this.moveCount);
        }
    }

    public static class WeightedMovingAverageCurve
    extends Curve<WeightedMovingAverageStockGeom> {
        private int moveCount = 20;

        public WeightedMovingAverageCurve(int moveCount) {
            this.moveCount = moveCount;
        }

        public WeightedMovingAverageCurve(Color curveColor, int moveCount) {
            super(curveColor);
            this.moveCount = moveCount;
        }

        @Override
        protected WeightedMovingAverageStockGeom getGeomInstance() {
            return new WeightedMovingAverageStockGeom(this.moveCount);
        }
    }

    public static class MovingAverageCurve
    extends Curve<MovingAverageStockGeom> {
        private int moveCount = 20;

        public MovingAverageCurve(int moveCount) {
            this.moveCount = moveCount;
        }

        public MovingAverageCurve(Color curveColor, int moveCount) {
            super(curveColor);
            this.moveCount = moveCount;
        }

        @Override
        protected MovingAverageStockGeom getGeomInstance() {
            return new MovingAverageStockGeom(this.moveCount);
        }
    }

    public static class FixingCurve
    extends Curve<FixingStockGeom> {
        public FixingCurve() {
        }

        public FixingCurve(Color curveColor) {
            super(curveColor);
        }

        @Override
        protected FixingStockGeom getGeomInstance() {
            return new FixingStockGeom();
        }
    }

    public static abstract class Curve<C extends CurveStockGeom>
    extends StockLayer<CurveStockGeom> {
        private Color curveColor = NanoChromatique.BLUE;

        public Curve() {
        }

        public Curve(Color curveColor) {
            this.curveColor = curveColor;
        }

        public Color getCurveColor() {
            return this.curveColor;
        }

        public void setCurveColor(Color curveColor) {
            this.curveColor = curveColor;
        }

        @Override
        protected void solveLayer() {
            this.getGeometries().clear();
            C geom = this.getGeomInstance();
            ((StockGeometry)geom).setLayer(this);
            for (Stock stock : this.getHost().getStocks()) {
                StockItemGeometry itemGeom = new StockItemGeometry();
                itemGeom.setStock(stock);
                itemGeom.setLayer(this);
                ((StockGroupGeometry)geom).addStockItemGeometries(itemGeom);
            }
            ((StockGeometry)geom).solveGeometry();
            this.addGeometry(geom);
        }

        protected abstract C getGeomInstance();

        @Override
        protected void paintLayer(View view, Graphics2D g2d, ViewPart viewPart) {
            if (viewPart == ViewPart.Device) {
                for (CurveStockGeom geom : this.getGeometries()) {
                    g2d.setColor(this.curveColor);
                    geom.getPathFunction().setSolveGeometryRequest(true);
                    geom.getPathFunction().setProjection(this.getHost().getProjection());
                    geom.getPathFunction().setFontRenderContext(g2d.getFontRenderContext());
                    Shape s = geom.getPathFunction().getOrCreateGeometry().getPath();
                    g2d.draw(s);
                }
            }
        }
    }

    public static class Volume
    extends StockLayer<VolumeBarGeometry> {
        private Color volumeFillColor = NanoChromatique.BLUE;

        public Volume() {
        }

        public Volume(Color volumeFillColor) {
            this.volumeFillColor = volumeFillColor;
        }

        public Color getVolumeFillColor() {
            return this.volumeFillColor;
        }

        public void setVolumeFillColor(Color volumeFillColor) {
            this.volumeFillColor = volumeFillColor;
        }

        @Override
        protected void solveLayer() {
            this.getGeometries().clear();
            for (Stock stock : this.getHost().getStocks()) {
                VolumeBarGeometry geom = new VolumeBarGeometry();
                geom.setStock(stock);
                geom.setLayer(this);
                geom.solveGeometry();
                this.addGeometry(geom);
            }
        }

        @Override
        protected void paintLayer(View v2d, Graphics2D g2d, ViewPart viewPart) {
            if (viewPart == ViewPart.Device) {
                for (VolumeBarGeometry geom : this.getGeometries()) {
                    g2d.setColor(this.volumeFillColor);
                    g2d.fill(geom.getDeviceVolumeGap());
                }
            }
        }

        public static enum VolumeType {
            Curve,
            Area,
            Bar;

        }
    }

    public static class Ohlc
    extends StockLayer<OhlcGeom> {
        @Override
        protected void solveLayer() {
            this.getGeometries().clear();
            for (Stock stock : this.getHost().getStocks()) {
                OhlcGeom geom = new OhlcGeom();
                geom.setLayer(this);
                geom.setStock(stock);
                geom.solveGeometry();
                this.addGeometry(geom);
            }
        }

        @Override
        protected void paintLayer(View view, Graphics2D g2d, ViewPart viewPart) {
            if (viewPart == ViewPart.Device) {
                for (OhlcGeom geom : this.getGeometries()) {
                    g2d.setColor(geom.getLowHighColor());
                    g2d.draw(geom.getDeviceLowHighGap());
                    g2d.draw(geom.getDeviceOpenTick());
                    g2d.draw(geom.getDeviceCloseTick());
                }
            }
        }
    }

    public static class CandleStick
    extends StockLayer<CandleStickGeom> {
        @Override
        protected void solveLayer() {
            this.getGeometries().clear();
            for (Stock stock : this.getHost().getStocks()) {
                CandleStickGeom geom = new CandleStickGeom();
                geom.setLayer(this);
                geom.setStock(stock);
                geom.solveGeometry();
                this.addGeometry(geom);
            }
        }

        @Override
        protected void paintLayer(View view, Graphics2D g2d, ViewPart viewPart) {
            if (viewPart == ViewPart.Device) {
                for (CandleStickGeom geom : this.getGeometries()) {
                    g2d.setColor(geom.getLowHighColor());
                    g2d.draw(geom.getDeviceLowHighGap());
                    if (geom.getStock().isBearish()) {
                        g2d.setColor(geom.getStock().getBearishColor());
                    } else {
                        g2d.setColor(geom.getStock().getBullishColor());
                    }
                    g2d.fill(geom.getDeviceLowOpenCloseGap());
                }
            }
        }
    }
}

