/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.stock.geom;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jensoft.core.plugin.function.MetricsPathFunction;
import org.jensoft.core.plugin.function.source.UserSourceFunction;
import org.jensoft.core.plugin.stock.Stock;
import org.jensoft.core.plugin.stock.geom.CurveStockGeom;

public class BollingerMovingAverageStockGeom
extends CurveStockGeom {
    private MetricsPathFunction pathFunctionUp;
    private MetricsPathFunction pathFunctionBottom;
    private int moveCount = 20;

    public BollingerMovingAverageStockGeom(int moveCount) {
        this.moveCount = moveCount;
        this.pathFunctionUp = new MetricsPathFunction();
        this.pathFunctionBottom = new MetricsPathFunction();
    }

    public int getMoveCount() {
        return this.moveCount;
    }

    public void setMoveCount(int moveCount) {
        this.moveCount = moveCount;
    }

    @Override
    public void solveGeometry() {
        ArrayList<Point2D> upperPoint = new ArrayList<Point2D>();
        ArrayList<Point2D> bottomPoint = new ArrayList<Point2D>();
        ArrayList<Point2D> stockMAs = new ArrayList<Point2D>();
        List<Stock> stocks = this.getLayer().getHost().getStocks();
        Collections.sort(stocks, new StockComparator());
        for (int i = this.moveCount; i < stocks.size(); ++i) {
            Stock root = stocks.get(i);
            double sum = 0.0;
            for (int j = 0; j < this.moveCount; ++j) {
                Stock s = stocks.get(i - j);
                sum += s.getClose();
            }
            double movingAverage = sum / (double)this.moveCount;
            stockMAs.add(new Point2D.Double(new Long(root.getFixing().getTime()).doubleValue(), movingAverage));
            double squarred = 0.0;
            for (int j = 0; j < this.moveCount; ++j) {
                Stock s = stocks.get(i - j);
                squarred += Math.pow(s.getClose() - movingAverage, 2.0);
            }
            double deviation = Math.sqrt(squarred / new Double(this.moveCount));
            upperPoint.add(new Point2D.Double(new Long(root.getFixing().getTime()).doubleValue(), movingAverage + 2.0 * deviation));
            bottomPoint.add(new Point2D.Double(new Long(root.getFixing().getTime()).doubleValue(), movingAverage - 2.0 * deviation));
        }
        UserSourceFunction.LineSource averageSourceFunction = new UserSourceFunction.LineSource(stockMAs);
        this.getPathFunction().setSource(averageSourceFunction);
        UserSourceFunction.LineSource upperSourceFunction = new UserSourceFunction.LineSource(upperPoint);
        this.getPathFunctionUp().setSource(upperSourceFunction);
        UserSourceFunction.LineSource bottomSourceFunction = new UserSourceFunction.LineSource(bottomPoint);
        this.getPathFunctionBottom().setSource(bottomSourceFunction);
    }

    public MetricsPathFunction getPathFunctionUp() {
        return this.pathFunctionUp;
    }

    public MetricsPathFunction getPathFunctionBottom() {
        return this.pathFunctionBottom;
    }

    public class StockComparator
    implements Comparator<Stock> {
        @Override
        public int compare(Stock s1, Stock s2) {
            return s1.getFixing().compareTo(s2.getFixing());
        }
    }
}

