/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.stock.geom;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jensoft.core.plugin.function.source.UserSourceFunction;
import org.jensoft.core.plugin.stock.Stock;
import org.jensoft.core.plugin.stock.geom.CurveStockGeom;

public class ExponentialMovingAverageStockGeom
extends CurveStockGeom {
    private int moveCount = 20;

    public ExponentialMovingAverageStockGeom() {
    }

    public ExponentialMovingAverageStockGeom(int moveCount) {
        this.moveCount = moveCount;
    }

    public int getMoveCount() {
        return this.moveCount;
    }

    public void setMoveCount(int moveCount) {
        this.moveCount = moveCount;
    }

    @Override
    public void solveGeometry() {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        List<Stock> stocks = this.getLayer().getHost().getStocks();
        Collections.sort(stocks, new StockComparator());
        double alpha = 2 / (this.moveCount + 1);
        for (int i = this.moveCount; i < stocks.size(); ++i) {
            Stock root = stocks.get(i);
            double sum = root.getClose();
            double divider = 1.0;
            for (int j = 1; j < this.moveCount; ++j) {
                Stock s = stocks.get(i - j);
                sum += Math.pow(1.0 - alpha, j) * s.getClose();
                divider += Math.pow(1.0 - alpha, j);
            }
            double movingAverage = sum / divider;
            points.add(new Point2D.Double(new Long(root.getFixing().getTime()).doubleValue(), movingAverage));
        }
        UserSourceFunction.LineSource sourceFunction = new UserSourceFunction.LineSource(points);
        this.getPathFunction().setSource(sourceFunction);
    }

    public class StockComparator
    implements Comparator<Stock> {
        @Override
        public int compare(Stock s1, Stock s2) {
            return s1.getFixing().compareTo(s2.getFixing());
        }
    }
}

