/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.stripe;

import java.awt.Graphics2D;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.stripe.Stripe;
import org.jensoft.core.plugin.stripe.manager.AbstractStripeManager;
import org.jensoft.core.plugin.stripe.manager.FlowStripeManager;
import org.jensoft.core.plugin.stripe.manager.FreeStripeManager;
import org.jensoft.core.plugin.stripe.manager.MultiplierStripeManager;
import org.jensoft.core.plugin.stripe.manager.StripeManager;
import org.jensoft.core.plugin.stripe.painter.AbstractStripePainter;
import org.jensoft.core.plugin.stripe.painter.StripeDefaultPainter;
import org.jensoft.core.plugin.stripe.painter.StripePalette;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public abstract class StripePlugin<M extends AbstractStripeManager>
extends AbstractPlugin {
    private M stripeManager;
    private AbstractStripePainter stripePainter = new StripeDefaultPainter();

    public StripePlugin(M stripeManager) {
        this.stripeManager = stripeManager;
    }

    public M getStripeManager() {
        return this.stripeManager;
    }

    public void setStripeManager(M stripeManager) {
        this.stripeManager = stripeManager;
    }

    public void setAlpha(float alpha) {
        this.getPainter().setAlpha(alpha);
    }

    public void setStripePalette(StripePalette palette) {
        ((AbstractStripeManager)this.getStripeManager()).setStripePalette(palette);
    }

    public AbstractStripePainter getPainter() {
        return this.stripePainter;
    }

    public void setPainter(AbstractStripePainter bandLayoutPainter) {
        this.stripePainter = bandLayoutPainter;
    }

    protected void paintStripes(View v2d, Graphics2D g2d) {
        ((AbstractStripeManager)this.stripeManager).setProjection(this.getProjection());
        this.stripePainter.setBandManager((StripeManager)this.stripeManager);
        this.stripePainter.doPaintStripes(g2d);
    }

    @Override
    public final void paintPlugin(View v2d, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart == ViewPart.Device) {
            this.paintStripes(v2d, g2d);
        }
    }

    public static class FreeStripe
    extends StripePlugin<FreeStripeManager> {
        public FreeStripe(StripeOrientation stripeOrientation) {
            super(new FreeStripeManager(stripeOrientation));
        }

        public void addStripe(Stripe stripe) {
            ((FreeStripeManager)this.getStripeManager()).addStripe(stripe);
        }

        public static class V
        extends FreeStripe {
            public V() {
                super(StripeOrientation.Vertical);
            }
        }

        public static class H
        extends FreeStripe {
            public H() {
                super(StripeOrientation.Horizontal);
            }
        }
    }

    public static class FlowStripe
    extends StripePlugin<FlowStripeManager> {
        public FlowStripe(double start, double end, double interval, StripeOrientation stripeOrientation) {
            super(new FlowStripeManager(stripeOrientation, start, end, interval));
        }

        public static class V
        extends FlowStripe {
            public V(double start, double end, double interval) {
                super(start, end, interval, StripeOrientation.Vertical);
            }
        }

        public static class H
        extends FlowStripe {
            public H(double start, double end, double interval) {
                super(start, end, interval, StripeOrientation.Horizontal);
            }
        }
    }

    public static class MultiplierStripe
    extends StripePlugin<MultiplierStripeManager> {
        public MultiplierStripe(double ref, double interval, StripeOrientation stripeOrientation) {
            super(new MultiplierStripeManager(stripeOrientation, ref, interval));
        }

        public static class V
        extends MultiplierStripe {
            public V(double ref, double interval) {
                super(ref, interval, StripeOrientation.Vertical);
            }
        }

        public static class H
        extends MultiplierStripe {
            public H(double ref, double interval) {
                super(ref, interval, StripeOrientation.Horizontal);
            }
        }
    }

    public static enum StripeOrientation {
        Vertical("vertical"),
        Horizontal("horizontal");

        private String bandOrientation;

        private StripeOrientation(String orientation) {
            this.bandOrientation = orientation;
        }

        public String getBandOrientation() {
            return this.bandOrientation;
        }

        public static StripeOrientation parse(String orientation) {
            if (Vertical.getBandOrientation().equals(orientation)) {
                return Vertical;
            }
            if (Horizontal.getBandOrientation().equals(orientation)) {
                return Horizontal;
            }
            return null;
        }
    }
}

