/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.stripe.manager;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.stripe.Stripe;
import org.jensoft.core.plugin.stripe.StripePlugin;
import org.jensoft.core.plugin.stripe.manager.AbstractStripeManager;
import org.jensoft.core.plugin.stripe.painter.StripePaint;

public class FlowStripeManager
extends AbstractStripeManager {
    private double flowInterval;
    private double flowStart;
    private double flowEnd;
    private List<Stripe> deviceStripes = new ArrayList<Stripe>();

    public FlowStripeManager(StripePlugin.StripeOrientation stripeOrientation, double flowStart, double flowEnd, double flowInterval) {
        if (flowStart > flowEnd) {
            throw new IllegalArgumentException("Flow end should be greater than flow start");
        }
        if (flowInterval < 0.0) {
            throw new IllegalArgumentException("Flow interval should be greater than zero");
        }
        super.setStripeOrientation(stripeOrientation);
        this.flowStart = flowStart;
        this.flowEnd = flowEnd;
        this.flowInterval = flowInterval;
    }

    @Override
    public List<Stripe> getStripes() {
        this.deviceStripes.clear();
        double interval = this.flowEnd - this.flowStart;
        int stripeNumber = (int)(interval / this.flowInterval);
        int countPalette = 0;
        int maxCount = this.getStripePalette().getPalette().size() - 1;
        if (stripeNumber > 0) {
            for (int i = 0; i < stripeNumber; ++i) {
                StripePaint p;
                Stripe stripe;
                Point2D p2dDevice2;
                Point2D.Double p2dUser2;
                Point2D p2dDevice;
                Point2D.Double p2dUser;
                double g = this.flowStart + (double)i * this.flowInterval;
                if (this.getStripeOrientation() == StripePlugin.StripeOrientation.Vertical) {
                    p2dUser = new Point2D.Double(g, 0.0);
                    p2dDevice = this.getProjection().userToPixel(p2dUser);
                    p2dUser2 = new Point2D.Double(g + this.flowInterval, 0.0);
                    p2dDevice2 = this.getProjection().userToPixel(p2dUser2);
                    stripe = new Stripe(StripePlugin.StripeOrientation.Vertical);
                    stripe.setDeviceInterval(p2dDevice2.getX() - p2dDevice.getX());
                    stripe.deviceStart = p2dDevice.getX();
                    p = this.getStripePalette().getPaintPalette(countPalette);
                    stripe.setPaint(p);
                    this.deviceStripes.add(stripe);
                    if (countPalette++ != maxCount) continue;
                    countPalette = 0;
                    continue;
                }
                if (this.getStripeOrientation() != StripePlugin.StripeOrientation.Horizontal) continue;
                p2dUser = new Point2D.Double(0.0, g);
                p2dDevice = this.getProjection().userToPixel(p2dUser);
                p2dUser2 = new Point2D.Double(0.0, g + this.flowInterval);
                p2dDevice2 = this.getProjection().userToPixel(p2dUser2);
                stripe = new Stripe(StripePlugin.StripeOrientation.Horizontal);
                stripe.setDeviceInterval(p2dDevice.getY() - p2dDevice2.getY());
                stripe.deviceStart = p2dDevice2.getY();
                p = this.getStripePalette().getPaintPalette(countPalette);
                stripe.setPaint(p);
                this.deviceStripes.add(stripe);
                if (countPalette++ != maxCount) continue;
                countPalette = 0;
            }
        }
        return this.deviceStripes;
    }
}

