/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.stripe.manager;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.stripe.Stripe;
import org.jensoft.core.plugin.stripe.StripePlugin;
import org.jensoft.core.plugin.stripe.manager.AbstractStripeManager;
import org.jensoft.core.plugin.stripe.painter.StripePaint;

public class MultiplierStripeManager
extends AbstractStripeManager {
    private double ref = 0.0;
    private double interval = 0.0;
    private List<Stripe> stripes = new ArrayList<Stripe>();

    public MultiplierStripeManager(StripePlugin.StripeOrientation stripeOrientation, double ref, double interval) {
        super.setStripeOrientation(stripeOrientation);
        this.ref = ref;
        this.interval = interval;
    }

    private void addStripe(Stripe stripe) {
        boolean flag = false;
        for (Stripe b : this.stripes) {
            if (!stripe.equals(b)) continue;
            flag = true;
        }
        if (!flag) {
            this.stripes.add(stripe);
        }
    }

    @Override
    public List<Stripe> getStripes() {
        StripePaint p;
        Stripe stripe;
        Point2D p2dDeviceStripeEnd;
        Point2D.Double p2dUserStripeEnd;
        Point2D p2dDeviceStripeStart;
        Point2D.Double p2dUserStripeStart;
        StripePaint p2;
        Stripe stripe2;
        Point2D p2dDeviceStripeEnd2;
        Point2D.Double p2dUserStripeEnd2;
        boolean flag1;
        int count1;
        int maxCount;
        int countPalette;
        int stripeNumber;
        this.stripes.clear();
        if (this.getStripeOrientation() == StripePlugin.StripeOrientation.Vertical) {
            stripeNumber = (int)((this.getProjection().getMaxX() - this.getProjection().getMinX()) / this.interval);
            if (stripeNumber < 0 || stripeNumber > this.getStripeMaxNumber()) {
                this.stripes.clear();
                return this.stripes;
            }
            countPalette = 0;
            maxCount = this.getStripePalette().getPalette().size() - 1;
            count1 = 0;
            flag1 = true;
            while (flag1) {
                if (this.ref + (double)count1 * this.interval >= this.getProjection().getMinX() - this.interval && this.ref + (double)count1 * this.interval <= this.getProjection().getMaxX() + this.interval) {
                    Point2D.Double p2dUserStripeStart2 = new Point2D.Double(this.ref + (double)count1 * this.interval, 0.0);
                    Point2D p2dDeviceStripeStart2 = this.getProjection().userToPixel(p2dUserStripeStart2);
                    p2dUserStripeEnd2 = new Point2D.Double(this.ref + (double)count1 * this.interval + this.interval, 0.0);
                    p2dDeviceStripeEnd2 = this.getProjection().userToPixel(p2dUserStripeEnd2);
                    stripe2 = new Stripe(StripePlugin.StripeOrientation.Vertical);
                    stripe2.setDeviceInterval(p2dDeviceStripeEnd2.getX() - p2dDeviceStripeStart2.getX());
                    stripe2.setDeviceStart(p2dDeviceStripeStart2.getX());
                    stripe2.setUserInterval(this.interval);
                    stripe2.setUserStart(((Point2D)p2dUserStripeStart2).getX());
                    stripe2.setUserEnd(((Point2D)p2dUserStripeEnd2).getX());
                    p2 = this.getStripePalette().getPaintPalette(countPalette);
                    stripe2.setPaint(p2);
                    this.addStripe(stripe2);
                }
                if (countPalette++ == maxCount) {
                    countPalette = 0;
                }
                if (this.ref + (double)count1 * this.interval > this.getProjection().getMaxX()) {
                    flag1 = false;
                }
                ++count1;
            }
            countPalette = 1;
            int count2 = 1;
            boolean flag2 = true;
            while (flag2) {
                if (this.ref - (double)count2 * this.interval >= this.getProjection().getMinX() - this.interval && this.ref - (double)count2 * this.interval <= this.getProjection().getMaxX() + this.interval) {
                    p2dUserStripeStart = new Point2D.Double(this.ref - (double)count2 * this.interval, 0.0);
                    p2dDeviceStripeStart = this.getProjection().userToPixel(p2dUserStripeStart);
                    p2dUserStripeEnd = new Point2D.Double(this.ref - (double)count2 * this.interval - this.interval, 0.0);
                    p2dDeviceStripeEnd = this.getProjection().userToPixel(p2dUserStripeEnd);
                    stripe = new Stripe(StripePlugin.StripeOrientation.Vertical);
                    stripe.setDeviceInterval(p2dDeviceStripeStart.getX() - p2dDeviceStripeEnd.getX());
                    stripe.setDeviceStart(p2dDeviceStripeStart.getX());
                    stripe.setDeviceEnd(p2dDeviceStripeEnd.getX());
                    stripe.setUserInterval(this.interval);
                    stripe.setUserStart(((Point2D)p2dUserStripeStart).getX());
                    stripe.setUserEnd(((Point2D)p2dUserStripeEnd).getX());
                    p = this.getStripePalette().getPaintPalette(countPalette);
                    stripe.setPaint(p);
                    this.addStripe(stripe);
                }
                if (countPalette++ == maxCount) {
                    countPalette = 0;
                }
                if (this.ref - (double)count2 * this.interval < this.getProjection().getMinX()) {
                    flag2 = false;
                }
                ++count2;
            }
        }
        if (this.getStripeOrientation() == StripePlugin.StripeOrientation.Horizontal) {
            stripeNumber = (int)((this.getProjection().getMaxY() - this.getProjection().getMinY()) / this.interval);
            if (stripeNumber < 0 || stripeNumber > this.getStripeMaxNumber()) {
                this.stripes.clear();
                return this.stripes;
            }
            countPalette = 0;
            maxCount = this.getStripePalette().getPalette().size() - 1;
            count1 = 0;
            flag1 = true;
            while (flag1) {
                if (this.ref + (double)count1 * this.interval >= this.getProjection().getMinY() - this.interval && this.ref + (double)count1 * this.interval <= this.getProjection().getMaxY() + this.interval) {
                    Point2D.Double p2dUserStripeStart3 = new Point2D.Double(0.0, this.ref + (double)count1 * this.interval);
                    Point2D p2dDeviceStripeStart3 = this.getProjection().userToPixel(p2dUserStripeStart3);
                    p2dUserStripeEnd2 = new Point2D.Double(0.0, this.ref + (double)count1 * this.interval + this.interval);
                    p2dDeviceStripeEnd2 = this.getProjection().userToPixel(p2dUserStripeEnd2);
                    stripe2 = new Stripe(StripePlugin.StripeOrientation.Horizontal);
                    stripe2.setDeviceInterval(p2dDeviceStripeEnd2.getY() - p2dDeviceStripeStart3.getY());
                    stripe2.setDeviceStart(p2dDeviceStripeStart3.getY());
                    stripe2.setDeviceEnd(p2dDeviceStripeEnd2.getY());
                    stripe2.setUserInterval(this.interval);
                    stripe2.setUserStart(((Point2D)p2dUserStripeStart3).getY());
                    stripe2.setUserEnd(((Point2D)p2dUserStripeEnd2).getY());
                    p2 = this.getStripePalette().getPaintPalette(countPalette);
                    stripe2.setPaint(p2);
                    this.addStripe(stripe2);
                }
                if (countPalette++ == maxCount) {
                    countPalette = 0;
                }
                if (this.ref + (double)count1 * this.interval > this.getProjection().getMaxY()) {
                    flag1 = false;
                }
                ++count1;
            }
            countPalette = 1;
            int count2 = 1;
            boolean flag2 = true;
            while (flag2) {
                if (this.ref - (double)count2 * this.interval > this.getProjection().getMinY() - this.interval && this.ref - (double)count2 * this.interval < this.getProjection().getMaxY() + this.interval) {
                    p2dUserStripeStart = new Point2D.Double(0.0, this.ref - (double)count2 * this.interval);
                    p2dDeviceStripeStart = this.getProjection().userToPixel(p2dUserStripeStart);
                    p2dUserStripeEnd = new Point2D.Double(0.0, this.ref - (double)count2 * this.interval - this.interval);
                    p2dDeviceStripeEnd = this.getProjection().userToPixel(p2dUserStripeEnd);
                    stripe = new Stripe(StripePlugin.StripeOrientation.Horizontal);
                    stripe.setDeviceInterval(p2dDeviceStripeStart.getY() - p2dDeviceStripeEnd.getY());
                    stripe.setDeviceStart(p2dDeviceStripeStart.getY());
                    stripe.setUserInterval(this.interval);
                    stripe.setUserStart(((Point2D)p2dUserStripeStart).getY());
                    stripe.setUserEnd(((Point2D)p2dUserStripeEnd).getY());
                    p = this.getStripePalette().getPaintPalette(countPalette);
                    stripe.setPaint(p);
                    this.addStripe(stripe);
                }
                if (countPalette++ == maxCount) {
                    countPalette = 0;
                }
                if (this.ref - (double)count2 * this.interval < this.getProjection().getMinY()) {
                    flag2 = false;
                }
                ++count2;
            }
        }
        if (this.stripes.size() > this.getStripeMaxNumber()) {
            this.stripes.clear();
        }
        return this.stripes;
    }
}

