/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.stripe.painter;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jensoft.core.plugin.stripe.Stripe;
import org.jensoft.core.plugin.stripe.StripePlugin;
import org.jensoft.core.plugin.stripe.manager.StripeManager;
import org.jensoft.core.plugin.stripe.painter.AbstractStripePainter;
import org.jensoft.core.plugin.stripe.painter.StripePaint;

public class StripeDefaultPainter
extends AbstractStripePainter {
    @Override
    public void doPaintStripes(Graphics2D g2d) {
        LinearGradientPaint shader;
        Point2D.Double end;
        Point2D.Double start;
        StripePaint bandPaint;
        Rectangle2D.Double stripeShape;
        double gd;
        Stripe stripe;
        int i;
        List<Stripe> stripes;
        StripeManager manager = this.getManager();
        if (manager == null) {
            return;
        }
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        if (manager.getStripeOrientation() == StripePlugin.StripeOrientation.Vertical) {
            stripes = manager.getStripes();
            for (i = 0; i < stripes.size(); ++i) {
                stripe = stripes.get(i);
                gd = stripe.deviceStart;
                stripeShape = new Rectangle2D.Double(gd, 0.0, stripe.getDeviceInterval(), this.getManager().getProjection().getDevice2D().getDeviceHeight());
                bandPaint = stripe.getPaint();
                if (bandPaint.getStripeColor() != null) {
                    g2d.setColor(bandPaint.getStripeColor());
                }
                if (bandPaint.getStripePaint() != null) {
                    g2d.setPaint(bandPaint.getStripePaint());
                }
                if (bandPaint.getShadeFractions() != null && bandPaint.getShadeColors() != null && bandPaint.getShadeFractions().length == bandPaint.getShadeColors().length && !(start = new Point2D.Double(stripeShape.getBounds2D().getX(), stripeShape.getBounds2D().getCenterY())).equals(end = new Point2D.Double(stripeShape.getBounds2D().getX() + stripeShape.getBounds2D().getWidth(), stripeShape.getBounds2D().getCenterY()))) {
                    shader = new LinearGradientPaint(start, end, bandPaint.getShadeFractions(), bandPaint.getShadeColors());
                    g2d.setPaint(shader);
                }
                g2d.setComposite(AlphaComposite.getInstance(3, this.getAlpha()));
                g2d.fill(stripeShape);
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
                if (stripe.getAnnotation() == null) continue;
                g2d.drawString(stripe.getAnnotation(), (int)gd + 2, 10);
            }
        }
        if (manager.getStripeOrientation() == StripePlugin.StripeOrientation.Horizontal) {
            stripes = manager.getStripes();
            for (i = 0; i < stripes.size(); ++i) {
                stripe = stripes.get(i);
                gd = stripe.deviceStart;
                stripeShape = new Rectangle2D.Double(0.0, gd, this.getManager().getProjection().getDevice2D().getDeviceWidth(), Math.abs(stripe.getDeviceInterval()));
                bandPaint = stripe.getPaint();
                if (bandPaint.getStripeColor() != null) {
                    g2d.setColor(bandPaint.getStripeColor());
                }
                if (bandPaint.getStripePaint() != null) {
                    g2d.setPaint(bandPaint.getStripePaint());
                }
                if (bandPaint.getShadeFractions() != null && bandPaint.getShadeColors() != null && bandPaint.getShadeFractions().length == bandPaint.getShadeColors().length && !(start = new Point2D.Double(stripeShape.getBounds2D().getCenterX(), stripeShape.getBounds2D().getY())).equals(end = new Point2D.Double(stripeShape.getBounds2D().getCenterX(), stripeShape.getBounds2D().getY() + stripeShape.getBounds2D().getHeight()))) {
                    shader = new LinearGradientPaint(start, end, bandPaint.getShadeFractions(), bandPaint.getShadeColors());
                    g2d.setPaint(shader);
                }
                g2d.setComposite(AlphaComposite.getInstance(3, this.getAlpha()));
                g2d.fill(stripeShape);
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
                if (stripe.getAnnotation() == null) continue;
                g2d.drawString(stripe.getAnnotation(), 10, (int)gd - 2);
            }
        }
    }
}

