/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.symbol;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jensoft.core.plugin.symbol.BarEvent;
import org.jensoft.core.plugin.symbol.BarListener;
import org.jensoft.core.plugin.symbol.BarSymbol;
import org.jensoft.core.plugin.symbol.BarSymbolGroup;
import org.jensoft.core.plugin.symbol.Stack;
import org.jensoft.core.plugin.symbol.StackedBarSymbol;
import org.jensoft.core.plugin.symbol.SymbolComponent;
import org.jensoft.core.plugin.symbol.SymbolLayer;
import org.jensoft.core.plugin.symbol.SymbolPlugin;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class BarSymbolLayer
extends SymbolLayer<BarSymbol> {
    private EventListenerList symbolListenerList = new EventListenerList();

    public void addBarListener(BarListener listener) {
        this.symbolListenerList.add(BarListener.class, listener);
    }

    public void removeBarListener(BarListener listener) {
        this.symbolListenerList.remove(BarListener.class, listener);
    }

    @Override
    public List<BarSymbol> getFlattenSymbolComponents() {
        ArrayList<BarSymbol> flattenSymbolComponents = new ArrayList<BarSymbol>();
        for (BarSymbol comp : this.getSymbols()) {
            if (comp instanceof BarSymbol && !(comp instanceof BarSymbolGroup)) {
                flattenSymbolComponents.add(comp);
                continue;
            }
            if (!(comp instanceof BarSymbolGroup)) continue;
            flattenSymbolComponents.addAll(((BarSymbolGroup)comp).getSymbolComponents());
        }
        return flattenSymbolComponents;
    }

    @Override
    public final void paintLayer(View v2d, Graphics2D g2d, ViewPart viewPart, SymbolPlugin.PaintRequest paintRequest) {
        this.paintSymbols(g2d, this.getSymbols(), viewPart, paintRequest);
    }

    private void paintSymbols(Graphics2D g2d, List<BarSymbol> symbols, ViewPart viewPart, SymbolPlugin.PaintRequest paintRequest) {
        this.solveGeometry();
        if (viewPart == ViewPart.Device) {
            for (BarSymbol symbol : symbols) {
                if (!(symbol instanceof BarSymbol)) continue;
                if (symbol instanceof BarSymbolGroup) {
                    this.paintGroup(g2d, (BarSymbolGroup)symbol, viewPart, paintRequest);
                    continue;
                }
                if (symbol instanceof StackedBarSymbol) {
                    this.paintBarStacked(g2d, (StackedBarSymbol)symbol, viewPart, paintRequest);
                    continue;
                }
                this.paintBar(g2d, symbol, viewPart, paintRequest);
            }
        }
        if (viewPart != ViewPart.Device && paintRequest == SymbolPlugin.PaintRequest.LabelLayer) {
            this.paintSymbolsAxisLabel(g2d, symbols, viewPart);
        }
    }

    private void paintGroup(Graphics2D g2d, BarSymbolGroup barGroup, ViewPart viewPart, SymbolPlugin.PaintRequest paintRequest) {
        barGroup.setHost(this.getHost());
        barGroup.setLayer(this);
        if (paintRequest == SymbolPlugin.PaintRequest.LabelLayer) {
            this.paintBar(g2d, barGroup, viewPart, paintRequest);
        }
        List<BarSymbol> barSymbolComponents = barGroup.getSymbolComponents();
        this.paintSymbols(g2d, barSymbolComponents, viewPart, paintRequest);
    }

    private void paintSymbolsAxisLabel(Graphics2D g2d, List<BarSymbol> barSymbolComponents, ViewPart viewPart) {
        for (SymbolComponent symbolComponent : barSymbolComponents) {
            symbolComponent.setHost(this.getHost());
            if (!(symbolComponent instanceof BarSymbol)) continue;
            if (symbolComponent instanceof BarSymbolGroup) {
                BarSymbolGroup barGroup = (BarSymbolGroup)symbolComponent;
                List<BarSymbol> groupBarSymbolComponents = barGroup.getSymbolComponents();
                this.paintSymbolsAxisLabel(g2d, groupBarSymbolComponents, viewPart);
                if (barGroup.getAxisLabel() == null) continue;
                barGroup.getAxisLabel().paintSymbol(g2d, barGroup, viewPart);
                continue;
            }
            this.paintBarAxisLabel(g2d, (BarSymbol)symbolComponent, viewPart);
        }
    }

    private void paintBarAxisLabel(Graphics2D g2d, BarSymbol barSymbol, ViewPart viewPart) {
        if (barSymbol.getAxisLabel() != null) {
            barSymbol.getAxisLabel().paintSymbol(g2d, barSymbol, viewPart);
        }
    }

    private void paintBar(Graphics2D g2d, BarSymbol bar, ViewPart viewPart, SymbolPlugin.PaintRequest paintRequest) {
        bar.setHost(this.getHost());
        bar.setLayer(this);
        if (paintRequest == SymbolPlugin.PaintRequest.SymbolLayer) {
            if (bar.getBarFill() != null) {
                bar.getBarFill().paintSymbol(g2d, bar, viewPart);
            }
            if (bar.getBarEffect() != null) {
                bar.getBarEffect().paintSymbol(g2d, bar, viewPart);
            }
            if (bar.getBarDraw() != null) {
                bar.getBarDraw().paintSymbol(g2d, bar, viewPart);
            }
        } else if (paintRequest == SymbolPlugin.PaintRequest.LabelLayer && bar.getBarLabel() != null) {
            bar.getBarLabel().paintSymbol(g2d, bar, viewPart);
        }
    }

    @Override
    public void solveSymbolComponent(BarSymbol symbol) {
        if (symbol.isFiller()) {
            return;
        }
        symbol.setLayer(this);
        if (this.getHost().getNature() == SymbolPlugin.SymbolNature.Vertical) {
            this.solveVSymbolComponent(symbol);
        }
        if (this.getHost().getNature() == SymbolPlugin.SymbolNature.Horizontal) {
            this.solveHSymbolComponent(symbol);
        }
    }

    private void solveVSymbolComponent(SymbolComponent symbol) {
        if (symbol.isFiller()) {
            return;
        }
        symbol.setNature(SymbolPlugin.SymbolNature.Vertical);
        symbol.setLayer(this);
        if (symbol instanceof BarSymbolGroup) {
            this.solveVBarGroup((BarSymbolGroup)symbol);
        } else if (symbol instanceof StackedBarSymbol) {
            this.solveVStackedBar((StackedBarSymbol)symbol);
        } else {
            this.solveVBarSymbol((BarSymbol)symbol);
        }
    }

    private void solveVBarSymbol(BarSymbol bar) {
        if (this.getHost() == null || this.getHost().getProjection() == null) {
            return;
        }
        bar.setHost(this.getHost());
        Projection w2d = this.getHost().getProjection();
        Point2D.Double p2dUser = null;
        if (bar.isAscent()) {
            p2dUser = new Point2D.Double(0.0, bar.getBase() + bar.getValue());
        }
        if (bar.isDescent()) {
            p2dUser = new Point2D.Double(0.0, bar.getBase() - bar.getValue());
        }
        if (!bar.isValueSet()) {
            throw new IllegalArgumentException("bar symbol ascent or descent value should be supplied.");
        }
        if (!bar.isBaseSet()) {
            throw new IllegalArgumentException("bar symbol base value should be supplied.");
        }
        Point2D p2ddevice = w2d.userToPixel(p2dUser);
        Point2D.Double p2dUserBase = new Point2D.Double(0.0, bar.getBase());
        Point2D p2ddeviceBase = w2d.userToPixel(p2dUserBase);
        double x = this.getComponentXLocation(bar);
        double y = p2ddevice.getY();
        if (bar.isAscent()) {
            y = p2ddevice.getY();
        }
        if (bar.isDescent()) {
            y = p2ddeviceBase.getY();
        }
        double width = bar.getThickness();
        double height = Math.abs(p2ddeviceBase.getY() - p2ddevice.getY());
        if (bar.getMorpheStyle() == BarSymbol.MorpheStyle.Round) {
            double round = bar.getRound();
            GeneralPath barPath = new GeneralPath();
            if (bar.isAscent()) {
                barPath.moveTo(x, y + round);
                barPath.lineTo(x, y + height);
                barPath.lineTo(x + width, y + height);
                barPath.lineTo(x + width, y + round);
                barPath.quadTo(x + width, y, x + width - round, y);
                barPath.lineTo(x + round, y);
                barPath.quadTo(x, y, x, y + round);
                barPath.closePath();
            } else if (bar.isDescent()) {
                barPath.moveTo(x, y);
                barPath.lineTo(x, y + height - round);
                barPath.quadTo(x, y + height, x + round, y + height);
                barPath.lineTo(x + width - round, y + height);
                barPath.quadTo(x + width, y + height, x + width, y + height - round);
                barPath.lineTo(x + width, y);
                barPath.closePath();
            }
            bar.setBarShape(barPath);
        } else if (bar.getMorpheStyle() == BarSymbol.MorpheStyle.Rectangle) {
            Rectangle2D.Double barRec = new Rectangle2D.Double(x, y, width, height);
            bar.setBarShape(barRec);
        }
    }

    private void solveVStackedBar(StackedBarSymbol stackedBar) {
        if (this.getHost() == null || this.getHost().getProjection() == null) {
            return;
        }
        stackedBar.setHost(this.getHost());
        stackedBar.normalize();
        Projection w2d = this.getHost().getProjection();
        Point2D.Double p2dUser = null;
        if (stackedBar.isAscent()) {
            p2dUser = new Point2D.Double(0.0, stackedBar.getBase() + stackedBar.getValue());
        }
        if (stackedBar.isDescent()) {
            p2dUser = new Point2D.Double(0.0, stackedBar.getBase() - stackedBar.getValue());
        }
        if (!stackedBar.isValueSet()) {
            throw new IllegalArgumentException("stacked bar symbol ascent or descent value should be supplied.");
        }
        if (!stackedBar.isBaseSet()) {
            throw new IllegalArgumentException("stacked bar symbol base value should be supplied.");
        }
        Point2D p2ddevice = w2d.userToPixel(p2dUser);
        Point2D.Double p2dUserBase = new Point2D.Double(0.0, stackedBar.getBase());
        Point2D p2ddeviceBase = w2d.userToPixel(p2dUserBase);
        double x = this.getComponentXLocation(stackedBar);
        double y = p2ddevice.getY();
        if (stackedBar.isAscent()) {
            y = p2ddevice.getY();
        }
        if (stackedBar.isDescent()) {
            y = p2ddeviceBase.getY();
        }
        double width = stackedBar.getThickness();
        double height = Math.abs(p2ddeviceBase.getY() - p2ddevice.getY());
        if (stackedBar.getMorpheStyle() == BarSymbol.MorpheStyle.Round) {
            GeneralPath barPath;
            double round = stackedBar.getRound();
            if (stackedBar.isAscent()) {
                barPath = new GeneralPath();
                barPath.moveTo(x, y + round);
                barPath.lineTo(x, y + height);
                barPath.lineTo(x + width, y + height);
                barPath.lineTo(x + width, y + round);
                barPath.quadTo(x + width, y, x + width - round, y);
                barPath.lineTo(x + round, y);
                barPath.quadTo(x, y, x, y + round);
                barPath.closePath();
                stackedBar.setBarShape(barPath);
            } else if (stackedBar.isDescent()) {
                barPath = new GeneralPath();
                barPath.moveTo(x, y);
                barPath.lineTo(x, y + height - round);
                barPath.quadTo(x, y + height, x + round, y + height);
                barPath.lineTo(x + width - round, y + height);
                barPath.quadTo(x + width, y + height, x + width, y + height - round);
                barPath.lineTo(x + width, y);
                barPath.closePath();
                stackedBar.setBarShape(barPath);
            }
        } else if (stackedBar.getMorpheStyle() == BarSymbol.MorpheStyle.Rectangle) {
            Rectangle2D.Double barRec = new Rectangle2D.Double(x, y, width, height);
            stackedBar.setBarShape(barRec);
        }
        List<Stack> stacks = stackedBar.getStacks();
        int count = 0;
        for (Stack stack : stacks) {
            stack.setThickness(stackedBar.getThickness());
            stack.setBase(stackedBar.getStackBase(stack));
            stack.setNature(stackedBar.getNature());
            stack.setBarFill(stackedBar.getBarFill());
            if (stackedBar.isAscent()) {
                stack.setAscentValue(stack.getNormalizedValue());
            } else if (stackedBar.isDescent()) {
                stack.setDescentValue(stack.getNormalizedValue());
            }
            Point2D.Double stackedp2dUser = null;
            if (stackedBar.isAscent()) {
                stackedp2dUser = new Point2D.Double(0.0, stackedBar.getStackBase(stack) + stack.getNormalizedValue());
            } else if (stackedBar.isDescent()) {
                stackedp2dUser = new Point2D.Double(0.0, stackedBar.getStackBase(stack) - stack.getNormalizedValue());
            }
            Point2D stackedp2ddevice = w2d.userToPixel(stackedp2dUser);
            Point2D.Double stackedp2dUserBase = new Point2D.Double(0.0, stackedBar.getStackBase(stack));
            Point2D stackedp2ddeviceBase = w2d.userToPixel(stackedp2dUserBase);
            double stackedx = this.getComponentXLocation(stackedBar);
            double stackedy = stackedp2ddevice.getY();
            if (stackedBar.isAscent()) {
                stackedy = stackedp2ddevice.getY();
            }
            if (stackedBar.isDescent()) {
                stackedy = stackedp2ddeviceBase.getY();
            }
            double stackedwidth = stackedBar.getThickness();
            double stackedheight = Math.abs(stackedp2ddeviceBase.getY() - stackedp2ddevice.getY());
            if (stackedBar.getMorpheStyle() == BarSymbol.MorpheStyle.Round) {
                if (count == stacks.size() - 1) {
                    double round = stackedBar.getRound();
                    GeneralPath barPath = new GeneralPath();
                    if (stackedBar.isAscent()) {
                        barPath.moveTo(stackedx, stackedy + round);
                        barPath.lineTo(stackedx, stackedy + stackedheight);
                        barPath.lineTo(stackedx + stackedwidth, stackedy + stackedheight);
                        barPath.lineTo(stackedx + stackedwidth, stackedy + round);
                        barPath.quadTo(stackedx + stackedwidth, stackedy, stackedx + stackedwidth - round, stackedy);
                        barPath.lineTo(stackedx + round, stackedy);
                        barPath.quadTo(stackedx, stackedy, stackedx, stackedy + round);
                        barPath.closePath();
                    } else if (stackedBar.isDescent()) {
                        barPath.moveTo(stackedx, stackedy);
                        barPath.lineTo(stackedx, stackedy + stackedheight - round);
                        barPath.quadTo(stackedx, stackedy + stackedheight, stackedx + round, stackedy + stackedheight);
                        barPath.lineTo(stackedx + stackedwidth - round, stackedy + stackedheight);
                        barPath.quadTo(stackedx + stackedwidth, stackedy + stackedheight, stackedx + stackedwidth, stackedy + stackedheight - round);
                        barPath.lineTo(stackedx + stackedwidth, stackedy);
                        barPath.closePath();
                    }
                    stack.setBarShape(barPath);
                } else {
                    Rectangle2D.Double barRec = new Rectangle2D.Double(stackedx, stackedy, stackedwidth, stackedheight);
                    stack.setBarShape(barRec);
                }
            } else if (stackedBar.getMorpheStyle() == BarSymbol.MorpheStyle.Rectangle) {
                Rectangle2D.Double barRec = new Rectangle2D.Double(stackedx, stackedy, stackedwidth, stackedheight);
                stack.setBarShape(barRec);
            }
            ++count;
        }
    }

    private void solveHBarGroup(BarSymbolGroup barGroup) {
        barGroup.setHost(this.getHost());
        barGroup.copyToBar();
        List<BarSymbol> bars = barGroup.getSymbolComponents();
        for (SymbolComponent symbolComponent : bars) {
            symbolComponent.setLayer(this);
            this.solveHSymbolComponent(symbolComponent);
        }
    }

    private void solveHSymbolComponent(SymbolComponent symbol) {
        if (symbol.isFiller()) {
            return;
        }
        symbol.setNature(SymbolPlugin.SymbolNature.Horizontal);
        if (symbol instanceof BarSymbolGroup) {
            this.solveHBarGroup((BarSymbolGroup)symbol);
        } else if (symbol instanceof StackedBarSymbol) {
            this.solveHStackedBar((StackedBarSymbol)symbol);
        } else {
            this.solveHBarSymbol((BarSymbol)symbol);
        }
    }

    private void paintBarStacked(Graphics2D g2d, StackedBarSymbol stackedBar, ViewPart viewPart, SymbolPlugin.PaintRequest paintRequest) {
        stackedBar.setHost(this.getHost());
        stackedBar.setLayer(this);
        List<Stack> stacks = stackedBar.getStacks();
        if (paintRequest == SymbolPlugin.PaintRequest.SymbolLayer) {
            for (Stack s : stacks) {
                this.paintBar(g2d, s, viewPart, paintRequest);
            }
            if (stackedBar.getBarEffect() != null) {
                stackedBar.getBarEffect().paintSymbol(g2d, stackedBar, viewPart);
            }
            if (stackedBar.getBarDraw() != null) {
                stackedBar.getBarDraw().paintSymbol(g2d, stackedBar, viewPart);
            }
        } else if (paintRequest == SymbolPlugin.PaintRequest.LabelLayer) {
            if (stackedBar.getBarLabel() != null) {
                stackedBar.getBarLabel().paintSymbol(g2d, stackedBar, viewPart);
            }
            for (Stack s : stacks) {
                if (s.getBarLabel() == null) continue;
                s.getBarLabel().paintSymbol(g2d, s, viewPart);
            }
        }
    }

    private void solveVBarGroup(BarSymbolGroup barGroup) {
        barGroup.setHost(this.getHost());
        barGroup.copyToBar();
        List<BarSymbol> bars = barGroup.getSymbolComponents();
        for (SymbolComponent symbolComponent : bars) {
            symbolComponent.setLayer(this);
            symbolComponent.setHost(this.getHost());
            this.solveVSymbolComponent(symbolComponent);
        }
    }

    private void solveHBarSymbol(BarSymbol bar) {
        if (this.getHost() == null || this.getHost().getProjection() == null) {
            return;
        }
        bar.setHost(this.getHost());
        Projection w2d = this.getHost().getProjection();
        Point2D.Double p2dUser = null;
        if (bar.isAscent()) {
            p2dUser = new Point2D.Double(bar.getBase() + bar.getValue(), 0.0);
        }
        if (bar.isDescent()) {
            p2dUser = new Point2D.Double(bar.getBase() - bar.getValue(), 0.0);
        }
        if (!bar.isValueSet()) {
            throw new IllegalArgumentException("bar symbol ascent or descent value should be supplied.");
        }
        if (!bar.isBaseSet()) {
            throw new IllegalArgumentException("stacked bar symbol base value should be supplied.");
        }
        Point2D p2ddevice = w2d.userToPixel(p2dUser);
        Point2D.Double p2dUserBase = new Point2D.Double(bar.getBase(), 0.0);
        Point2D p2ddeviceBase = w2d.userToPixel(p2dUserBase);
        double y = this.getComponentYLocation(bar);
        double x = p2ddeviceBase.getX();
        if (bar.isAscent()) {
            x = p2ddeviceBase.getX();
        }
        if (bar.isDescent()) {
            x = p2ddevice.getX();
        }
        double height = bar.getThickness();
        double width = Math.abs(p2ddevice.getX() - p2ddeviceBase.getX());
        if (bar.getMorpheStyle() == BarSymbol.MorpheStyle.Round) {
            double round = bar.getRound();
            GeneralPath barPath = new GeneralPath();
            if (bar.isAscent()) {
                barPath.moveTo(x, y);
                barPath.lineTo(x + width - round, y);
                barPath.quadTo(x + width, y, x + width, y + round);
                barPath.lineTo(x + width, y + height - round);
                barPath.quadTo(x + width, y + height, x + width - round, y + height);
                barPath.lineTo(x, y + height);
                barPath.closePath();
            } else if (bar.isDescent()) {
                barPath.moveTo(x + round, y);
                barPath.lineTo(x + width, y);
                barPath.lineTo(x + width, y + height);
                barPath.lineTo(x + round, y + height);
                barPath.quadTo(x, y + height, x, y + height - round);
                barPath.lineTo(x, y + round);
                barPath.quadTo(x, y, x + round, y);
                barPath.closePath();
            }
            bar.setBarShape(barPath);
        } else {
            Rectangle2D.Double barRec = new Rectangle2D.Double(x, y, width, height);
            bar.setBarShape(barRec);
        }
    }

    private void solveHStackedBar(StackedBarSymbol stackedBar) {
        if (this.getHost() == null || this.getHost().getProjection() == null) {
            return;
        }
        stackedBar.setHost(this.getHost());
        stackedBar.normalize();
        Projection w2d = this.getHost().getProjection();
        Point2D.Double p2dUser = null;
        if (stackedBar.isAscent()) {
            p2dUser = new Point2D.Double(stackedBar.getBase() + stackedBar.getValue(), 0.0);
        }
        if (stackedBar.isDescent()) {
            p2dUser = new Point2D.Double(stackedBar.getBase() - stackedBar.getValue(), 0.0);
        }
        if (!stackedBar.isValueSet()) {
            throw new IllegalArgumentException("stacked bar symbol ascent or descent value should be supplied.");
        }
        if (!stackedBar.isBaseSet()) {
            throw new IllegalArgumentException("stacked bar symbol base value should be supplied.");
        }
        Point2D p2ddevice = w2d.userToPixel(p2dUser);
        Point2D.Double p2dUserBase = new Point2D.Double(stackedBar.getBase(), 0.0);
        Point2D p2ddeviceBase = w2d.userToPixel(p2dUserBase);
        double y = this.getComponentYLocation(stackedBar);
        double x = p2ddeviceBase.getX();
        if (stackedBar.isAscent()) {
            x = p2ddeviceBase.getX();
        }
        if (stackedBar.isDescent()) {
            x = p2ddevice.getX();
        }
        double height = stackedBar.getThickness();
        double width = Math.abs(p2ddevice.getX() - p2ddeviceBase.getX());
        if (stackedBar.getMorpheStyle() == BarSymbol.MorpheStyle.Round) {
            double round = stackedBar.getRound();
            GeneralPath barPath = new GeneralPath();
            if (stackedBar.isAscent()) {
                barPath.moveTo(x, y);
                barPath.lineTo(x + width - round, y);
                barPath.quadTo(x + width, y, x + width, y + round);
                barPath.lineTo(x + width, y + height - round);
                barPath.quadTo(x + width, y + height, x + width - round, y + height);
                barPath.lineTo(x, y + height);
                barPath.closePath();
            } else if (stackedBar.isDescent()) {
                barPath.moveTo(x + round, y);
                barPath.lineTo(x + width, y);
                barPath.lineTo(x + width, y + height);
                barPath.lineTo(x + round, y + height);
                barPath.quadTo(x, y + height, x, y + height - round);
                barPath.lineTo(x, y + round);
                barPath.quadTo(x, y, x + round, y);
                barPath.closePath();
            }
            stackedBar.setBarShape(barPath);
        } else {
            Rectangle2D.Double barRec = new Rectangle2D.Double(x, y, width, height);
            stackedBar.setBarShape(barRec);
        }
        List<Stack> stacks = stackedBar.getStacks();
        int count = 0;
        for (Stack stack : stacks) {
            stack.setThickness(stackedBar.getThickness());
            stack.setBase(stackedBar.getStackBase(stack));
            stack.setNature(stackedBar.getNature());
            stack.setBarFill(stackedBar.getBarFill());
            if (stackedBar.isAscent()) {
                stack.setAscentValue(stack.getNormalizedValue());
            } else if (stackedBar.isDescent()) {
                stack.setDescentValue(stack.getNormalizedValue());
            }
            Point2D.Double stackedp2dUser = null;
            if (stackedBar.isAscent()) {
                stackedp2dUser = new Point2D.Double(stackedBar.getStackBase(stack) + stack.getNormalizedValue(), 0.0);
            } else if (stackedBar.isDescent()) {
                stackedp2dUser = new Point2D.Double(stackedBar.getStackBase(stack) - stack.getNormalizedValue(), 0.0);
            }
            Point2D stackedp2ddevice = w2d.userToPixel(stackedp2dUser);
            Point2D.Double stackedp2dUserBase = new Point2D.Double(stackedBar.getStackBase(stack), 0.0);
            Point2D stackedp2ddeviceBase = w2d.userToPixel(stackedp2dUserBase);
            double stackedy = this.getComponentYLocation(stackedBar);
            double stackedx = stackedp2ddeviceBase.getX();
            if (stackedBar.isAscent()) {
                stackedx = stackedp2ddeviceBase.getX();
            }
            if (stackedBar.isDescent()) {
                stackedx = stackedp2ddevice.getX();
            }
            double stackedheight = stackedBar.getThickness();
            double stackedwidth = Math.abs(stackedp2ddevice.getX() - stackedp2ddeviceBase.getX());
            if (stackedBar.getMorpheStyle() == BarSymbol.MorpheStyle.Round) {
                if (count == stacks.size() - 1) {
                    double round = stackedBar.getRound();
                    GeneralPath barPath = new GeneralPath();
                    if (stackedBar.isAscent()) {
                        barPath.moveTo(stackedx, stackedy);
                        barPath.lineTo(stackedx + stackedwidth - round, stackedy);
                        barPath.quadTo(stackedx + stackedwidth, stackedy, stackedx + stackedwidth, stackedy + round);
                        barPath.lineTo(stackedx + stackedwidth, stackedy + stackedheight - round);
                        barPath.quadTo(stackedx + stackedwidth, stackedy + stackedheight, stackedx + stackedwidth - round, stackedy + stackedheight);
                        barPath.lineTo(stackedx, stackedy + stackedheight);
                        barPath.closePath();
                    } else if (stackedBar.isDescent()) {
                        barPath.moveTo(stackedx + round, stackedy);
                        barPath.lineTo(stackedx + stackedwidth, stackedy);
                        barPath.lineTo(stackedx + stackedwidth, stackedy + stackedheight);
                        barPath.lineTo(stackedx + round, stackedy + stackedheight);
                        barPath.quadTo(stackedx, stackedy + stackedheight, stackedx, stackedy + stackedheight - round);
                        barPath.lineTo(stackedx, stackedy + round);
                        barPath.quadTo(stackedx, stackedy, stackedx + round, stackedy);
                        barPath.closePath();
                    }
                    stack.setBarShape(barPath);
                } else {
                    Rectangle2D.Double barRec = new Rectangle2D.Double(stackedx, stackedy, stackedwidth, stackedheight);
                    stack.setBarShape(barRec);
                }
            } else {
                Rectangle2D.Double barRec = new Rectangle2D.Double(stackedx, stackedy, stackedwidth, stackedheight);
                stack.setBarShape(barRec);
            }
            ++count;
        }
    }

    @Override
    public void onRelease(MouseEvent me) {
        List bars = this.getSymbols();
        for (SymbolComponent symbolComponent : bars) {
            if (symbolComponent instanceof StackedBarSymbol) {
                StackedBarSymbol stackedBar = (StackedBarSymbol)symbolComponent;
                if (stackedBar.getBarShape() != null && stackedBar.getBarShape().contains(me.getX(), me.getY()) && stackedBar.isLockEnter()) {
                    this.fireBarReleased(stackedBar);
                }
                List<Stack> barStacks = stackedBar.getStacks();
                for (Stack stack : barStacks) {
                    if (stack.getBarShape() == null || !stack.getBarShape().contains(me.getX(), me.getY()) || !stack.isLockEnter()) continue;
                    this.fireBarReleased(stack);
                }
                continue;
            }
            if (symbolComponent instanceof BarSymbolGroup) {
                BarSymbolGroup group = (BarSymbolGroup)symbolComponent;
                List<BarSymbol> barsGroup = group.getSymbolComponents();
                for (SymbolComponent symbolComponent2 : barsGroup) {
                    if (symbolComponent2 instanceof StackedBarSymbol) {
                        StackedBarSymbol stackedBar = (StackedBarSymbol)symbolComponent2;
                        if (stackedBar.getBarShape() != null && stackedBar.getBarShape().contains(me.getX(), me.getY()) && stackedBar.isLockEnter()) {
                            this.fireBarReleased(stackedBar);
                        }
                        List<Stack> barStacks = stackedBar.getStacks();
                        for (Stack barStack : barStacks) {
                            if (barStack.getBarShape() == null || !barStack.getBarShape().contains(me.getX(), me.getY()) || !barStack.isLockEnter()) continue;
                            this.fireBarReleased(barStack);
                        }
                        continue;
                    }
                    if (!(symbolComponent2 instanceof BarSymbol) || ((BarSymbol)symbolComponent2).getBarShape() == null || !((BarSymbol)symbolComponent2).getBarShape().contains(me.getX(), me.getY()) || !((BarSymbol)symbolComponent2).isLockEnter()) continue;
                    this.fireBarReleased((BarSymbol)symbolComponent2);
                }
                continue;
            }
            if (!(symbolComponent instanceof BarSymbol) || ((BarSymbol)symbolComponent).getBarShape() == null || !((BarSymbol)symbolComponent).getBarShape().contains(me.getX(), me.getY()) || !((BarSymbol)symbolComponent).isLockEnter()) continue;
            this.fireBarReleased((BarSymbol)symbolComponent);
        }
    }

    @Override
    public void onPress(MouseEvent me) {
        List bars = this.getSymbols();
        for (SymbolComponent symbolComponent : bars) {
            if (symbolComponent instanceof StackedBarSymbol) {
                StackedBarSymbol stackedBar = (StackedBarSymbol)symbolComponent;
                if (stackedBar.getBarShape() != null && stackedBar.getBarShape().contains(me.getX(), me.getY()) && stackedBar.isLockEnter()) {
                    this.fireBarPressed(stackedBar);
                }
                List<Stack> barStacks = stackedBar.getStacks();
                for (Stack stack : barStacks) {
                    if (stack.getBarShape() == null || !stack.getBarShape().contains(me.getX(), me.getY()) || !stack.isLockEnter()) continue;
                    this.fireBarPressed(stack);
                }
                continue;
            }
            if (symbolComponent instanceof BarSymbolGroup) {
                BarSymbolGroup group = (BarSymbolGroup)symbolComponent;
                List<BarSymbol> barsGroup = group.getSymbolComponents();
                for (SymbolComponent symbolComponent2 : barsGroup) {
                    if (symbolComponent2 instanceof StackedBarSymbol) {
                        StackedBarSymbol stackedBar = (StackedBarSymbol)symbolComponent2;
                        if (stackedBar.getBarShape() != null && stackedBar.getBarShape().contains(me.getX(), me.getY())) {
                            this.fireBarPressed(stackedBar);
                        }
                        List<Stack> barStacks = stackedBar.getStacks();
                        for (Stack barStack : barStacks) {
                            if (barStack.getBarShape() == null || !barStack.getBarShape().contains(me.getX(), me.getY()) || !barStack.isLockEnter()) continue;
                            this.fireBarPressed(barStack);
                        }
                        continue;
                    }
                    if (!(symbolComponent2 instanceof BarSymbol) || ((BarSymbol)symbolComponent2).getBarShape() == null || !((BarSymbol)symbolComponent2).getBarShape().contains(me.getX(), me.getY()) || !((BarSymbol)symbolComponent2).isLockEnter()) continue;
                    this.fireBarPressed((BarSymbol)symbolComponent2);
                }
                continue;
            }
            if (!(symbolComponent instanceof BarSymbol) || ((BarSymbol)symbolComponent).getBarShape() == null || !((BarSymbol)symbolComponent).getBarShape().contains(me.getX(), me.getY()) || !((BarSymbol)symbolComponent).isLockEnter()) continue;
            this.fireBarPressed((BarSymbol)symbolComponent);
        }
    }

    @Override
    public void onExit(MouseEvent me) {
    }

    @Override
    public void onEnter(MouseEvent me) {
    }

    @Override
    public void onClick(MouseEvent me) {
        List bars = this.getSymbols();
        for (SymbolComponent symbolComponent : bars) {
            if (symbolComponent instanceof StackedBarSymbol) {
                StackedBarSymbol stackedBar = (StackedBarSymbol)symbolComponent;
                if (stackedBar.getBarShape() != null && stackedBar.getBarShape().contains(me.getX(), me.getY()) && stackedBar.isLockEnter()) {
                    this.fireBarClicked(stackedBar);
                }
                List<Stack> barStacks = stackedBar.getStacks();
                for (Stack stack : barStacks) {
                    if (stack.getBarShape() == null || !stack.getBarShape().contains(me.getX(), me.getY()) || !stack.isLockEnter()) continue;
                    this.fireBarClicked(stack);
                }
                continue;
            }
            if (symbolComponent instanceof BarSymbolGroup) {
                BarSymbolGroup group = (BarSymbolGroup)symbolComponent;
                List<BarSymbol> barsGroup = group.getSymbolComponents();
                for (SymbolComponent symbolComponent2 : barsGroup) {
                    if (symbolComponent2 instanceof StackedBarSymbol) {
                        StackedBarSymbol stackedBar = (StackedBarSymbol)symbolComponent2;
                        if (stackedBar.getBarShape() != null && stackedBar.getBarShape().contains(me.getX(), me.getY()) && stackedBar.isLockEnter()) {
                            this.fireBarClicked(stackedBar);
                        }
                        List<Stack> barStacks = stackedBar.getStacks();
                        for (Stack barStack : barStacks) {
                            if (barStack.getBarShape() == null || !barStack.getBarShape().contains(me.getX(), me.getY()) || !barStack.isLockEnter()) continue;
                            this.fireBarClicked(barStack);
                        }
                        continue;
                    }
                    if (!(symbolComponent2 instanceof BarSymbol) || ((BarSymbol)symbolComponent2).getBarShape() == null || !((BarSymbol)symbolComponent2).getBarShape().contains(me.getX(), me.getY())) continue;
                    this.fireBarClicked((BarSymbol)symbolComponent2);
                }
                continue;
            }
            if (!(symbolComponent instanceof BarSymbol) || ((BarSymbol)symbolComponent).getBarShape() == null || !((BarSymbol)symbolComponent).getBarShape().contains(me.getX(), me.getY()) || !((BarSymbol)symbolComponent).isLockEnter()) continue;
            this.fireBarClicked((BarSymbol)symbolComponent);
        }
    }

    @Override
    public void onMove(MouseEvent me) {
        List bars = this.getSymbols();
        for (SymbolComponent symbolComponent : bars) {
            if (symbolComponent instanceof StackedBarSymbol) {
                StackedBarSymbol stackedBar = (StackedBarSymbol)symbolComponent;
                this.barEnterExitTracker(stackedBar, me.getX(), me.getY());
                List<Stack> barStacks = stackedBar.getStacks();
                for (Stack stack : barStacks) {
                    this.barEnterExitTracker(stack, me.getX(), me.getY());
                }
                continue;
            }
            if (symbolComponent instanceof BarSymbolGroup) {
                BarSymbolGroup group = (BarSymbolGroup)symbolComponent;
                List<BarSymbol> barsGroup = group.getSymbolComponents();
                for (SymbolComponent symbolComponent2 : barsGroup) {
                    if (symbolComponent2 instanceof StackedBarSymbol) {
                        StackedBarSymbol stackedBar = (StackedBarSymbol)symbolComponent2;
                        this.barEnterExitTracker(stackedBar, me.getX(), me.getY());
                        List<Stack> barStacks = stackedBar.getStacks();
                        for (Stack barStack : barStacks) {
                            this.barEnterExitTracker(barStack, me.getX(), me.getY());
                        }
                        continue;
                    }
                    if (!(symbolComponent2 instanceof BarSymbol)) continue;
                    this.barEnterExitTracker((BarSymbol)symbolComponent2, me.getX(), me.getY());
                }
                continue;
            }
            if (!(symbolComponent instanceof BarSymbol)) continue;
            this.barEnterExitTracker((BarSymbol)symbolComponent, me.getX(), me.getY());
        }
    }

    private void barEnterExitTracker(BarSymbol bar, int x, int y) {
        if (bar.getBarShape() == null) {
            return;
        }
        if (bar.getBarShape().contains(x, y) && !bar.isLockEnter()) {
            bar.lockEnter();
            this.fireBarEntered(bar);
        } else if (!bar.getBarShape().contains(x, y) && bar.isLockEnter()) {
            bar.unlockEnter();
            this.fireBarExited(bar);
        }
    }

    @Override
    public void onDrag(MouseEvent me) {
        List bars = this.getSymbols();
        for (SymbolComponent symbolComponent : bars) {
            if (symbolComponent instanceof StackedBarSymbol) {
                StackedBarSymbol stackedBar = (StackedBarSymbol)symbolComponent;
                this.barEnterExitTracker(stackedBar, me.getX(), me.getY());
                List<Stack> barStacks = stackedBar.getStacks();
                for (Stack stack : barStacks) {
                    this.barEnterExitTracker(stack, me.getX(), me.getY());
                }
                continue;
            }
            if (symbolComponent instanceof BarSymbolGroup) {
                BarSymbolGroup group = (BarSymbolGroup)symbolComponent;
                List<BarSymbol> barsGroup = group.getSymbolComponents();
                for (SymbolComponent symbolComponent2 : barsGroup) {
                    if (symbolComponent2 instanceof StackedBarSymbol) {
                        StackedBarSymbol stackedBar = (StackedBarSymbol)symbolComponent2;
                        this.barEnterExitTracker(stackedBar, me.getX(), me.getY());
                        List<Stack> barStacks = stackedBar.getStacks();
                        for (Stack barStack : barStacks) {
                            this.barEnterExitTracker(barStack, me.getX(), me.getY());
                        }
                        continue;
                    }
                    if (!(symbolComponent2 instanceof BarSymbol)) continue;
                    this.barEnterExitTracker((BarSymbol)symbolComponent2, me.getX(), me.getY());
                }
                continue;
            }
            if (!(symbolComponent instanceof BarSymbol)) continue;
            this.barEnterExitTracker((BarSymbol)symbolComponent, me.getX(), me.getY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBarEntered(BarSymbol bar) {
        Object[] listeners;
        Object[] objectArray = listeners = this.symbolListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != BarListener.class) continue;
                ((BarListener)listeners[i + 1]).barSymbolEntered(new BarEvent(bar));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBarExited(BarSymbol bar) {
        Object[] listeners;
        Object[] objectArray = listeners = this.symbolListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != BarListener.class) continue;
                ((BarListener)listeners[i + 1]).barSymbolExited(new BarEvent(bar));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBarClicked(BarSymbol bar) {
        Object[] listeners;
        Object[] objectArray = listeners = this.symbolListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != BarListener.class) continue;
                ((BarListener)listeners[i + 1]).barSymbolClicked(new BarEvent(bar));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBarPressed(BarSymbol bar) {
        Object[] listeners;
        Object[] objectArray = listeners = this.symbolListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != BarListener.class) continue;
                ((BarListener)listeners[i + 1]).barSymbolPressed(new BarEvent(bar));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBarReleased(BarSymbol bar) {
        Object[] listeners;
        Object[] objectArray = listeners = this.symbolListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != BarListener.class) continue;
                ((BarListener)listeners[i + 1]).barSymbolReleased(new BarEvent(bar));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }
}

