/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.symbol;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.symbol.BarSymbol;
import org.jensoft.core.plugin.symbol.Stack;
import org.jensoft.core.plugin.symbol.painter.label.AbstractBarLabel;

public class StackedBarSymbol
extends BarSymbol {
    private List<Stack> stacks = new ArrayList<Stack>();

    public StackedBarSymbol() {
        super("barname", "barsymbol");
    }

    public StackedBarSymbol(String symbol) {
        super(symbol, symbol);
    }

    public StackedBarSymbol(String name, String symbol) {
        super(name, symbol);
    }

    public double getStackBase(Stack stack) {
        double base = super.getBase();
        for (Stack s : this.stacks) {
            if (stack.equals(s)) {
                return base;
            }
            if (this.isAscent()) {
                base += s.getNormalizedValue();
                continue;
            }
            if (!this.isDescent()) continue;
            base -= s.getNormalizedValue();
        }
        return base;
    }

    public void addStack(String name, Color themeColor, double proportionValue) {
        if (proportionValue < 0.0) {
            throw new IllegalArgumentException("stack proportion value should be greater than 0");
        }
        Stack stack = new Stack(name, themeColor, proportionValue);
        stack.setHostSymbol(this);
        this.stacks.add(stack);
    }

    public void addStack(String name, Color themeColor, double proportionValue, AbstractBarLabel barLabel) {
        if (proportionValue < 0.0) {
            throw new IllegalArgumentException("stack proportion value should be greater than 0");
        }
        Stack stack = new Stack(name, themeColor, proportionValue);
        stack.setBarLabel(barLabel);
        stack.setHostSymbol(this);
        this.stacks.add(stack);
    }

    public void addStack(Stack stack) {
        if (stack.getValue() < 0.0) {
            throw new IllegalArgumentException("stack proportion value should be greater than 0");
        }
        stack.setHostSymbol(this);
        this.stacks.add(stack);
    }

    public void normalize() {
        double deltaValue = Math.abs(this.getValue());
        double stacksSumValue = 0.0;
        for (Stack s : this.stacks) {
            stacksSumValue += s.getStackValue();
        }
        for (Stack s : this.stacks) {
            s.setNormalizedValue(s.getStackValue() * deltaValue / stacksSumValue);
        }
    }

    public List<Stack> getStacks() {
        return this.stacks;
    }
}

