/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.symbol;

import org.jensoft.core.plugin.symbol.SymbolLayer;
import org.jensoft.core.plugin.symbol.SymbolPlugin;

public class SymbolComponent {
    private boolean isFiller = false;
    private FillerType fillerType;
    private SymbolLayer<? extends SymbolComponent> layer;
    private SymbolPlugin.SymbolNature nature;
    private boolean opaque;
    private double thickness = 0.0;
    private String name;
    private SymbolPlugin host;
    private boolean lockEnter = false;
    private boolean visible = true;
    private Object userObject;

    public SymbolLayer<? extends SymbolComponent> getLayer() {
        return this.layer;
    }

    public void setLayer(SymbolLayer<? extends SymbolComponent> layer) {
        this.layer = layer;
    }

    public boolean isFiller() {
        return this.isFiller;
    }

    public void setFiller(boolean isFiller) {
        this.isFiller = isFiller;
    }

    public static <T extends SymbolComponent> T createGlue(Class<T> c) {
        try {
            SymbolComponent glue = (SymbolComponent)c.newInstance();
            glue.setName("SymbolComponent.Glue");
            glue.setFillerType(FillerType.Glue);
            glue.setOpaque(false);
            glue.setFiller(true);
            return (T)glue;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T extends SymbolComponent> T createStrut(Class<T> c, double thickness) {
        try {
            SymbolComponent strut = (SymbolComponent)c.newInstance();
            strut.setName("SymbolComponent.Strut." + strut);
            strut.setOpaque(false);
            strut.setThickness(thickness);
            strut.setFillerType(FillerType.Strut);
            strut.setFiller(true);
            return (T)strut;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public FillerType getFillerType() {
        return this.fillerType;
    }

    public void setFillerType(FillerType fillerType) {
        this.fillerType = fillerType;
    }

    public SymbolPlugin getHost() {
        return this.host;
    }

    public void setHost(SymbolPlugin host) {
        this.host = host;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getLayer() != null ? this.getClass().getSimpleName() + "_" + this.getLayer().getSymbolIndex(this) : this.getClass().getSimpleName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
    }

    public double getLocationX() {
        if (this.layer == null) {
            return 0.0;
        }
        if (this.nature == SymbolPlugin.SymbolNature.Horizontal) {
            throw new IllegalStateException("Horizontal symbol has no location x");
        }
        return this.layer.getComponentXLocation(this);
    }

    public double getCenterX() {
        if (this.layer == null) {
            return 0.0;
        }
        return this.getLocationX() + this.getThickness() / 2.0;
    }

    public double getLocationY() {
        if (this.layer == null) {
            return 0.0;
        }
        if (this.nature == SymbolPlugin.SymbolNature.Vertical) {
            throw new IllegalStateException("Vertical symbol has no location y");
        }
        return this.layer.getComponentYLocation(this);
    }

    public double getCenterY() {
        if (this.layer == null) {
            return 0.0;
        }
        return this.getLocationY() - this.getThickness() / 2.0;
    }

    public SymbolPlugin.SymbolNature getNature() {
        return this.nature;
    }

    public void setNature(SymbolPlugin.SymbolNature nature) {
        this.nature = nature;
    }

    public boolean isLockEnter() {
        return this.lockEnter;
    }

    public void lockEnter() {
        if (!this.isLockEnter()) {
            this.lockEnter = true;
        }
    }

    public void unlockEnter() {
        if (this.isLockEnter()) {
            this.lockEnter = false;
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public static enum FillerType {
        Glue,
        Strut;

    }
}

