/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.symbol;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.symbol.Stack;
import org.jensoft.core.plugin.symbol.SymbolComponent;
import org.jensoft.core.plugin.symbol.SymbolPlugin;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public abstract class SymbolLayer<S extends SymbolComponent> {
    private SymbolPlugin host;
    private List<S> symbols = new ArrayList<S>();

    public SymbolPlugin getHost() {
        return this.host;
    }

    public void setHost(SymbolPlugin host) {
        this.host = host;
    }

    public void addSymbol(S symbol) {
        ((SymbolComponent)symbol).setLayer(this);
        this.symbols.add(symbol);
    }

    public void removeSymbol(S symbol) {
        ((SymbolComponent)symbol).setLayer(null);
        this.symbols.remove(symbol);
    }

    public int countSymbols() {
        return this.symbols.size();
    }

    public S getSymbol(int index) {
        return (S)((SymbolComponent)this.symbols.get(index));
    }

    public List<S> getSymbols() {
        return this.symbols;
    }

    public void setSymbols(List<S> symbols) {
        this.symbols = symbols;
    }

    public int getSymbolIndex(SymbolComponent symbol) {
        if (symbol == null) {
            return -1;
        }
        for (int i = 0; i < this.symbols.size(); ++i) {
            SymbolComponent s = (SymbolComponent)this.symbols.get(i);
            if (!s.equals(symbol)) continue;
            return i;
        }
        return -1;
    }

    public abstract void paintLayer(View var1, Graphics2D var2, ViewPart var3, SymbolPlugin.PaintRequest var4);

    public abstract List<S> getFlattenSymbolComponents();

    public final void solveGeometry() {
        List<S> symbols = this.getSymbols();
        for (SymbolComponent symbol : symbols) {
            if (symbol.isFiller()) continue;
            this.solveSymbolComponent(symbol);
        }
    }

    public abstract void solveSymbolComponent(S var1);

    protected void onMove(MouseEvent me) {
    }

    protected void onClick(MouseEvent me) {
    }

    protected void onExit(MouseEvent me) {
    }

    protected void onEnter(MouseEvent me) {
    }

    protected void onPress(MouseEvent me) {
    }

    protected void onRelease(MouseEvent me) {
    }

    public void onDrag(MouseEvent me) {
    }

    protected double getComponentXLocation(SymbolComponent symbol) {
        if (symbol instanceof Stack) {
            symbol = ((Stack)symbol).getHostSymbol();
        }
        List<S> flattenSymbols = this.getFlattenSymbolComponents();
        double total = 0.0;
        ArrayList<SymbolComponent> glues = new ArrayList<SymbolComponent>();
        for (SymbolComponent bc : flattenSymbols) {
            if (bc.isFiller() && bc.getFillerType() == SymbolComponent.FillerType.Glue) {
                glues.add(bc);
                continue;
            }
            total += bc.getThickness();
        }
        if ((double)this.getHost().getProjection().getDevice2D().getDeviceWidth() > total) {
            double reste = (double)this.getHost().getProjection().getDevice2D().getDeviceWidth() - total;
            int gluesCount = glues.size();
            if (gluesCount > 0) {
                for (SymbolComponent glue : glues) {
                    glue.setThickness(reste / (double)gluesCount);
                }
            }
        }
        double positionX = 0.0;
        for (SymbolComponent bc : flattenSymbols) {
            if (!bc.equals(symbol)) {
                positionX += bc.getThickness();
                continue;
            }
            return positionX;
        }
        return positionX;
    }

    protected double getComponentYLocation(SymbolComponent symbol) {
        List<S> flattenSymbols = this.getFlattenSymbolComponents();
        double total = 0.0;
        ArrayList<SymbolComponent> glues = new ArrayList<SymbolComponent>();
        for (SymbolComponent bc : flattenSymbols) {
            if (bc.isFiller() && bc.getFillerType() == SymbolComponent.FillerType.Glue) {
                glues.add(bc);
                continue;
            }
            total += bc.getThickness();
        }
        if ((double)this.getHost().getProjection().getDevice2D().getDeviceHeight() > total) {
            double reste = (double)this.getHost().getProjection().getDevice2D().getDeviceHeight() - total;
            int gluesCount = glues.size();
            if (gluesCount > 0) {
                for (SymbolComponent glue : glues) {
                    glue.setThickness(reste / (double)gluesCount);
                }
            }
        }
        double positionY = 0.0;
        for (SymbolComponent bc : flattenSymbols) {
            if (!bc.equals(symbol)) {
                positionY += bc.getThickness();
                continue;
            }
            return positionY;
        }
        return positionY;
    }
}

