/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.symbol;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.Toolkit;
import org.jensoft.core.plugin.symbol.BarSymbol;
import org.jensoft.core.plugin.symbol.BarSymbolGroup;
import org.jensoft.core.plugin.symbol.PointSymbol;
import org.jensoft.core.plugin.symbol.PolylinePointSymbol;
import org.jensoft.core.plugin.symbol.Stack;
import org.jensoft.core.plugin.symbol.StackedBarSymbol;
import org.jensoft.core.plugin.symbol.painter.draw.AbstractBarDraw;
import org.jensoft.core.plugin.symbol.painter.draw.BarDefaultDraw;
import org.jensoft.core.plugin.symbol.painter.effect.AbstractBarEffect;
import org.jensoft.core.plugin.symbol.painter.effect.BarEffect1;
import org.jensoft.core.plugin.symbol.painter.fill.AbstractBarFill;
import org.jensoft.core.plugin.symbol.painter.fill.BarDefaultFill;
import org.jensoft.core.plugin.symbol.painter.fill.BarFill1;
import org.jensoft.core.plugin.symbol.painter.fill.BarFill2;

public class SymbolToolkit
extends Toolkit {
    public static final BarSymbolGroup createBarGroup(String nameSymbol, double base, double thickness) {
        BarSymbolGroup group = new BarSymbolGroup(nameSymbol, nameSymbol);
        group.setBase(base);
        group.setThickness(thickness);
        group.setRound(8);
        group.setMorpheStyle(BarSymbol.MorpheStyle.Round);
        group.setBarDraw(new BarDefaultDraw(Color.WHITE));
        group.setBarFill(new BarFill2());
        group.setBarEffect(new BarEffect1());
        return group;
    }

    public static final BarSymbolGroup createBarGroup(String nameSymbol, double base, double thickness, int round) {
        BarSymbolGroup group = new BarSymbolGroup(nameSymbol, nameSymbol);
        group.setBase(base);
        group.setThickness(thickness);
        group.setRound(round);
        group.setMorpheStyle(BarSymbol.MorpheStyle.Round);
        group.setBarDraw(new BarDefaultDraw(Color.WHITE));
        group.setBarFill(new BarFill2());
        group.setBarEffect(new BarEffect1());
        return group;
    }

    public static final BarSymbolGroup createBarGroup(String nameSymbol, double base, double thickness, AbstractBarDraw barDraw, AbstractBarFill barFill, AbstractBarEffect barEffect) {
        BarSymbolGroup group = new BarSymbolGroup(nameSymbol, nameSymbol);
        group.setBase(base);
        group.setThickness(thickness);
        group.setBarDraw(barDraw);
        group.setBarFill(barFill);
        group.setBarEffect(barEffect);
        group.setRound(8);
        group.setMorpheStyle(BarSymbol.MorpheStyle.Round);
        return group;
    }

    public static final StackedBarSymbol createStackedBarSymbol(String nameSymbol, double base, double thickness, BarSymbol.SymbolInflate symbolInflate, double symbolInflateValue) {
        StackedBarSymbol stackedSymbol = new StackedBarSymbol(nameSymbol, nameSymbol);
        stackedSymbol.setThemeColor(new Color(255, 255, 255));
        stackedSymbol.setBase(base);
        stackedSymbol.setThickness(thickness);
        if (symbolInflate == BarSymbol.SymbolInflate.Ascent) {
            stackedSymbol.setAscentValue(symbolInflateValue);
        }
        if (symbolInflate == BarSymbol.SymbolInflate.Descent) {
            stackedSymbol.setDescentValue(symbolInflateValue);
        }
        stackedSymbol.setMorpheStyle(BarSymbol.MorpheStyle.Round);
        stackedSymbol.setBarDraw(new BarDefaultDraw(Color.WHITE));
        stackedSymbol.setBarFill(new BarFill1());
        stackedSymbol.setBarEffect(new BarEffect1());
        return stackedSymbol;
    }

    public static final StackedBarSymbol createStackedBarSymbol(String nameSymbol, BarSymbol.SymbolInflate symbolInflate, double symbolInflateValue) {
        StackedBarSymbol stackedSymbol = new StackedBarSymbol(nameSymbol, nameSymbol);
        stackedSymbol.setThemeColor(new Color(255, 255, 255));
        if (symbolInflate == BarSymbol.SymbolInflate.Ascent) {
            stackedSymbol.setAscentValue(symbolInflateValue);
        }
        if (symbolInflate == BarSymbol.SymbolInflate.Descent) {
            stackedSymbol.setDescentValue(symbolInflateValue);
        }
        return stackedSymbol;
    }

    public static void pushStacks(StackedBarSymbol stackedSymbol, Stack ... stacks) {
        for (int i = 0; i < stacks.length; ++i) {
            stackedSymbol.addStack(stacks[i]);
        }
    }

    public static void pushStacks(StackedBarSymbol stackedSymbol, List<Stack> stacks) {
        for (Stack s : stacks) {
            stackedSymbol.addStack(s);
        }
    }

    public static final StackedBarSymbol createStackedBarSymbol(String nameSymbol, double base, double thickness, BarSymbol.SymbolInflate symbolInflate, double symbolInflateValue, Stack ... stacks) {
        StackedBarSymbol stackedSymbol = new StackedBarSymbol(nameSymbol, nameSymbol);
        stackedSymbol.setThemeColor(new Color(255, 255, 255));
        stackedSymbol.setBase(base);
        stackedSymbol.setThickness(thickness);
        if (symbolInflate == BarSymbol.SymbolInflate.Ascent) {
            stackedSymbol.setAscentValue(symbolInflateValue);
        }
        if (symbolInflate == BarSymbol.SymbolInflate.Descent) {
            stackedSymbol.setDescentValue(symbolInflateValue);
        }
        stackedSymbol.setMorpheStyle(BarSymbol.MorpheStyle.Round);
        stackedSymbol.setBarDraw(new BarDefaultDraw(Color.WHITE));
        stackedSymbol.setBarFill(new BarFill1());
        stackedSymbol.setBarEffect(new BarEffect1());
        for (int i = 0; i < stacks.length; ++i) {
            stackedSymbol.addStack(stacks[i]);
        }
        return stackedSymbol;
    }

    public static final StackedBarSymbol createStackedBarSymbol(String nameSymbol, double base, double thickness, BarSymbol.SymbolInflate symbolInflate, double symbolInflateValue, List<Stack> stacks) {
        StackedBarSymbol stackedSymbol = new StackedBarSymbol(nameSymbol, nameSymbol);
        stackedSymbol.setThemeColor(new Color(255, 255, 255));
        stackedSymbol.setBase(base);
        stackedSymbol.setThickness(thickness);
        if (symbolInflate == BarSymbol.SymbolInflate.Ascent) {
            stackedSymbol.setAscentValue(symbolInflateValue);
        }
        if (symbolInflate == BarSymbol.SymbolInflate.Descent) {
            stackedSymbol.setDescentValue(symbolInflateValue);
        }
        stackedSymbol.setMorpheStyle(BarSymbol.MorpheStyle.Round);
        stackedSymbol.setBarDraw(new BarDefaultDraw(Color.WHITE));
        stackedSymbol.setBarFill(new BarFill1());
        stackedSymbol.setBarEffect(new BarEffect1());
        for (int i = 0; i < stacks.size(); ++i) {
            stackedSymbol.addStack(stacks.get(i));
        }
        return stackedSymbol;
    }

    public static final StackedBarSymbol createStackedBarSymbol(String nameSymbol, BarSymbol.SymbolInflate symbolInflate, double symbolInflateValue, Stack ... stacks) {
        StackedBarSymbol stackedSymbol = new StackedBarSymbol(nameSymbol, nameSymbol);
        stackedSymbol.setThemeColor(new Color(255, 255, 255));
        if (symbolInflate == BarSymbol.SymbolInflate.Ascent) {
            stackedSymbol.setAscentValue(symbolInflateValue);
        }
        if (symbolInflate == BarSymbol.SymbolInflate.Descent) {
            stackedSymbol.setDescentValue(symbolInflateValue);
        }
        for (int i = 0; i < stacks.length; ++i) {
            stackedSymbol.addStack(stacks[i]);
        }
        return stackedSymbol;
    }

    public static final Stack createStack(String name, Color themeColor, double proportionValue) {
        if (proportionValue < 0.0) {
            throw new IllegalArgumentException("stack proportion value should be greater than 0");
        }
        Stack stack = new Stack(name, themeColor, proportionValue);
        return stack;
    }

    public static final List<Stack> createStacks(String[] names, Color[] themeColors, double[] proportionValues) {
        if (names.length != themeColors.length || names.length != proportionValues.length) {
            throw new IllegalArgumentException("properties array length does not match !");
        }
        ArrayList<Stack> stacks = new ArrayList<Stack>();
        int len = names.length;
        for (int i = 0; i < len; ++i) {
            stacks.add(SymbolToolkit.createStack(names[i], themeColors[i], proportionValues[i]));
        }
        return stacks;
    }

    public static final BarSymbol createBarSymbol(String nameSymbol, Color themeColor, BarSymbol.SymbolInflate symbolInflate, double symbolInflateValue) {
        BarSymbol b1 = new BarSymbol(nameSymbol, nameSymbol);
        b1.setThemeColor(themeColor);
        if (symbolInflate == BarSymbol.SymbolInflate.Ascent) {
            b1.setAscentValue(symbolInflateValue);
        }
        if (symbolInflate == BarSymbol.SymbolInflate.Descent) {
            b1.setDescentValue(symbolInflateValue);
        }
        b1.setMorpheStyle(BarSymbol.MorpheStyle.Round);
        b1.setBarDraw(new BarDefaultDraw(new Color(255, 255, 255)));
        b1.setBarFill(new BarDefaultFill());
        b1.setBarEffect(new BarEffect1());
        return b1;
    }

    public static final BarSymbol createBarSymbol(String nameSymbol, Color themeColor, double thickness, double base, BarSymbol.SymbolInflate symbolInflate, double symbolInflateValue) {
        BarSymbol b1 = new BarSymbol(nameSymbol, nameSymbol);
        b1.setThemeColor(themeColor);
        b1.setThickness(thickness);
        b1.setBase(base);
        if (symbolInflate == BarSymbol.SymbolInflate.Ascent) {
            b1.setAscentValue(symbolInflateValue);
        }
        if (symbolInflate == BarSymbol.SymbolInflate.Descent) {
            b1.setDescentValue(symbolInflateValue);
        }
        b1.setMorpheStyle(BarSymbol.MorpheStyle.Round);
        b1.setBarDraw(new BarDefaultDraw(new Color(255, 255, 255)));
        b1.setBarFill(new BarDefaultFill());
        b1.setBarEffect(new BarEffect1());
        return b1;
    }

    public static final BarSymbol createBarSymbol(String nameSymbol, Color themeColor, double thickness, double base, BarSymbol.SymbolInflate symbolInflate, double symbolInflateValue, AbstractBarDraw barDraw, AbstractBarFill barFill, AbstractBarEffect barEffect) {
        BarSymbol b1 = new BarSymbol(nameSymbol, nameSymbol);
        b1.setThemeColor(themeColor);
        b1.setThickness(thickness);
        b1.setBase(base);
        if (symbolInflate == BarSymbol.SymbolInflate.Ascent) {
            b1.setAscentValue(symbolInflateValue);
        }
        if (symbolInflate == BarSymbol.SymbolInflate.Descent) {
            b1.setDescentValue(symbolInflateValue);
        }
        b1.setMorpheStyle(BarSymbol.MorpheStyle.Round);
        b1.setBarDraw(barDraw);
        b1.setBarFill(barFill);
        b1.setBarEffect(barEffect);
        return b1;
    }

    public static PointSymbol createPointSymbol(double value) {
        PointSymbol ps = new PointSymbol(value);
        return ps;
    }

    public static PolylinePointSymbol createPolylinePointSymbol() {
        PolylinePointSymbol polyline = new PolylinePointSymbol();
        return polyline;
    }

    public static void pushPoints(PolylinePointSymbol polylineSymbol, PointSymbol ... pointSymbols) {
        for (int i = 0; i < pointSymbols.length; ++i) {
            polylineSymbol.addSymbol(pointSymbols[i]);
        }
    }

    public static void pushPoints(PolylinePointSymbol polylineSymbol, List<PointSymbol> pointSymbols) {
        for (PointSymbol ps : pointSymbols) {
            polylineSymbol.addSymbol(ps);
        }
    }
}

