/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.symbol.painter.axis;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.List;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.plugin.symbol.BarSymbol;
import org.jensoft.core.plugin.symbol.BarSymbolGroup;
import org.jensoft.core.plugin.symbol.SymbolComponent;
import org.jensoft.core.plugin.symbol.SymbolPlugin;
import org.jensoft.core.plugin.symbol.painter.axis.AbstractBarAxisLabel;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class BarDefaultAxisLabel
extends AbstractBarAxisLabel {
    private String text;
    private Color textColor;
    private Font font;
    private int offsetX = 0;
    private int offsetY = 0;
    private int textPaddingX = 4;
    private int textPaddingY = 2;
    private int outlineRound = 10;
    private Color drawColor;
    private Color fillColor;
    private float alpha = 1.0f;
    private Shader shader;
    private Stroke outlineStroke = new BasicStroke();

    public BarDefaultAxisLabel() {
    }

    public BarDefaultAxisLabel(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public BarDefaultAxisLabel(String symbol, Color symbolColor) {
        this.text = symbol;
        this.textColor = symbolColor;
    }

    public BarDefaultAxisLabel(String symbol, Color symbolColor, int offsetX, int offsetY) {
        this.text = symbol;
        this.textColor = symbolColor;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }

    public Shader getShader() {
        return this.shader;
    }

    public void setShader(Shader shader) {
        this.shader = shader;
    }

    public int getTextPaddingX() {
        return this.textPaddingX;
    }

    public void setTextPaddingX(int textPaddingX) {
        this.textPaddingX = textPaddingX;
    }

    public int getTextPaddingY() {
        return this.textPaddingY;
    }

    public void setTextPaddingY(int textPaddingY) {
        this.textPaddingY = textPaddingY;
    }

    public int getOutlineRound() {
        return this.outlineRound;
    }

    public void setOutlineRound(int outlineRound) {
        this.outlineRound = outlineRound;
    }

    public Color getDrawColor() {
        return this.drawColor;
    }

    public void setDrawColor(Color drawColor) {
        this.drawColor = drawColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke outlineStroke) {
        this.outlineStroke = outlineStroke;
    }

    @Override
    public void paintAxisLabel(Graphics2D g2d, BarSymbol bar, ViewPart viewPart) {
        g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
        if (bar.getHost().getNature() == SymbolPlugin.SymbolNature.Vertical) {
            this.paintVSymbol(g2d, bar, viewPart);
        }
        if (bar.getHost().getNature() == SymbolPlugin.SymbolNature.Horizontal) {
            this.paintHSymbol(g2d, bar, viewPart);
        }
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    private void paintVSymbol(Graphics2D g2d, BarSymbol bar, ViewPart viewPart) {
        SymbolPlugin bsp = bar.getHost();
        View v2d = bar.getHost().getProjection().getView();
        if (this.font == null) {
            this.setFont(new Font("Dialog", 0, 12));
        }
        g2d.setFont(this.getFont());
        FontMetrics fm = g2d.getFontMetrics();
        if (viewPart == ViewPart.South) {
            BarSymbolGroup group;
            List<BarSymbol> components;
            int margin = v2d.getPlaceHolderAxisWest();
            if (bar instanceof BarSymbol && !(bar instanceof BarSymbolGroup)) {
                BarSymbol bs = bar;
                String symbol = this.getText();
                if (symbol == null) {
                    symbol = bs.getSymbol();
                }
                if (symbol != null) {
                    double barWidth = bar.getThickness();
                    int symbolWidth = fm.stringWidth(symbol);
                    float pt = (float)(bs.getLocationX() + (double)margin + barWidth / 2.0 - (double)(symbolWidth / 2));
                    int x = (int)(pt + (float)this.offsetX);
                    int y = fm.getAscent() + this.offsetY;
                    RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(x - this.textPaddingX, y - fm.getAscent() - this.textPaddingY, symbolWidth + 2 * this.textPaddingX, fm.getHeight() + 2 * this.textPaddingY, this.outlineRound, this.outlineRound);
                    if (this.fillColor != null && this.shader == null) {
                        g2d.setColor(this.fillColor);
                        g2d.fill(roundRect);
                    }
                    if (this.shader != null) {
                        Point2D.Double start = new Point2D.Double(roundRect.getCenterX(), ((RectangularShape)roundRect).getY());
                        Point2D.Double end = new Point2D.Double(roundRect.getCenterX(), ((RectangularShape)roundRect).getY() + ((RectangularShape)roundRect).getHeight());
                        if (start != null && end != null && !start.equals(end)) {
                            LinearGradientPaint lgp = new LinearGradientPaint(start, end, this.shader.getFractions(), this.shader.getColors());
                            g2d.setPaint(lgp);
                            g2d.fill(roundRect);
                        }
                    }
                    if (this.drawColor != null) {
                        g2d.setColor(this.drawColor);
                        g2d.draw(roundRect);
                    }
                    if (this.getTextColor() != null) {
                        g2d.setColor(this.getTextColor());
                    } else {
                        g2d.setColor(bar.getThemeColor());
                    }
                    g2d.drawString(symbol, x, y);
                }
            } else if (bar instanceof BarSymbolGroup && (components = (group = (BarSymbolGroup)bar).getSymbolComponents()).size() > 0) {
                SymbolComponent firstComponent = components.get(0);
                double positionX = firstComponent.getLocationX();
                double widthComponent = group.getThickness();
                String symbol = this.getText();
                if (symbol == null) {
                    symbol = group.getSymbol();
                }
                if (symbol != null) {
                    int symbolWidth = fm.stringWidth(symbol);
                    float pt = (float)(positionX + (double)margin + widthComponent / 2.0 - (double)(symbolWidth / 2));
                    int x = (int)(pt + (float)this.offsetX);
                    int y = fm.getAscent() + this.offsetY;
                    RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(x - this.textPaddingX, y - fm.getAscent() - this.textPaddingY, symbolWidth + 2 * this.textPaddingX, fm.getHeight() + 2 * this.textPaddingY, this.outlineRound, this.outlineRound);
                    if (this.fillColor != null) {
                        g2d.setColor(this.fillColor);
                        g2d.fill(roundRect);
                    }
                    if (this.shader != null) {
                        Point2D.Double start = new Point2D.Double(roundRect.getCenterX(), ((RectangularShape)roundRect).getY());
                        Point2D.Double end = new Point2D.Double(roundRect.getCenterX(), ((RectangularShape)roundRect).getY() + ((RectangularShape)roundRect).getHeight());
                        if (start != null && end != null && !start.equals(end)) {
                            LinearGradientPaint lgp = new LinearGradientPaint(start, end, this.shader.getFractions(), this.shader.getColors());
                            g2d.setPaint(lgp);
                            g2d.fill(roundRect);
                        }
                    }
                    if (this.drawColor != null) {
                        g2d.setColor(this.drawColor);
                        g2d.draw(roundRect);
                    }
                    if (this.getTextColor() != null) {
                        g2d.setColor(this.getTextColor());
                    } else {
                        g2d.setColor(group.getThemeColor());
                    }
                    g2d.drawString(symbol, x, y);
                }
            }
        }
    }

    private void paintHSymbol(Graphics2D g2d, BarSymbol bar, ViewPart viewPart) {
        SymbolPlugin bsp = bar.getHost();
        View v2d = bar.getHost().getProjection().getView();
        if (this.font == null) {
            this.setFont(new Font("Dialog", 0, 12));
        }
        g2d.setFont(this.getFont());
        FontMetrics fm = g2d.getFontMetrics();
        if (viewPart == ViewPart.West) {
            BarSymbolGroup group;
            List<BarSymbol> components;
            int margin = v2d.getPlaceHolderAxisWest();
            if (bar instanceof BarSymbol && !(bar instanceof BarSymbolGroup)) {
                String symbol = this.getText();
                if (symbol == null) {
                    symbol = bar.getSymbol();
                }
                double barWidth = bar.getThickness();
                g2d.setColor(bar.getThemeColor());
                if (symbol != null) {
                    int symbolWidth = fm.stringWidth(symbol);
                    float pt = (float)(bar.getLocationY() + barWidth / 2.0 + (double)(fm.getAscent() / 2));
                    int x = margin - symbolWidth - this.textPaddingX + this.offsetX - 4;
                    int y = (int)(pt + (float)this.offsetY);
                    RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(x - this.textPaddingX, y - fm.getAscent() - this.textPaddingY, symbolWidth + 2 * this.textPaddingX, fm.getHeight() + 2 * this.textPaddingY, this.outlineRound, this.outlineRound);
                    if (this.fillColor != null) {
                        g2d.setColor(this.fillColor);
                        g2d.fill(roundRect);
                    }
                    if (this.drawColor != null) {
                        g2d.setColor(this.drawColor);
                        g2d.draw(roundRect);
                    }
                    if (this.getTextColor() != null) {
                        g2d.setColor(this.getTextColor());
                    } else {
                        g2d.setColor(bar.getThemeColor());
                    }
                    g2d.drawString(symbol, (float)x, pt + (float)this.offsetY);
                }
            } else if (bar instanceof BarSymbolGroup && (components = (group = (BarSymbolGroup)bar).getSymbolComponents()).size() > 0) {
                SymbolComponent firstComponent = components.get(0);
                double positionY = firstComponent.getLocationY();
                double heightComponent = group.getThickness();
                String symbol = this.getText();
                if (symbol == null) {
                    symbol = group.getSymbol();
                }
                if (symbol != null) {
                    int symbolWidth = fm.stringWidth(symbol);
                    float pt = (float)(positionY + heightComponent / 2.0 + (double)(fm.getAscent() / 2));
                    int x = margin - symbolWidth + this.offsetX - this.textPaddingX - 4;
                    int y = (int)(pt + (float)this.offsetY);
                    RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(x - this.textPaddingX, y - fm.getAscent() - this.textPaddingY, symbolWidth + 2 * this.textPaddingX, fm.getHeight() + 2 * this.textPaddingY, this.outlineRound, this.outlineRound);
                    if (this.fillColor != null) {
                        g2d.setColor(this.fillColor);
                        g2d.fill(roundRect);
                    }
                    if (this.drawColor != null) {
                        g2d.setColor(this.drawColor);
                        if (this.outlineStroke != null) {
                            g2d.setStroke(this.getOutlineStroke());
                        }
                        g2d.draw(roundRect);
                    }
                    if (this.getTextColor() != null) {
                        g2d.setColor(this.getTextColor());
                    } else {
                        g2d.setColor(group.getThemeColor());
                    }
                    g2d.drawString(symbol, (float)x, pt + (float)this.offsetY);
                }
            }
        }
    }
}

