/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.symbol.painter.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.jensoft.core.plugin.symbol.BarSymbol;
import org.jensoft.core.plugin.symbol.painter.draw.AbstractBarDraw;

public class BarDefaultDraw
extends AbstractBarDraw {
    private Color outlineColor;
    private Stroke outlineStroke;

    public BarDefaultDraw() {
    }

    public BarDefaultDraw(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    public BarDefaultDraw(Color outlineColor, Stroke outlineStroke) {
        this.outlineColor = outlineColor;
        this.outlineStroke = outlineStroke;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke outlineStroke) {
        this.outlineStroke = outlineStroke;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    @Override
    protected void paintBarDraw(Graphics2D g2d, BarSymbol bar) {
        Color cBase = bar.getThemeColor();
        if (this.outlineColor != null) {
            cBase = this.outlineColor;
        }
        if (this.outlineStroke == null) {
            this.outlineStroke = new BasicStroke(1.0f);
        }
        g2d.setColor(cBase);
        g2d.setStroke(this.outlineStroke);
        if (bar != null && bar.getBarShape() != null) {
            g2d.draw(bar.getBarShape());
        }
    }
}

