/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.symbol.painter.label;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import org.jensoft.core.plugin.symbol.BarSymbol;
import org.jensoft.core.plugin.symbol.SymbolPlugin;
import org.jensoft.core.plugin.symbol.painter.label.AbstractBarLabel;

public class BarSymbolDefaultLabel
extends AbstractBarLabel {
    private int verticalOffset = 0;
    private int horizontalOffset = 0;
    private Font font;
    private Color labelColor;
    private Color fillColor;
    private Color drawColor;
    private DecimalFormat decimalFormat = new DecimalFormat("##.00");
    private String label;
    private int roundCorner = 6;

    public BarSymbolDefaultLabel() {
    }

    public BarSymbolDefaultLabel(String label, Color labelColor) {
        this.label = label;
        this.labelColor = labelColor;
    }

    public BarSymbolDefaultLabel(int verticalOffset, int horizontalOffset) {
        this.verticalOffset = verticalOffset;
        this.horizontalOffset = horizontalOffset;
    }

    public BarSymbolDefaultLabel(int verticalOffset, int horizontalOffset, String label) {
        this.verticalOffset = verticalOffset;
        this.horizontalOffset = horizontalOffset;
        this.label = label;
    }

    public BarSymbolDefaultLabel(int verticalOffset, int horizontalOffset, String label, Color labelColor) {
        this.verticalOffset = verticalOffset;
        this.horizontalOffset = horizontalOffset;
        this.label = label;
        this.labelColor = labelColor;
    }

    public BarSymbolDefaultLabel(int verticalOffset, int horizontalOffset, String label, Color labelColor, Color fillColor) {
        this.verticalOffset = verticalOffset;
        this.horizontalOffset = horizontalOffset;
        this.label = label;
        this.labelColor = labelColor;
        this.fillColor = fillColor;
    }

    public BarSymbolDefaultLabel(String label, Color labelColor, Color fillColor) {
        this.label = label;
        this.labelColor = labelColor;
        this.fillColor = fillColor;
    }

    public BarSymbolDefaultLabel(int verticalOffset, int horizontalOffset, String label, Color labelColor, Color fillColor, Color drawColor) {
        this.verticalOffset = verticalOffset;
        this.horizontalOffset = horizontalOffset;
        this.label = label;
        this.labelColor = labelColor;
        this.fillColor = fillColor;
        this.drawColor = drawColor;
    }

    public BarSymbolDefaultLabel(int verticalOffset, int horizontalOffset, Color labelColor, Color fillColor, Color drawColor) {
        this.verticalOffset = verticalOffset;
        this.horizontalOffset = horizontalOffset;
        this.labelColor = labelColor;
        this.fillColor = fillColor;
        this.drawColor = drawColor;
    }

    public BarSymbolDefaultLabel(String label, Color labelColor, Color fillColor, Color drawColor) {
        this.label = label;
        this.labelColor = labelColor;
        this.fillColor = fillColor;
        this.drawColor = drawColor;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public int getRoundCorner() {
        return this.roundCorner;
    }

    public void setRoundCorner(int roundCorner) {
        this.roundCorner = roundCorner;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public Color getDrawColor() {
        return this.drawColor;
    }

    public void setDrawColor(Color drawColor) {
        this.drawColor = drawColor;
    }

    public int getVerticalOffset() {
        return this.verticalOffset;
    }

    public void setVerticalOffset(int verticalOffset) {
        this.verticalOffset = verticalOffset;
    }

    public int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public void setHorizontalOffset(int horizontalOffset) {
        this.horizontalOffset = horizontalOffset;
    }

    @Override
    public void paintBarLabel(Graphics2D g2d, BarSymbol bar) {
        if (bar.getHost().getNature() == SymbolPlugin.SymbolNature.Vertical) {
            this.paintVLabel(g2d, bar);
        }
        if (bar.getHost().getNature() == SymbolPlugin.SymbolNature.Horizontal) {
            this.paintHLabel(g2d, bar);
        }
    }

    private void paintVLabel(Graphics2D g2d, BarSymbol bar) {
        if (this.font == null) {
            this.setFont(new Font("Dialog", 0, 12));
        }
        g2d.setFont(this.getFont());
        FontMetrics fm = g2d.getFontMetrics();
        double value = bar.getValue();
        String sVal = this.decimalFormat.format(value);
        if (this.getLabel() != null) {
            sVal = this.getLabel();
        }
        int labelWidth = fm.stringWidth(sVal);
        Shape barShape = bar.getBarShape();
        double centerX = barShape.getBounds2D().getCenterX() + (double)this.horizontalOffset;
        int marginY = 2;
        int marginX = 2;
        double y = barShape.getBounds2D().getY();
        if (bar.isAscent()) {
            y = barShape.getBounds2D().getY() - (double)(fm.getDescent() + marginY) - (double)this.verticalOffset;
        }
        if (bar.isDescent()) {
            y = barShape.getBounds2D().getY() + barShape.getBounds2D().getHeight() + (double)(fm.getAscent() + marginY) + (double)this.verticalOffset;
        }
        RoundRectangle2D.Double recLabel = new RoundRectangle2D.Double(centerX - (double)(labelWidth / 2) - (double)marginX, y - (double)fm.getAscent() - (double)marginY, labelWidth + 2 * marginX, fm.getDescent() + fm.getAscent() + 2 * marginY, this.roundCorner, this.roundCorner);
        if (this.getFillColor() != null) {
            g2d.setColor(this.getFillColor());
            g2d.fill(recLabel);
        }
        if (this.getDrawColor() != null) {
            g2d.setColor(this.getDrawColor());
            g2d.draw(recLabel);
        }
        if (this.getLabelColor() == null) {
            if (bar.getThemeColor() != null) {
                this.setLabelColor(bar.getThemeColor());
            } else {
                this.setLabelColor(Color.RED);
            }
        }
        g2d.setColor(this.getLabelColor());
        if (bar.isAscent()) {
            g2d.drawString(sVal, (int)(centerX - (double)(labelWidth / 2)), (int)y);
        }
        if (bar.isDescent()) {
            g2d.drawString(sVal, (int)(centerX - (double)(labelWidth / 2)), (int)y);
        }
    }

    private void paintHLabel(Graphics2D g2d, BarSymbol bar) {
        if (this.font == null) {
            this.setFont(new Font("Dialog", 0, 12));
        }
        g2d.setFont(this.getFont());
        FontMetrics fm = g2d.getFontMetrics();
        double value = bar.getValue();
        String sVal = this.decimalFormat.format(value);
        if (this.getLabel() != null) {
            sVal = this.getLabel();
        }
        int labelWidth = fm.stringWidth(sVal);
        int marginY = 2;
        int marginX = 2;
        Shape barShape = bar.getBarShape();
        double pointX = barShape.getBounds2D().getX() + barShape.getBounds2D().getWidth() + (double)this.horizontalOffset;
        if (bar.isAscent()) {
            pointX = barShape.getBounds2D().getX() + barShape.getBounds2D().getWidth() + (double)marginX + (double)this.horizontalOffset;
        }
        if (bar.isDescent()) {
            pointX = barShape.getBounds2D().getX() - (double)marginX - (double)this.horizontalOffset - (double)labelWidth;
        }
        double pointY = barShape.getBounds2D().getCenterY() + (double)this.verticalOffset + (double)(fm.getAscent() / 2);
        RoundRectangle2D.Double recLabel = new RoundRectangle2D.Double(pointX - (double)(labelWidth / 2) - (double)marginX, pointY - (double)fm.getAscent() - (double)marginY, labelWidth + 2 * marginX, fm.getDescent() + fm.getAscent() + 2 * marginY, this.roundCorner, this.roundCorner);
        if (this.getFillColor() != null) {
            g2d.setColor(this.getFillColor());
            g2d.fill(recLabel);
        }
        if (this.getDrawColor() != null) {
            g2d.setColor(this.getDrawColor());
            g2d.draw(recLabel);
        }
        if (this.getLabelColor() == null) {
            if (bar.getThemeColor() != null) {
                this.setLabelColor(bar.getThemeColor());
            } else {
                this.setLabelColor(Color.RED);
            }
        }
        g2d.setColor(this.getLabelColor());
        if (bar.isAscent()) {
            g2d.drawString(sVal, (int)(pointX - (double)(labelWidth / 2)), (int)pointY);
        }
        if (bar.isDescent()) {
            g2d.drawString(sVal, (int)(pointX - (double)(labelWidth / 2)), (int)pointY);
        }
    }
}

