/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.symbol.painter.point;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import org.jensoft.core.palette.color.TangoPalette;
import org.jensoft.core.plugin.symbol.PointSymbol;
import org.jensoft.core.plugin.symbol.SymbolPlugin;
import org.jensoft.core.plugin.symbol.painter.point.AbstractPointSymbolPainter;

public class PointSymbolDebugGeometryPainter
extends AbstractPointSymbolPainter {
    private Color pointColor = TangoPalette.SCARLETRED1;

    public PointSymbolDebugGeometryPainter() {
    }

    public PointSymbolDebugGeometryPainter(Color pointColor) {
        this.pointColor = pointColor;
    }

    @Override
    protected void paintPointSymbol(Graphics2D g2d, PointSymbol point) {
        Line2D.Double e;
        if (point.isFiller()) {
            return;
        }
        g2d.setColor(this.pointColor);
        Ellipse2D.Double loc = new Ellipse2D.Double(point.getDevicePoint().getX() - 2.0, point.getDevicePoint().getY() - 2.0, 4.0, 4.0);
        g2d.draw(loc);
        if (point.getNature() == SymbolPlugin.SymbolNature.Vertical) {
            e = new Line2D.Double(point.getDevicePoint().getX(), point.getDevicePoint().getY(), point.getDevicePoint().getX() + point.getThickness(), point.getDevicePoint().getY());
            g2d.draw(e);
        }
        if (point.getNature() == SymbolPlugin.SymbolNature.Horizontal) {
            e = new Line2D.Double(point.getDevicePoint().getX(), point.getDevicePoint().getY(), point.getDevicePoint().getX(), point.getDevicePoint().getY() - point.getThickness());
            g2d.draw(e);
        }
    }
}

