/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.symbol.painter.polyline;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.List;
import org.jensoft.core.palette.color.TangoPalette;
import org.jensoft.core.plugin.symbol.PointSymbol;
import org.jensoft.core.plugin.symbol.PolylinePointSymbol;
import org.jensoft.core.plugin.symbol.SymbolPlugin;
import org.jensoft.core.plugin.symbol.painter.polyline.AbstractPolylinePointSymbolPainter;

public class PolylinePointSymbolDebugGeometryPainter
extends AbstractPolylinePointSymbolPainter {
    private Color pointColor = TangoPalette.SCARLETRED1;

    public PolylinePointSymbolDebugGeometryPainter() {
    }

    public PolylinePointSymbolDebugGeometryPainter(Color pointColor) {
        this.pointColor = pointColor;
    }

    @Override
    protected void paintPolylinePointSymbol(Graphics2D g2d, PolylinePointSymbol polyline) {
        g2d.setColor(this.pointColor);
        GeneralPath path = new GeneralPath();
        List<PointSymbol> points = polyline.getSymbolComponents();
        for (int i = 0; i < points.size(); ++i) {
            Line2D.Double e;
            PointSymbol point = points.get(i);
            if (point.isFiller()) continue;
            Ellipse2D.Double loc = new Ellipse2D.Double(point.getDevicePoint().getX() - 2.0, point.getDevicePoint().getY() - 2.0, 4.0, 4.0);
            g2d.draw(loc);
            if (point.getNature() == SymbolPlugin.SymbolNature.Vertical) {
                e = new Line2D.Double(point.getDevicePoint().getX(), point.getDevicePoint().getY(), point.getDevicePoint().getX() + point.getThickness(), point.getDevicePoint().getY());
                g2d.draw(e);
            }
            if (point.getNature() == SymbolPlugin.SymbolNature.Horizontal) {
                e = new Line2D.Double(point.getDevicePoint().getX(), point.getDevicePoint().getY(), point.getDevicePoint().getX(), point.getDevicePoint().getY() - point.getThickness());
                g2d.draw(e);
            }
            if (i == 0) {
                path.moveTo(point.getDevicePoint().getX(), point.getDevicePoint().getY());
                continue;
            }
            path.lineTo(point.getDevicePoint().getX(), point.getDevicePoint().getY());
        }
        if (path != null) {
            g2d.draw(path);
        }
    }
}

