/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.translate;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.jensoft.core.palette.color.Alpha;
import org.jensoft.core.palette.color.RosePalette;
import org.jensoft.core.plugin.PluginEvent;
import org.jensoft.core.plugin.translate.TranslatePlugin;
import org.jensoft.core.plugin.translate.TranslatePluginEvent;
import org.jensoft.core.plugin.translate.TranslatePluginListener;
import org.jensoft.core.view.View;
import org.jensoft.core.widget.Widget;
import org.jensoft.core.widget.WidgetFolder;

public class TranslateCompassWidget
extends Widget<TranslatePlugin> {
    public static final String translateCompassWidgetID = "@widget/translate/compass";
    private static final int compassSquareSize = 64;
    private CompassGeometry compassWidget;
    private CompassStyle compassStyle = CompassStyle.Merge;
    private String name;
    private Color ringDrawColor = RosePalette.LEMONPEEL;
    private Stroke ringDrawStroke = new BasicStroke(1.5f);
    private Color ringFillColor = new Alpha(RosePalette.COALBLACK, 180);
    private Color ringNeedleDrawColor;
    private Color ringNeedleFillColor;
    private Stroke defaultStroke = new BasicStroke();
    private int averageCounter = 0;
    private int maxAverage = 4;
    private double averageDx = 0.0;
    private double averageDy = 0.0;

    public TranslateCompassWidget() {
        super(translateCompassWidgetID, 64.0, 64.0, 100, 0);
        this.compassWidget = new CompassGeometry(0, 0, 22, 28);
    }

    public TranslateCompassWidget(Color ringDrawColor, Color ringFillColor) {
        super(translateCompassWidgetID, 64.0, 64.0, 100, 0);
        this.compassWidget = new CompassGeometry(0, 0, 26, 32);
        this.ringDrawColor = ringDrawColor;
        this.ringFillColor = ringFillColor;
    }

    public TranslateCompassWidget(double compassSquareSize, int xIndex, int yIndex) {
        super(translateCompassWidgetID, compassSquareSize, compassSquareSize, xIndex, yIndex);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public CompassStyle getCompassStyle() {
        return this.compassStyle;
    }

    public void setCompassStyle(CompassStyle compassStyle) {
        this.compassStyle = compassStyle;
    }

    public Color getRingDrawColor() {
        return this.ringDrawColor;
    }

    public void setRingDrawColor(Color ringDrawColor) {
        this.ringDrawColor = ringDrawColor;
    }

    public Stroke getRingDrawStroke() {
        return this.ringDrawStroke;
    }

    public void setRingDrawStroke(Stroke ringDrawStroke) {
        this.ringDrawStroke = ringDrawStroke;
    }

    public Color getRingFillColor() {
        return this.ringFillColor;
    }

    public void setRingFillColor(Color ringFillColor) {
        this.ringFillColor = ringFillColor;
    }

    public Color getRingNeedleDrawColor() {
        return this.ringNeedleDrawColor;
    }

    public void setRingNeedleDrawColor(Color ringNeedleDrawColor) {
        this.ringNeedleDrawColor = ringNeedleDrawColor;
    }

    public Color getRingNeedleFillColor() {
        return this.ringNeedleFillColor;
    }

    public void setRingNeedleFillColor(Color ringNeedleFillColor) {
        this.ringNeedleFillColor = ringNeedleFillColor;
    }

    @Override
    public void onRegister() {
        ((TranslatePlugin)this.getHost()).addTranslateListener(new TranslatePluginListener(){

            @Override
            public void pluginSelected(PluginEvent<TranslatePlugin> pluginEvent) {
            }

            @Override
            public void pluginUnlockSelected(PluginEvent<TranslatePlugin> pluginEvent) {
            }

            @Override
            public void translated(TranslatePluginEvent pluginEvent) {
                if (TranslateCompassWidget.this.averageCounter < TranslateCompassWidget.this.maxAverage) {
                    TranslateCompassWidget.this.averageCounter++;
                    TranslateCompassWidget.this.averageDx = TranslateCompassWidget.this.averageDx + ((TranslatePlugin)TranslateCompassWidget.this.getHost()).getTranslateDx();
                    TranslateCompassWidget.this.averageDy = TranslateCompassWidget.this.averageDy + ((TranslatePlugin)TranslateCompassWidget.this.getHost()).getTranslateDy();
                } else {
                    ((TranslateCompassWidget)TranslateCompassWidget.this).getCompassGeometry().getNeedle().getNeedleVector().startx = 0.0;
                    ((TranslateCompassWidget)TranslateCompassWidget.this).getCompassGeometry().getNeedle().getNeedleVector().endx = TranslateCompassWidget.this.averageDx / (double)TranslateCompassWidget.this.averageCounter;
                    ((TranslateCompassWidget)TranslateCompassWidget.this).getCompassGeometry().getNeedle().getNeedleVector().starty = 0.0;
                    ((TranslateCompassWidget)TranslateCompassWidget.this).getCompassGeometry().getNeedle().getNeedleVector().endy = TranslateCompassWidget.this.averageDy / (double)TranslateCompassWidget.this.averageCounter;
                    ((TranslatePlugin)TranslateCompassWidget.this.getHost()).getProjection().getView().repaintDevice(TranslateCompassWidget.this.getWidgetFolder().getBounds());
                    TranslateCompassWidget.this.averageCounter = 0;
                    TranslateCompassWidget.this.averageDx = 0.0;
                    TranslateCompassWidget.this.averageDy = 0.0;
                }
            }

            @Override
            public void translateStoped(TranslatePluginEvent pluginEvent) {
            }

            @Override
            public void translateStarted(TranslatePluginEvent pluginEvent) {
            }

            @Override
            public void translateL2RChanged(TranslatePluginEvent pluginEvent) {
            }

            @Override
            public void translateB2TChanged(TranslatePluginEvent pluginEvent) {
            }
        });
    }

    private CompassGeometry getCompassGeometry() {
        return this.compassWidget;
    }

    private void paintTranslateCompass(Graphics2D g2d) {
        WidgetFolder currentFolder = this.getWidgetFolder();
        int tcx = (int)(currentFolder.getX() + currentFolder.getWidth() / 2.0);
        int tcy = (int)(currentFolder.getY() + currentFolder.getHeight() / 2.0);
        this.getCompassGeometry().setCenterX(tcx);
        this.getCompassGeometry().setCenterY(tcy);
        double theta = 0.0;
        double centerX = this.getCompassGeometry().getNeedle().getNeedleVector().startx;
        double centerY = this.getCompassGeometry().getNeedle().getNeedleVector().starty;
        double x = this.getCompassGeometry().getNeedle().getNeedleVector().endx;
        double y = this.getCompassGeometry().getNeedle().getNeedleVector().endy;
        if (x > centerX && y <= centerY) {
            theta = Math.atan(new Double(centerY - y) / new Double(x - centerX));
        } else if (x > centerX && y > centerY) {
            theta = Math.atan(new Double(centerY - y) / new Double(x - centerX)) + Math.PI * 2;
        } else if (x < centerX) {
            theta = Math.atan(new Double(centerY - y) / new Double(x - centerX)) + Math.PI;
        } else if (x == centerX && y < centerY) {
            theta = 1.5707963267948966;
        } else if (x == centerX && y > centerY) {
            theta = 4.71238898038469;
        }
        this.compassWidget.setCenterX(tcx);
        this.compassWidget.setCenterY(tcy);
        this.compassWidget.getNeedle().setTheta(Math.toDegrees(theta));
        this.compassWidget.builCompass();
        Shape baseShape = this.compassWidget.getRing();
        Ellipse2D outerRing = this.compassWidget.getOuterCircle();
        Ellipse2D innerRing = this.compassWidget.getInnerCircle();
        GeneralPath needlePath = this.compassWidget.getNeedle().getNeedlePath();
        g2d.setStroke(this.defaultStroke);
        if (this.compassStyle == CompassStyle.Merge) {
            Area a = new Area(baseShape);
            a.add(new Area(needlePath));
            if (this.ringFillColor != null) {
                g2d.setColor(this.ringFillColor);
                g2d.fill(a);
            }
            if (this.ringDrawColor != null) {
                g2d.setColor(this.ringDrawColor);
                g2d.setStroke(this.ringDrawStroke);
                g2d.draw(a);
            }
        } else {
            if (this.ringFillColor != null) {
                g2d.setColor(this.ringFillColor);
            } else {
                g2d.setColor(((TranslatePlugin)this.getHost()).getThemeColor());
            }
            g2d.fill(baseShape);
            if (this.ringDrawColor != null) {
                g2d.setColor(this.ringDrawColor);
                g2d.setStroke(this.ringDrawStroke);
                g2d.draw(outerRing);
                g2d.draw(innerRing);
            }
            if (this.ringNeedleFillColor != null) {
                g2d.setColor(this.ringNeedleFillColor);
            } else {
                g2d.setColor(((TranslatePlugin)this.getHost()).getThemeColor());
            }
            g2d.fill(needlePath);
            if (this.ringNeedleDrawColor != null) {
                g2d.setColor(this.ringNeedleDrawColor);
                g2d.setStroke(this.ringDrawStroke);
                g2d.draw(needlePath);
            }
        }
    }

    @Override
    protected void paintWidget(View view, Graphics2D g2d) {
        if (((TranslatePlugin)this.getHost()).isLockTranslate()) {
            this.paintTranslateCompass(g2d);
        }
    }

    @Override
    public final boolean isCompatiblePlugin() {
        return this.getHost() != null && this.getHost() instanceof TranslatePlugin;
    }

    class NeedleGeometry {
        private String name;
        private double theta = 0.0;
        private Paint paint = new Color(0, 0, 0, 150);
        private Color colorTheme = Color.WHITE;
        private int alphaProjection = 18;
        private Arc2D needleArc;
        private GeneralPath needlePath;
        private Point2D refPoint;
        private NeedleVector needleVector;

        public NeedleGeometry() {
            this.needleVector = new NeedleVector();
        }

        public NeedleGeometry(int theta) {
            this.theta = theta;
        }

        public NeedleGeometry(int alphaProjection, int theta) {
            this.alphaProjection = alphaProjection;
            this.theta = theta;
        }

        public NeedleVector getNeedleVector() {
            return this.needleVector;
        }

        public void setNeedleVector(NeedleVector needleVector) {
            this.needleVector = needleVector;
        }

        public Point2D getRefPoint() {
            return this.refPoint;
        }

        public void setRefPoint(Point2D refPoint) {
            this.refPoint = refPoint;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean contains(Point2D p2d) {
            return this.needlePath.contains(p2d);
        }

        public double getTheta() {
            return this.theta;
        }

        public void setTheta(double theta) {
            this.theta = theta;
        }

        public Paint getPaint() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }

        public Color getColorTheme() {
            return this.colorTheme;
        }

        public void setColorTheme(Color colorTheme) {
            this.colorTheme = colorTheme;
        }

        public int getAlphaProjection() {
            return this.alphaProjection;
        }

        public void setAlphaProjection(int alphaProjection) {
            this.alphaProjection = alphaProjection;
        }

        public Arc2D getNeedleArc() {
            return this.needleArc;
        }

        public void setNeedleArc(Arc2D needleArc) {
            this.needleArc = needleArc;
        }

        public GeneralPath getNeedlePath() {
            return this.needlePath;
        }

        public void setNeedlePath(GeneralPath needlePath) {
            this.needlePath = needlePath;
        }

        class NeedleVector {
            double startx = 0.0;
            double endx = 0.0;
            double starty = 0.0;
            double endy = 0.0;

            NeedleVector() {
            }
        }
    }

    class CompassGeometry {
        private int centerX;
        private int centerY;
        private int innerRadius;
        private int outerRadius;
        private Paint paint = new Color(0, 0, 0, 40);
        private Color outlineColor = Color.WHITE;
        private Shape ring;
        private int delta1 = 2;
        private int delta2 = 10;
        private NeedleGeometry needle;
        private Ellipse2D innerCircle;
        private Ellipse2D outerCircle;

        public CompassGeometry(int centerX, int centerY, int innerRadius, int outerRadius) {
            this.centerX = centerX;
            this.centerY = centerY;
            this.innerRadius = innerRadius;
            this.outerRadius = outerRadius;
            this.needle = new NeedleGeometry();
        }

        public NeedleGeometry getNeedle() {
            return this.needle;
        }

        public void builCompass() {
            this.innerCircle = new Ellipse2D.Double(this.centerX - this.innerRadius, this.centerY - this.innerRadius, 2 * this.innerRadius, 2 * this.innerRadius);
            this.outerCircle = new Ellipse2D.Double(this.centerX - this.outerRadius, this.centerY - this.outerRadius, 2 * this.outerRadius, 2 * this.outerRadius);
            Area area1 = new Area(this.innerCircle);
            Area area2 = new Area(this.outerCircle);
            area2.subtract(area1);
            this.ring = area2;
            this.buildNeedles();
        }

        private void buildNeedles() {
            double cornerExternalX = this.centerX - (this.innerRadius + this.delta1);
            double cornerExternalY = this.centerY - (this.innerRadius + this.delta1);
            Arc2D.Double needleArc = new Arc2D.Double(cornerExternalX, cornerExternalY, 2 * (this.innerRadius + this.delta1), 2 * (this.innerRadius + this.delta1), this.needle.getTheta() - (double)this.needle.getAlphaProjection(), 2 * this.needle.getAlphaProjection(), 0);
            this.needle.setNeedleArc(needleArc);
            double X2 = (double)(this.outerRadius + this.delta2) * Math.cos(Math.toRadians(this.needle.getTheta()));
            double Y2 = (double)(this.outerRadius + this.delta2) * Math.sin(Math.toRadians(this.needle.getTheta()));
            GeneralPath needlePath = new GeneralPath();
            needlePath.moveTo(needleArc.getStartPoint().getX(), needleArc.getStartPoint().getY());
            needlePath.lineTo(needleArc.getEndPoint().getX(), needleArc.getEndPoint().getY());
            needlePath.lineTo((double)this.centerX + X2, (double)this.centerY - Y2);
            needlePath.closePath();
            this.needle.setNeedlePath(needlePath);
        }

        public int getCenterX() {
            return this.centerX;
        }

        public void setCenterX(int centerX) {
            this.centerX = centerX;
        }

        public int getCenterY() {
            return this.centerY;
        }

        public void setCenterY(int centerY) {
            this.centerY = centerY;
        }

        public int getInnerRadius() {
            return this.innerRadius;
        }

        public void setInnerRadius(int innerRadius) {
            this.innerRadius = innerRadius;
        }

        public int getOuterRadius() {
            return this.outerRadius;
        }

        public void setOuterRadius(int outerRadius) {
            this.outerRadius = outerRadius;
        }

        public Shape getRing() {
            return this.ring;
        }

        public void setRing(Shape ring) {
            this.ring = ring;
        }

        public Ellipse2D getInnerCircle() {
            return this.innerCircle;
        }

        public void setInnerCircle(Ellipse2D innerCircle) {
            this.innerCircle = innerCircle;
        }

        public Ellipse2D getOuterCircle() {
            return this.outerCircle;
        }

        public void setOuterCircle(Ellipse2D outerCircle) {
            this.outerCircle = outerCircle;
        }

        public Paint getPaint() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }

        public Color getOutlineColor() {
            return this.outlineColor;
        }

        public void setOutlineColor(Color outlineColor) {
            this.outlineColor = outlineColor;
        }
    }

    public static enum CompassStyle {
        Merge,
        Separate;

    }
}

