/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.translate;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.jensoft.core.graphics.Antialiasing;
import org.jensoft.core.graphics.TextAntialiasing;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.translate.TranslatePluginEvent;
import org.jensoft.core.plugin.translate.TranslatePluginListener;
import org.jensoft.core.plugin.translate.TranslateSynchronizer;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.projection.ProjectionBound;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class TranslatePlugin
extends AbstractPlugin
implements AbstractPlugin.OnPressListener,
AbstractPlugin.OnReleaseListener,
AbstractPlugin.OnDragListener {
    private boolean lockTranslate = false;
    private boolean passiveTranslate = false;
    private int translateStartX;
    private int translateStartY;
    private int translateCurentX;
    private int translateCurentY;
    private double translateDx;
    private double translateDy;
    public boolean lockL2R = true;
    public boolean lockB2T = true;
    private SequencePlayer sequencePlayer;
    private List<TimingBoundFrame> boundHistory;
    private EventListenerList translateListenerList;
    private DynamicSmoothReleaseAnimation dynamicAnimator;
    private List<DynamicItem> cinematiques;
    boolean dynamicEffect = true;
    private long dynamicSequenceTime = 0L;
    private SmoothShift smoothShift;
    private boolean shifting = false;

    public TranslatePlugin() {
        this.setSelectable(true);
        this.setName(TranslatePlugin.class.getCanonicalName());
        this.translateListenerList = new EventListenerList();
        this.boundHistory = new ArrayList<TimingBoundFrame>();
        this.setOnPressListener(this);
        this.setOnReleaseListener(this);
        this.setOnDragListener(this);
        this.setAntialiasing(Antialiasing.On);
        this.setTextAntialising(TextAntialiasing.On);
        this.setPriority(100);
    }

    public boolean isDynamicEffect() {
        return this.dynamicEffect;
    }

    public void setDynamicEffect(boolean dynamicEffect) {
        this.dynamicEffect = dynamicEffect;
    }

    public boolean isLockL2R() {
        return this.lockL2R;
    }

    public void lockL2R() {
        if (!this.isLockL2R()) {
            this.lockL2R = true;
            this.fireTranslateL2RChanged();
        }
    }

    public void unlockL2R() {
        if (this.isLockL2R()) {
            this.lockL2R = false;
            this.fireTranslateL2RChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTranslateL2RChanged() {
        Object[] listeners;
        Object[] objectArray = listeners = this.translateListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != TranslatePluginListener.class) continue;
                ((TranslatePluginListener)listeners[i + 1]).translateL2RChanged(new TranslatePluginEvent(this));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean isLockB2T() {
        return this.lockB2T;
    }

    public void lockB2T() {
        if (!this.isLockB2T()) {
            this.lockB2T = true;
            this.fireTranslateB2TChanged();
        }
    }

    public void unlockB2T() {
        if (this.isLockB2T()) {
            this.lockB2T = false;
            this.fireTranslateB2TChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTranslateB2TChanged() {
        Object[] listeners;
        Object[] objectArray = listeners = this.translateListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != TranslatePluginListener.class) continue;
                ((TranslatePluginListener)listeners[i + 1]).translateB2TChanged(new TranslatePluginEvent(this));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static TranslateSynchronizer createSynchronizer(TranslatePlugin ... translates) {
        TranslateSynchronizer synchronizer = new TranslateSynchronizer(translates);
        return synchronizer;
    }

    public static TranslateSynchronizer createSynchronizer(List<TranslatePlugin> translates) {
        TranslateSynchronizer synchronizer = new TranslateSynchronizer(translates);
        return synchronizer;
    }

    public void startReplay() {
        this.stopReplay();
        this.sequencePlayer = new SequencePlayer();
        this.sequencePlayer.start();
    }

    public void stopReplay() {
        if (this.sequencePlayer != null) {
            this.sequencePlayer.interrupt();
        }
    }

    public TranslateLockUnlockAction getTranslateLockUnlockAction() {
        return new TranslateLockUnlockAction();
    }

    public TranslateL2RAction getTranslateL2RAction() {
        return new TranslateL2RAction();
    }

    public TranslateB2TAction getTranslateB2TAction() {
        return new TranslateB2TAction();
    }

    public void addTranslateListener(TranslatePluginListener listener) {
        this.translateListenerList.add(TranslatePluginListener.class, listener);
        this.addPluginListener(listener);
    }

    public void removeTranslateListener(TranslatePluginListener listener) {
        this.translateListenerList.remove(TranslatePluginListener.class, listener);
        this.removePluginListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTranslateStarted() {
        Object[] listeners;
        Object[] objectArray = listeners = this.translateListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != TranslatePluginListener.class) continue;
                ((TranslatePluginListener)listeners[i + 1]).translateStarted(new TranslatePluginEvent(this));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTranslateStopped() {
        Object[] listeners;
        Object[] objectArray = listeners = this.translateListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != TranslatePluginListener.class) continue;
                ((TranslatePluginListener)listeners[i + 1]).translateStoped(new TranslatePluginEvent(this));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTranslate() {
        Object[] listeners;
        Object[] objectArray = listeners = this.translateListenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != TranslatePluginListener.class) continue;
                ((TranslatePluginListener)listeners[i + 1]).translated(new TranslatePluginEvent(this));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void startTranslate(Point2D translateStart) {
        if (this.dynamicAnimator != null && this.dynamicAnimator.isAlive()) {
            this.dynamicAnimator.interrupt();
        }
        this.lockTranslate();
        this.translateStartX = (int)translateStart.getX();
        this.translateStartY = (int)translateStart.getY();
        this.cinematiques = new ArrayList<DynamicItem>();
        this.boundHistory.clear();
    }

    public boolean isLockTranslate() {
        return this.lockTranslate;
    }

    public void unlockTranslate() {
        this.lockTranslate = false;
    }

    public void lockTranslate() {
        this.lockTranslate = true;
    }

    public boolean isPassiveTranslate() {
        return this.passiveTranslate;
    }

    public void passiveTranslate() {
        this.passiveTranslate = true;
    }

    public void unPassiveTranslate() {
        this.passiveTranslate = false;
    }

    private void registerTimingBoundSequence() {
        Projection w2d = this.getProjection().getView().getActiveProjection();
        TimingBoundFrame translateProjectionBound = new TimingBoundFrame(w2d.getMinX(), w2d.getMaxX(), w2d.getMinY(), w2d.getMaxY());
        translateProjectionBound.setDx(this.translateDx);
        translateProjectionBound.setDy(this.translateDy);
        int len = this.boundHistory.size();
        if (len > 0) {
            long time = System.currentTimeMillis() - this.dynamicSequenceTime;
            TimingBoundFrame previousTWB = this.boundHistory.get(len - 1);
            previousTWB.setBoundDurationMillis(time);
        }
        if (len > 1000) {
            this.boundHistory.clear();
        }
        this.dynamicSequenceTime = System.currentTimeMillis();
        this.boundHistory.add(translateProjectionBound);
    }

    public void processTranslate(double deltaDeviceX, double deltaDeviceY) {
        this.translateDx = deltaDeviceX;
        this.translateDy = deltaDeviceY;
        Projection w2d = this.getProjection();
        if (w2d == null) {
            return;
        }
        int w = this.getProjection().getView().getDevice2D().getDeviceWidth();
        int h = this.getProjection().getView().getDevice2D().getDeviceHeight();
        Point2D.Double pMinXMinYDevice = new Point2D.Double(-deltaDeviceX, (double)h - deltaDeviceY);
        Point2D.Double pMaxXMaxYDevice = new Point2D.Double((double)w - deltaDeviceX, -deltaDeviceY);
        Point2D pMinXMinYUser = w2d.pixelToUser(pMinXMinYDevice);
        Point2D pMaxXMaxYUser = w2d.pixelToUser(pMaxXMaxYDevice);
        if (w2d instanceof Projection.Linear) {
            Projection.Linear wl = (Projection.Linear)w2d;
            wl.bound(pMinXMinYUser.getX(), pMaxXMaxYUser.getX(), pMinXMinYUser.getY(), pMaxXMaxYUser.getY());
        }
    }

    @Override
    public void onDrag(MouseEvent e) {
        if (!this.isLockSelected()) {
            return;
        }
        if (this.isLockPassive()) {
            return;
        }
        if (!this.isLockTranslate()) {
            return;
        }
        this.boundTranslate(e.getX(), e.getY());
        this.fireTranslate();
        this.translateStartX = this.translateCurentX;
        this.translateStartY = this.translateCurentY;
    }

    private void boundTranslate(int deviceCurentX, int deviceCurentY) {
        this.translateCurentX = deviceCurentX;
        this.translateCurentY = deviceCurentY;
        Point2D.Double p2d = new Point2D.Double(deviceCurentX, deviceCurentY);
        DynamicItem tc = new DynamicItem(p2d, System.currentTimeMillis());
        tc.setParent("DRAGUED");
        this.cinematiques.add(tc);
        double deltaDeviceX = this.translateCurentX - this.translateStartX;
        double deltaDeviceY = this.translateCurentY - this.translateStartY;
        if (!this.lockB2T) {
            deltaDeviceY = 0.0;
        }
        if (!this.lockL2R) {
            deltaDeviceX = 0.0;
        }
        this.processTranslate(deltaDeviceX, deltaDeviceY);
        this.registerTimingBoundSequence();
    }

    @Override
    public void onRelease(MouseEvent e) {
        if (!this.isLockSelected()) {
            return;
        }
        if (this.isLockPassive()) {
            return;
        }
        if (!this.isLockTranslate()) {
            return;
        }
        if (!this.isShifting()) {
            this.stopTranslate(e.getX(), e.getY());
            this.fireTranslateStopped();
            this.repaintDevice();
        }
    }

    public void stopTranslate(int endDeviceX, int endDeviceY) {
        this.translateCurentX = endDeviceX;
        this.translateCurentY = endDeviceY;
        Point2D.Double p2d = new Point2D.Double(endDeviceX, endDeviceY);
        DynamicItem tc = new DynamicItem(p2d, System.currentTimeMillis());
        tc.setParent("RELEASED");
        this.cinematiques.add(tc);
        if (this.dynamicEffect) {
            this.dynamicAnimator = new DynamicSmoothReleaseAnimation(this.getName());
            this.dynamicAnimator.start();
        } else {
            this.unlockTranslate();
            this.unPassiveTranslate();
        }
    }

    @Override
    public void onPress(MouseEvent e) {
        if (!this.isLockSelected()) {
            return;
        }
        if (this.isLockPassive()) {
            return;
        }
        if (e.getModifiers() != 16) {
            return;
        }
        if (!this.isPassiveTranslate()) {
            this.startTranslate(new Point2D.Double(e.getX(), e.getY()));
            this.fireTranslateStarted();
        }
    }

    public boolean isShifting() {
        return this.shifting;
    }

    private void setShifting(boolean shifting) {
        this.shifting = shifting;
    }

    public void shift(ShiftDirection shiftDirection) {
        if (!this.isShifting()) {
            new SmoothShift(shiftDirection).start();
        }
    }

    public void shift(ShiftDirection shiftDirection, int factor) {
        if (this.isShifting()) {
            this.smoothShift.interrupt();
            try {
                this.smoothShift.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.isShifting()) {
            this.smoothShift = new SmoothShift(shiftDirection, factor);
            this.smoothShift.start();
        }
    }

    public void joinShifting() {
        if (this.smoothShift != null && this.smoothShift.isAlive()) {
            try {
                this.smoothShift.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void interruptShifting() {
        if (this.smoothShift != null && this.smoothShift.isAlive()) {
            try {
                this.smoothShift.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void shift(ShiftDirection shiftDirection, ShiftVelocity velocity) {
        if (this.isShifting()) {
            this.smoothShift.interrupt();
            try {
                this.smoothShift.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.isShifting()) {
            this.smoothShift = new SmoothShift(shiftDirection, velocity);
            this.smoothShift.start();
        }
    }

    @Override
    protected void paintPlugin(View v2d, Graphics2D g2d, ViewPart viewPart) {
    }

    public int getTranslateStartDeviceX() {
        return this.translateStartX;
    }

    public int getTranslateStartDeviceY() {
        return this.translateStartY;
    }

    public Point2D getTranslateStartDevicePoint() {
        return new Point2D.Double(this.translateStartX, this.translateStartY);
    }

    public Point2D getTranslateStartUserPoint() {
        return this.getProjection().pixelToUser(this.getTranslateStartDevicePoint());
    }

    public double getTranslateStartUserX() {
        return this.getTranslateStartUserPoint().getX();
    }

    public double getTranslateStartUserY() {
        return this.getTranslateStartUserPoint().getY();
    }

    public int getTranslateCurentDeviceX() {
        return this.translateCurentX;
    }

    public int getTranslateCurentDeviceY() {
        return this.translateCurentY;
    }

    public Point2D getTranslateCurrentDevicePoint() {
        return new Point2D.Double(this.translateCurentX, this.translateCurentY);
    }

    public Point2D getTranslateCurrentUserPoint() {
        return this.getProjection().pixelToUser(this.getTranslateCurrentDevicePoint());
    }

    public double getTranslateCurrentUserX() {
        return this.getTranslateCurrentUserPoint().getX();
    }

    public double getTranslateCurrentUserY() {
        return this.getTranslateCurrentUserPoint().getY();
    }

    public double getTranslateDx() {
        return this.translateDx;
    }

    public double getTranslateDy() {
        return this.translateDy;
    }

    class SmoothShift
    extends Thread {
        private ShiftDirection direction;
        private int factor = 5;
        private ShiftVelocity velocity = ShiftVelocity.Slow;

        public SmoothShift(ShiftDirection direction) {
            this.direction = direction;
        }

        public SmoothShift(ShiftDirection direction, int factor) {
            this.direction = direction;
            this.factor = factor;
        }

        public SmoothShift(ShiftDirection direction, ShiftVelocity velocity) {
            this.direction = direction;
            this.velocity = velocity;
        }

        @Override
        public void run() {
            try {
                TranslatePlugin.this.setShifting(true);
                TranslatePlugin.this.startTranslate(new Point2D.Double(0.0, 0.0));
                TranslatePlugin.this.fireTranslateStarted();
                int sleep = this.velocity.getVelocity();
                int fragment = 20;
                int deltaY = TranslatePlugin.this.getProjection().getView().getDevice2D().getDeviceHeight() / fragment;
                int deltaX = TranslatePlugin.this.getProjection().getView().getDevice2D().getDeviceWidth() / fragment;
                if (this.direction == ShiftDirection.North) {
                    for (int i = this.factor; i > 0; --i) {
                        TranslatePlugin.this.processTranslate(0.0, deltaY);
                        TranslatePlugin.this.fireTranslate();
                        TranslatePlugin.this.getProjection().getView().repaint();
                        Thread.sleep(sleep);
                    }
                    this.interrupt();
                } else if (this.direction == ShiftDirection.South) {
                    for (int i = this.factor; i > 0; --i) {
                        TranslatePlugin.this.processTranslate(0.0, -deltaY);
                        TranslatePlugin.this.fireTranslate();
                        TranslatePlugin.this.getProjection().getView().repaint();
                        Thread.sleep(sleep);
                    }
                    this.interrupt();
                } else if (this.direction == ShiftDirection.West) {
                    for (int i = this.factor; i > 0; --i) {
                        TranslatePlugin.this.processTranslate(deltaX, 0.0);
                        TranslatePlugin.this.fireTranslate();
                        TranslatePlugin.this.getProjection().getView().repaint();
                        Thread.sleep(sleep);
                    }
                    this.interrupt();
                } else if (this.direction == ShiftDirection.East) {
                    for (int i = this.factor; i > 1; --i) {
                        TranslatePlugin.this.processTranslate(-deltaX, 0.0);
                        TranslatePlugin.this.fireTranslate();
                        TranslatePlugin.this.getProjection().getView().repaint();
                        Thread.sleep(sleep);
                    }
                    this.interrupt();
                }
                TranslatePlugin.this.setShifting(false);
                TranslatePlugin.this.stopTranslate(0, 0);
                TranslatePlugin.this.fireTranslateStopped();
                TranslatePlugin.this.getProjection().getView().repaint();
            }
            catch (InterruptedException e) {
                TranslatePlugin.this.setShifting(false);
                TranslatePlugin.this.stopTranslate(0, 0);
                TranslatePlugin.this.fireTranslateStopped();
                Thread.currentThread().interrupt();
            }
        }
    }

    class DynamicItem {
        private Point2D point;
        private long timeMillis;
        private String parent = "na";

        public DynamicItem(Point2D point, long timeMillis) {
            this.point = point;
            this.timeMillis = timeMillis;
        }

        public Point2D getPoint() {
            return this.point;
        }

        public void setPoint(Point2D point) {
            this.point = point;
        }

        public long getTimeMillis() {
            return this.timeMillis;
        }

        public void setTimeMillis(long timeMillis) {
            this.timeMillis = timeMillis;
        }

        public String getParent() {
            return this.parent;
        }

        public void setParent(String parent) {
            this.parent = parent;
        }

        public String toString() {
            return "Item :Parent " + this.parent + " " + this.point + " Time :" + this.timeMillis;
        }
    }

    class DynamicSmoothReleaseAnimation
    extends Thread {
        public DynamicSmoothReleaseAnimation(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (TranslatePlugin.this.cinematiques.size() < 4) {
                    return;
                }
                DynamicItem itemReleased = (DynamicItem)TranslatePlugin.this.cinematiques.get(TranslatePlugin.this.cinematiques.size() - 1);
                DynamicItem itemLastDragued = (DynamicItem)TranslatePlugin.this.cinematiques.get(TranslatePlugin.this.cinematiques.size() - 2);
                if (itemReleased.timeMillis > itemLastDragued.timeMillis + 2L) {
                    throw new InterruptedException();
                }
                int echantillon = 3;
                DynamicItem itemEnd = (DynamicItem)TranslatePlugin.this.cinematiques.get(TranslatePlugin.this.cinematiques.size() - 1);
                DynamicItem itemStart = (DynamicItem)TranslatePlugin.this.cinematiques.get(TranslatePlugin.this.cinematiques.size() - 1 - echantillon);
                double startX = itemStart.point.getX();
                double endX = itemEnd.point.getX();
                double startY = itemStart.point.getY();
                double endY = itemEnd.point.getY();
                double deltaX = endX - startX;
                double deltaY = endY - startY;
                int delatTimeMillis = (int)(itemEnd.timeMillis - itemStart.timeMillis);
                int partNumber = 10;
                double deltaXPart = deltaX / (double)partNumber;
                double deltaYPart = deltaY / (double)partNumber;
                for (int i = 0; i < partNumber; ++i) {
                    double deltaDeviceX = deltaX - deltaXPart * (double)i;
                    double deltaDeviceY = deltaY - deltaYPart * (double)i;
                    if (!TranslatePlugin.this.lockB2T) {
                        deltaDeviceY = 0.0;
                    }
                    if (!TranslatePlugin.this.lockL2R) {
                        deltaDeviceX = 0.0;
                    }
                    TranslatePlugin.this.processTranslate(deltaDeviceX, deltaDeviceY);
                    TranslatePlugin.this.fireTranslate();
                    TranslatePlugin.this.translateStartX = TranslatePlugin.this.translateCurentX;
                    TranslatePlugin.this.translateStartY = TranslatePlugin.this.translateCurentY;
                    Thread.sleep(delatTimeMillis);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                TranslatePlugin.this.unlockTranslate();
                TranslatePlugin.this.unPassiveTranslate();
                TranslatePlugin.this.getProjection().getView().repaintDevice();
                TranslatePlugin.this.cinematiques.clear();
            }
        }
    }

    class TranslateB2TAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TranslatePlugin.this.isLockB2T()) {
                        TranslatePlugin.this.unlockB2T();
                    } else if (!TranslatePlugin.this.isLockB2T()) {
                        TranslatePlugin.this.lockB2T();
                    }
                }
            });
        }
    }

    class TranslateL2RAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TranslatePlugin.this.isLockL2R()) {
                        TranslatePlugin.this.unlockL2R();
                    } else if (!TranslatePlugin.this.isLockL2R()) {
                        TranslatePlugin.this.lockL2R();
                    }
                }
            });
        }
    }

    class TranslateLockUnlockAction
    implements ActionListener {
        TranslateLockUnlockAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TranslatePlugin.this.isLockSelected()) {
                        TranslatePlugin.this.unlockSelected();
                    } else {
                        TranslatePlugin.this.lockSelected();
                    }
                }
            });
        }
    }

    class TimingBoundFrame
    extends ProjectionBound {
        private long boundDurationMillis;
        private double dx;
        private double dy;

        public TimingBoundFrame(double minX, double maxX, double minY, double maxY) {
            super(minX, maxX, minY, maxY);
            this.boundDurationMillis = 0L;
        }

        public double getDx() {
            return this.dx;
        }

        public void setDx(double dx) {
            this.dx = dx;
        }

        public double getDy() {
            return this.dy;
        }

        public void setDy(double dy) {
            this.dy = dy;
        }

        public long getBoundDurationMillis() {
            return this.boundDurationMillis;
        }

        public void setBoundDurationMillis(long boundDurationMillis) {
            this.boundDurationMillis = boundDurationMillis;
        }
    }

    public class SequencePlayer
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Projection w2d;
                TranslatePlugin.this.fireTranslateStarted();
                if (TranslatePlugin.this.boundHistory.size() > 3 && (w2d = TranslatePlugin.this.getProjection().getView().getActiveProjection()) instanceof Projection.Linear) {
                    TimingBoundFrame twb0 = (TimingBoundFrame)TranslatePlugin.this.boundHistory.get(0);
                    Projection.Linear wl = (Projection.Linear)w2d;
                    wl.bound(twb0.getMinX(), twb0.getMaxX(), twb0.getMinY(), twb0.getMaxY());
                    for (TimingBoundFrame twb : TranslatePlugin.this.boundHistory) {
                        TranslatePlugin.this.processTranslate(twb.getDx(), twb.getDy());
                        TranslatePlugin.this.fireTranslate();
                        TranslatePlugin.this.getProjection().getView().getDevice2D().repaintDevice();
                        Thread.sleep(twb.getBoundDurationMillis());
                    }
                }
                TranslatePlugin.this.fireTranslateStopped();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                TranslatePlugin.this.fireTranslateStopped();
            }
        }
    }

    public static enum ShiftVelocity {
        VerySlow(200),
        Slow(90),
        Default(40),
        Fast(20),
        VeryFast(5);

        private int velocity;

        private ShiftVelocity(int velocity) {
            this.velocity = velocity;
        }

        public int getVelocity() {
            return this.velocity;
        }
    }

    public static enum ShiftDirection {
        North,
        South,
        West,
        East;

    }
}

