/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.translate;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.PluginEvent;
import org.jensoft.core.plugin.translate.TranslatePlugin;
import org.jensoft.core.plugin.translate.TranslatePluginEvent;
import org.jensoft.core.plugin.translate.TranslatePluginListener;
import org.jensoft.core.projection.Projection;

public class TranslateSynchronizer
implements TranslatePluginListener {
    private List<TranslatePlugin> translateList;
    private boolean dispathingEvent = false;

    public TranslateSynchronizer(TranslatePlugin ... translates) {
        if (!this.dispathingEvent) {
            this.dispathingEvent = true;
            this.translateList = new ArrayList<TranslatePlugin>();
            for (int i = 0; i < translates.length; ++i) {
                TranslatePlugin translatePlugin = translates[i];
                translatePlugin.addTranslateListener(this);
                translatePlugin.addPluginListener(this);
                this.translateList.add(translatePlugin);
            }
            this.dispathingEvent = false;
        }
    }

    public TranslateSynchronizer(List<TranslatePlugin> translates) {
        if (!this.dispathingEvent) {
            this.dispathingEvent = true;
            this.translateList = new ArrayList<TranslatePlugin>();
            for (int i = 0; i < translates.size(); ++i) {
                TranslatePlugin translatePlugin = translates.get(i);
                translatePlugin.addTranslateListener(this);
                translatePlugin.addPluginListener(this);
                this.translateList.add(translatePlugin);
            }
            this.dispathingEvent = false;
        }
    }

    @Override
    public void pluginSelected(PluginEvent<TranslatePlugin> pluginEvent) {
        if (!this.dispathingEvent) {
            this.dispathingEvent = true;
            TranslatePlugin sourceTranslatePlugin = (TranslatePlugin)pluginEvent.getSource();
            for (TranslatePlugin targetTranslatePlugin : this.translateList) {
                if (targetTranslatePlugin.equals(sourceTranslatePlugin)) continue;
                targetTranslatePlugin.lockSelected();
            }
            this.dispathingEvent = false;
        }
    }

    @Override
    public void pluginUnlockSelected(PluginEvent<TranslatePlugin> pluginEvent) {
        if (!this.dispathingEvent) {
            this.dispathingEvent = true;
            TranslatePlugin sourceTranslatePlugin = (TranslatePlugin)pluginEvent.getSource();
            for (TranslatePlugin targetTranslatePlugin : this.translateList) {
                if (targetTranslatePlugin.equals(sourceTranslatePlugin)) continue;
                targetTranslatePlugin.unlockSelected();
            }
            this.dispathingEvent = false;
        }
    }

    @Override
    public void translateL2RChanged(TranslatePluginEvent pluginEvent) {
    }

    @Override
    public void translateB2TChanged(TranslatePluginEvent pluginEvent) {
    }

    @Override
    public void translateStarted(TranslatePluginEvent pluginEvent) {
        if (!this.dispathingEvent) {
            this.dispathingEvent = true;
            TranslatePlugin sourceTranslate = (TranslatePlugin)pluginEvent.getSource();
            for (TranslatePlugin tp : this.translateList) {
                if (tp.equals(sourceTranslate)) continue;
                Point2D deviceStartDevice = sourceTranslate.getTranslateStartDevicePoint();
                tp.startTranslate(new Point2D.Double((int)deviceStartDevice.getX(), (int)deviceStartDevice.getY()));
                tp.fireTranslateStarted();
            }
            this.dispathingEvent = false;
        }
    }

    @Override
    public void translated(TranslatePluginEvent pluginEvent) {
        if (!this.dispathingEvent) {
            this.dispathingEvent = true;
            TranslatePlugin sourceTranslate = (TranslatePlugin)pluginEvent.getSource();
            for (TranslatePlugin tp : this.translateList) {
                if (tp.equals(sourceTranslate)) continue;
                tp.processTranslate(sourceTranslate.getTranslateDx(), sourceTranslate.getTranslateDy());
                tp.fireTranslate();
            }
            sourceTranslate.getProjection().getDevice2D().repaintDevice();
            this.dispathingEvent = false;
        }
    }

    @Override
    public void translateStoped(TranslatePluginEvent pluginEvent) {
        if (!this.dispathingEvent) {
            this.dispathingEvent = true;
            TranslatePlugin sourceTranslate = (TranslatePlugin)pluginEvent.getSource();
            for (TranslatePlugin tp : this.translateList) {
                if (tp.equals(sourceTranslate)) continue;
                Projection w2d = tp.getProjection();
                Point2D deviceCurentDevice = sourceTranslate.getTranslateCurrentDevicePoint();
                tp.stopTranslate((int)deviceCurentDevice.getX(), (int)deviceCurentDevice.getY());
                w2d.getDevice2D().repaintDevice();
                tp.fireTranslateStopped();
            }
            this.dispathingEvent = false;
        }
    }
}

