/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.zoom.box;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.List;
import org.jensoft.core.palette.color.Alpha;
import org.jensoft.core.palette.color.RosePalette;
import org.jensoft.core.plugin.PluginEvent;
import org.jensoft.core.plugin.donut2d.Donut2D;
import org.jensoft.core.plugin.donut2d.Donut2DSlice;
import org.jensoft.core.plugin.zoom.box.ZoomBoxEvent;
import org.jensoft.core.plugin.zoom.box.ZoomBoxListener;
import org.jensoft.core.plugin.zoom.box.ZoomBoxPlugin;
import org.jensoft.core.view.View;
import org.jensoft.core.widget.Widget;
import org.jensoft.core.widget.WidgetFolder;

public class ZoomBoxDonutWidget
extends Widget<ZoomBoxPlugin> {
    public static final String ID = "@widget/donutzoombox";
    private static final int RADIUS = 32;
    private Donut2D donut2D;
    private GeneralPath playPath;
    private boolean playRollover = false;
    private Color fillColor = new Alpha(Color.BLACK, 140);
    private Color drawColor = new Alpha(RosePalette.EMERALD, 255);
    private boolean shiftEffect = true;
    private ShiftWidget shiftWidget;

    public ZoomBoxDonutWidget() {
        super(ID, 64.0, 64.0, 100, 100);
        this.donut2D = new Donut2D();
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public Color getDrawColor() {
        return this.drawColor;
    }

    public void setDrawColor(Color drawColor) {
        this.drawColor = drawColor;
    }

    public boolean isShiftEffect() {
        return this.shiftEffect;
    }

    public void setShiftEffect(boolean shiftEffect) {
        this.shiftEffect = shiftEffect;
    }

    @Override
    public void onRegister() {
        ((ZoomBoxPlugin)this.getHost()).addZoomBoxListener(new ZoomBoxListener(){

            @Override
            public void pluginSelected(PluginEvent<ZoomBoxPlugin> pluginEvent) {
            }

            @Override
            public void pluginUnlockSelected(PluginEvent<ZoomBoxPlugin> pluginEvent) {
            }

            @Override
            public void zoomIn(ZoomBoxEvent pluginEvent) {
                if (ZoomBoxDonutWidget.this.shiftWidget != null && ZoomBoxDonutWidget.this.shiftWidget.isAlive()) {
                    ZoomBoxDonutWidget.this.shiftWidget.interrupt();
                }
                ZoomBoxPlugin zoomPlugin = (ZoomBoxPlugin)ZoomBoxDonutWidget.this.getHost();
                List<ZoomBoxPlugin.BoundBox> boxes = zoomPlugin.getZoomHistory();
                for (ZoomBoxPlugin.BoundBox boundBox : boxes) {
                    if (ZoomBoxDonutWidget.this.getDonutBoundBoxSection(boundBox) != null) continue;
                    ZoomBoxPlugin zoomBox = (ZoomBoxPlugin)ZoomBoxDonutWidget.this.getHost();
                    final DonutBoundBoxSection ds = new DonutBoundBoxSection(boundBox.toString(), zoomBox.getThemeColor());
                    ds.setBoundBox(boundBox);
                    ds.setValue(1.0);
                    ds.setDivergence(50.0);
                    ZoomBoxDonutWidget.this.donut2D.addSlice(ds);
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            try {
                                for (int i = 50; i >= 0; i -= 3) {
                                    ds.setDivergence(i);
                                    ((ZoomBoxPlugin)ZoomBoxDonutWidget.this.getHost()).repaintDevice();
                                    Thread.sleep(10L);
                                }
                                ds.setDivergence(0.0);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    };
                    t.start();
                }
            }

            @Override
            public void zoomOut(ZoomBoxEvent pluginEvent) {
                if (ZoomBoxDonutWidget.this.shiftWidget != null && ZoomBoxDonutWidget.this.shiftWidget.isAlive()) {
                    ZoomBoxDonutWidget.this.shiftWidget.interrupt();
                }
            }

            @Override
            public void zoomClearHistory(ZoomBoxEvent pluginEvent) {
                ZoomBoxDonutWidget.this.donut2D.clearSlices();
            }

            @Override
            public void zoomStart(ZoomBoxEvent pluginEvent) {
                if (ZoomBoxDonutWidget.this.shiftWidget != null && ZoomBoxDonutWidget.this.shiftWidget.isAlive()) {
                    ZoomBoxDonutWidget.this.shiftWidget.interrupt();
                }
                ZoomBoxDonutWidget.this.shiftWidget = new ShiftWidget();
                ZoomBoxDonutWidget.this.shiftWidget.start();
            }

            @Override
            public void zoomHistory(ZoomBoxEvent pluginEvent) {
                if (ZoomBoxDonutWidget.this.shiftWidget != null && ZoomBoxDonutWidget.this.shiftWidget.isAlive()) {
                    ZoomBoxDonutWidget.this.shiftWidget.interrupt();
                }
            }

            @Override
            public void zoomBounded(ZoomBoxEvent pluginEvent) {
            }
        });
    }

    @Override
    public final boolean isCompatiblePlugin() {
        return this.getHost() != null && this.getHost() instanceof ZoomBoxPlugin;
    }

    @Override
    public void interceptMove(int x, int y) {
        if (this.getWidgetFolder() == null) {
            return;
        }
        if (!this.getWidgetFolder().getBounds2D().contains(x, y)) {
            return;
        }
        if (((ZoomBoxPlugin)this.getHost()).isSequencePlaying()) {
            return;
        }
        if (this.getWidgetFolder().getBounds2D().contains(new Point2D.Double(x, y))) {
            ((ZoomBoxPlugin)this.getHost()).lockPassive();
        } else {
            ((ZoomBoxPlugin)this.getHost()).unlockPassive();
        }
        List<Donut2DSlice> sections = this.donut2D.getSlices();
        for (Donut2DSlice donut2dSection : sections) {
            if (donut2dSection.contains(new Point2D.Double(x, y))) {
                donut2dSection.lockRollover();
                this.repaintWidget();
                continue;
            }
            if (!donut2dSection.isLockRollover()) continue;
            donut2dSection.unlockRollover();
            this.repaintWidget();
        }
        if (this.playPath != null && this.playPath.contains(new Point2D.Double(x, y))) {
            this.playRollover = true;
            this.repaintWidget();
        } else if (this.playRollover) {
            this.playRollover = false;
            this.repaintWidget();
        }
    }

    @Override
    public void interceptPress(int x, int y) {
        if (((ZoomBoxPlugin)this.getHost()).isSequencePlaying()) {
            return;
        }
        if (this.getWidgetFolder().getBounds2D().contains(new Point2D.Double(x, y))) {
            ((ZoomBoxPlugin)this.getHost()).lockPassive();
        } else {
            ((ZoomBoxPlugin)this.getHost()).unlockPassive();
        }
        List<Donut2DSlice> sections = this.donut2D.getSlices();
        for (Donut2DSlice donut2dSection : sections) {
            if (!donut2dSection.contains(new Point2D.Double(x, y))) continue;
            DonutBoundBoxSection dbbs = (DonutBoundBoxSection)donut2dSection;
            ZoomBoxPlugin.BoundBox boundBox = dbbs.getBoundBox();
            int index = ((ZoomBoxPlugin)this.getHost()).getHistoryIndex(boundBox);
            ((ZoomBoxPlugin)this.getHost()).processZoomHistory(index);
            ((ZoomBoxPlugin)this.getHost()).fireZoomHistory();
        }
        if (this.playPath != null && this.playPath.contains(new Point2D.Double(x, y))) {
            ((ZoomBoxPlugin)this.getHost()).playCurrentSequence(new DonutPlayerCallback());
        }
    }

    private void unlockAllSection() {
        List<Donut2DSlice> dss = this.donut2D.getSlices();
        for (Donut2DSlice donut2dSection : dss) {
            DonutBoundBoxSection dbbs = (DonutBoundBoxSection)donut2dSection;
            dbbs.unlockRollover();
        }
    }

    public DonutBoundBoxSection getDonutBoundBoxSection(ZoomBoxPlugin.BoundBox boundBox) {
        List<Donut2DSlice> dss = this.donut2D.getSlices();
        for (Donut2DSlice donut2dSection : dss) {
            DonutBoundBoxSection dbbs = (DonutBoundBoxSection)donut2dSection;
            if (!dbbs.getBoundBox().equals(boundBox)) continue;
            return dbbs;
        }
        return null;
    }

    @Override
    protected void paintWidget(View v2d, Graphics2D g2d) {
        if (!((ZoomBoxPlugin)this.getHost()).isLockSelected()) {
            return;
        }
        WidgetFolder currentFolder = this.getWidgetFolder();
        double centerX = currentFolder.getX() + 32.0;
        double centerY = currentFolder.getY() + 32.0;
        this.playPath = new GeneralPath();
        int deltaHL = 4;
        int deltaHR = 8;
        int deltaV = 10;
        this.playPath.moveTo(centerX - (double)deltaHL, centerY);
        this.playPath.lineTo(centerX - (double)deltaHL, centerY - (double)deltaV);
        this.playPath.lineTo(centerX + (double)deltaHR, centerY);
        this.playPath.lineTo(centerX - (double)deltaHL, centerY + (double)deltaV);
        this.playPath.closePath();
        g2d.setColor(this.fillColor);
        if (this.playRollover) {
            g2d.setColor(this.drawColor);
        }
        g2d.fill(this.playPath);
        g2d.setColor(this.drawColor);
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.draw(this.playPath);
        this.donut2D.setCenterX((int)currentFolder.getX() + 32);
        this.donut2D.setCenterY((int)currentFolder.getY() + 32);
        this.donut2D.setOuterRadius(32.0);
        this.donut2D.setInnerRadius(22.0);
        this.donut2D.solveGeometry();
        List<Donut2DSlice> dss = this.donut2D.getSlices();
        for (Donut2DSlice donut2dSection : dss) {
            g2d.setColor(this.fillColor);
            if (donut2dSection.isLockRollover()) {
                g2d.setColor(this.drawColor);
            }
            g2d.fill(donut2dSection.getSlicePath());
            g2d.setColor(this.drawColor);
            g2d.setStroke(new BasicStroke(1.5f));
            g2d.draw(donut2dSection.getSlicePath());
        }
    }

    class DonutBoundBoxSection
    extends Donut2DSlice {
        private ZoomBoxPlugin.BoundBox boundBox;

        public DonutBoundBoxSection(String name, Color themeColor) {
            super(name, themeColor);
        }

        public ZoomBoxPlugin.BoundBox getBoundBox() {
            return this.boundBox;
        }

        public void setBoundBox(ZoomBoxPlugin.BoundBox boundBox) {
            this.boundBox = boundBox;
        }
    }

    class DonutPlayerCallback
    implements ZoomBoxPlugin.ZoomPlayerCallback {
        DonutPlayerCallback() {
        }

        @Override
        public void play(ZoomBoxPlugin.BoundBox bounbdBox) {
            ZoomBoxDonutWidget.this.unlockAllSection();
            DonutBoundBoxSection dbbs = ZoomBoxDonutWidget.this.getDonutBoundBoxSection(bounbdBox);
            dbbs.lockRollover();
            ((ZoomBoxPlugin)ZoomBoxDonutWidget.this.getHost()).getProjection().getView().getDevice2D().repaint();
        }
    }

    class ShiftWidget
    extends Thread {
        ShiftWidget() {
        }

        @Override
        public void run() {
            while (!ShiftWidget.interrupted() && ZoomBoxDonutWidget.this.shiftEffect) {
                try {
                    ZoomBoxDonutWidget.this.donut2D.setStartAngleDegree(ZoomBoxDonutWidget.this.donut2D.getStartAngleDegree() + 12.0);
                    Thread.sleep(50L);
                    ZoomBoxDonutWidget.this.repaintWidget();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

