/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.zoom.box;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.PluginEvent;
import org.jensoft.core.plugin.zoom.box.ZoomBoxEvent;
import org.jensoft.core.plugin.zoom.box.ZoomBoxListener;
import org.jensoft.core.plugin.zoom.box.ZoomBoxPlugin;
import org.jensoft.core.projection.Projection;

public class ZoomBoxSynchronizer
implements ZoomBoxListener {
    private List<ZoomBoxPlugin> boxesList = new ArrayList<ZoomBoxPlugin>();
    private boolean enabled = true;
    private boolean dispathingEvent = false;

    public ZoomBoxSynchronizer(ZoomBoxPlugin ... boxes) {
        for (int i = 0; i < boxes.length; ++i) {
            ZoomBoxPlugin zoomBoxPlugin = boxes[i];
            zoomBoxPlugin.addZoomBoxListener(this);
            zoomBoxPlugin.addPluginListener(this);
            this.boxesList.add(zoomBoxPlugin);
        }
    }

    public ZoomBoxSynchronizer(List<ZoomBoxPlugin> boxes) {
        for (int i = 0; i < boxes.size(); ++i) {
            ZoomBoxPlugin zoomBoxPlugin = boxes.get(i);
            zoomBoxPlugin.addZoomBoxListener(this);
            zoomBoxPlugin.addPluginListener(this);
            this.boxesList.add(zoomBoxPlugin);
        }
    }

    @Override
    public void pluginSelected(PluginEvent<ZoomBoxPlugin> pluginEvent) {
        if (this.enabled && !this.dispathingEvent) {
            this.dispathingEvent = true;
            ZoomBoxPlugin zoomBoxPlugin = (ZoomBoxPlugin)pluginEvent.getSource();
            for (ZoomBoxPlugin zbp : this.boxesList) {
                if (zbp.equals(zoomBoxPlugin)) continue;
                zbp.lockSelected();
            }
            this.dispathingEvent = false;
        }
    }

    @Override
    public void pluginUnlockSelected(PluginEvent<ZoomBoxPlugin> pluginEvent) {
        if (this.enabled && !this.dispathingEvent) {
            this.dispathingEvent = true;
            ZoomBoxPlugin zoomBoxPlugin = (ZoomBoxPlugin)pluginEvent.getSource();
            for (ZoomBoxPlugin zbp : this.boxesList) {
                if (zbp.equals(zoomBoxPlugin)) continue;
                zbp.unlockSelected();
            }
            this.dispathingEvent = false;
        }
    }

    @Override
    public void zoomStart(ZoomBoxEvent pluginEvent) {
        if (this.enabled && !this.dispathingEvent) {
            this.dispathingEvent = true;
            ZoomBoxPlugin zoomBoxPlugin = (ZoomBoxPlugin)pluginEvent.getSource();
            for (ZoomBoxPlugin zbp : this.boxesList) {
                if (zbp.equals(zoomBoxPlugin)) continue;
                Projection w2d = zbp.getProjection();
                Point2D userBoxStartSource = zoomBoxPlugin.getBoxStartUserPoint();
                Point2D deviceStartTarget = w2d.userToPixel(userBoxStartSource);
                zbp.processZoomStart(new Point2D.Double((int)deviceStartTarget.getX(), (int)deviceStartTarget.getY()));
                Point2D deviceBoxStartSource = zoomBoxPlugin.getBoxStartDevicePoint();
                zbp.processZoomStart(deviceBoxStartSource);
                w2d.getDevice2D().repaintDevice();
            }
            this.dispathingEvent = false;
        }
    }

    @Override
    public void zoomBounded(ZoomBoxEvent pluginEvent) {
        if (this.enabled && !this.dispathingEvent) {
            this.dispathingEvent = true;
            ZoomBoxPlugin zoomBoxPlugin = (ZoomBoxPlugin)pluginEvent.getSource();
            for (ZoomBoxPlugin zbp : this.boxesList) {
                if (zbp.equals(zoomBoxPlugin)) continue;
                Projection w2d = zbp.getProjection();
                Point2D userBoxCurrentSource = zoomBoxPlugin.getBoxCurrentUserPoint();
                Point2D deviceCurrentTarget = w2d.userToPixel(userBoxCurrentSource);
                zbp.processZoomBound(new Point2D.Double((int)deviceCurrentTarget.getX(), (int)deviceCurrentTarget.getY()));
                Point2D deviceBoxCurrentSource = zoomBoxPlugin.getBoxCurrentDevicePoint();
                zbp.processZoomBound(deviceBoxCurrentSource);
                w2d.getDevice2D().repaintDevice();
            }
            this.dispathingEvent = false;
        }
    }

    @Override
    public void zoomIn(ZoomBoxEvent pluginEvent) {
        if (this.enabled && !this.dispathingEvent) {
            this.dispathingEvent = true;
            ZoomBoxPlugin zoomBoxPlugin = (ZoomBoxPlugin)pluginEvent.getSource();
            for (ZoomBoxPlugin zbp : this.boxesList) {
                if (zbp.equals(zoomBoxPlugin)) continue;
                zbp.processZoomIn();
                zbp.fireZoomIn();
            }
            this.dispathingEvent = false;
        }
    }

    @Override
    public void zoomOut(ZoomBoxEvent pluginEvent) {
        if (this.enabled && !this.dispathingEvent) {
            this.dispathingEvent = true;
            ZoomBoxPlugin zoomBoxPlugin = (ZoomBoxPlugin)pluginEvent.getSource();
            for (ZoomBoxPlugin zbp : this.boxesList) {
                if (zbp.equals(zoomBoxPlugin)) continue;
                zbp.processZoomOut();
                zbp.fireZoomOut();
            }
            this.dispathingEvent = false;
        }
    }

    @Override
    public void zoomHistory(ZoomBoxEvent pluginEvent) {
        if (this.enabled && !this.dispathingEvent) {
            this.dispathingEvent = true;
            ZoomBoxPlugin zoomBoxPlugin = (ZoomBoxPlugin)pluginEvent.getSource();
            for (ZoomBoxPlugin zbp : this.boxesList) {
                if (zbp.equals(zoomBoxPlugin)) continue;
                zbp.processZoomHistory(zoomBoxPlugin.getCurentBoxIndex());
                zbp.fireZoomHistory();
            }
            this.dispathingEvent = false;
        }
    }

    @Override
    public void zoomClearHistory(ZoomBoxEvent pluginEvent) {
        if (this.enabled && !this.dispathingEvent) {
            this.dispathingEvent = true;
            ZoomBoxPlugin zoomBoxPlugin = (ZoomBoxPlugin)pluginEvent.getSource();
            for (ZoomBoxPlugin zbp : this.boxesList) {
                if (zbp.equals(zoomBoxPlugin)) continue;
                zbp.processZoomClearHistory();
                zbp.fireZoomClearHistory();
            }
            this.dispathingEvent = false;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

