/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.zoom.lens;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import org.jensoft.core.palette.color.ColorPalette;
import org.jensoft.core.palette.color.RosePalette;
import org.jensoft.core.plugin.zoom.lens.ZoomLensPlugin;
import org.jensoft.core.widget.pad.AbstractPlusMinusPadWidget;

public class LensPad
extends AbstractPlusMinusPadWidget<ZoomLensPlugin> {
    public static final String objectifPadID = "@widget/objectif/pad";
    private static final int widgetRadius = 32;
    private Color baseDrawColor = RosePalette.LEMONPEEL;
    private Color controlDrawColor = RosePalette.LEMONPEEL;
    private Color buttonDrawColor = RosePalette.AZALEA;
    private Color buttonRolloverDrawColor = RosePalette.LEMONPEEL;
    private Stroke buttonStroke = new BasicStroke(1.6f, 2, 0);
    private Stroke basicStroke = new BasicStroke(1.2f);

    public LensPad(String id, double squarePad, int xIndex, int yIndex) {
        super(objectifPadID, squarePad, xIndex, yIndex);
        this.setFillBaseColor(Color.BLACK);
        this.setFillControlColor(ColorPalette.BLACK);
        this.setDrawBaseColor(this.baseDrawColor);
        this.setDrawControlColor(this.controlDrawColor);
        this.setDrawButtonColor(this.buttonDrawColor);
        this.setDrawButtonStroke(this.buttonStroke);
        this.setDrawButtonRolloverColor(this.buttonRolloverDrawColor);
    }

    public LensPad() {
        super(objectifPadID, 64.0, 60, 100);
        this.setFillBaseColor(Color.BLACK);
        this.setFillControlColor(ColorPalette.BLACK);
        this.setDrawBaseColor(this.baseDrawColor);
        this.setDrawControlColor(this.controlDrawColor);
        this.setDrawButtonColor(this.buttonDrawColor);
        this.setDrawButtonStroke(this.buttonStroke);
        this.setDrawButtonRolloverColor(this.buttonRolloverDrawColor);
        this.getPadGeometry().setInset(6);
    }

    @Override
    public boolean isCompatiblePlugin() {
        return this.getHost() != null && this.getHost() instanceof ZoomLensPlugin;
    }

    @Override
    public void onNorthButtonPress() {
        ((ZoomLensPlugin)this.getHost()).startZoomIn(ZoomLensPlugin.ZoomNature.ZoomY);
        if (!((ZoomLensPlugin)this.getHost()).isLockSelected()) {
            return;
        }
        super.onNorthButtonPress();
    }

    @Override
    public void onNorthButtonReleased() {
        ((ZoomLensPlugin)this.getHost()).stopZoomIn();
        super.onNorthButtonReleased();
    }

    @Override
    public void onSouthButtonPress() {
        if (!((ZoomLensPlugin)this.getHost()).isLockSelected()) {
            return;
        }
        ((ZoomLensPlugin)this.getHost()).startZoomOut(ZoomLensPlugin.ZoomNature.ZoomY);
        super.onSouthButtonPress();
    }

    @Override
    public void onSouthButtonReleased() {
        ((ZoomLensPlugin)this.getHost()).stopZoomOut();
        super.onSouthButtonReleased();
    }

    @Override
    public void onWestButtonPress() {
        if (!((ZoomLensPlugin)this.getHost()).isLockSelected()) {
            return;
        }
        ((ZoomLensPlugin)this.getHost()).startZoomOut(ZoomLensPlugin.ZoomNature.ZoomX);
        super.onWestButtonPress();
    }

    @Override
    public void onWestButtonReleased() {
        ((ZoomLensPlugin)this.getHost()).stopZoomOut();
        super.onWestButtonReleased();
    }

    @Override
    public void onEastButtonPress() {
        if (!((ZoomLensPlugin)this.getHost()).isLockSelected()) {
            return;
        }
        ((ZoomLensPlugin)this.getHost()).startZoomIn(ZoomLensPlugin.ZoomNature.ZoomX);
        super.onEastButtonPress();
    }

    @Override
    public void onEastButtonReleased() {
        ((ZoomLensPlugin)this.getHost()).stopZoomIn();
        super.onEastButtonReleased();
    }

    @Override
    public void onRegister() {
        if (((ZoomLensPlugin)this.getHost()).getZoomLensType() != ZoomLensPlugin.ZoomLensType.ZoomXY) {
            throw new IllegalStateException("Pad lens is only compatible with lens type : " + ZoomLensPlugin.ZoomLensType.class.getName() + "#" + (Object)((Object)ZoomLensPlugin.ZoomLensType.ZoomXY));
        }
    }
}

