/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.zoom.lens;

import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.PluginEvent;
import org.jensoft.core.plugin.zoom.lens.ZoomLensEvent;
import org.jensoft.core.plugin.zoom.lens.ZoomLensListener;
import org.jensoft.core.plugin.zoom.lens.ZoomLensPlugin;

public class ZoomLensSynchronizer
implements ZoomLensListener {
    private List<ZoomLensPlugin> zoomObjectifsList = new ArrayList<ZoomLensPlugin>();
    private boolean enabled = true;
    private boolean dispathingEvent = false;

    public ZoomLensSynchronizer(ZoomLensPlugin ... zoomObjectifs) {
        for (int i = 0; i < zoomObjectifs.length; ++i) {
            ZoomLensPlugin objectif = zoomObjectifs[i];
            objectif.addZoomObjectifListener(this);
            objectif.addPluginListener(this);
            this.zoomObjectifsList.add(objectif);
        }
    }

    public ZoomLensSynchronizer(List<ZoomLensPlugin> zoomObjectifs) {
        for (int i = 0; i < zoomObjectifs.size(); ++i) {
            ZoomLensPlugin objectif = zoomObjectifs.get(i);
            objectif.addZoomObjectifListener(this);
            objectif.addPluginListener(this);
            this.zoomObjectifsList.add(objectif);
        }
    }

    @Override
    public void pluginSelected(PluginEvent<ZoomLensPlugin> pluginEvent) {
        if (this.enabled && !this.dispathingEvent) {
            this.dispathingEvent = true;
            ZoomLensPlugin sourceLock = (ZoomLensPlugin)pluginEvent.getSource();
            for (ZoomLensPlugin targetLock : this.zoomObjectifsList) {
                if (targetLock.equals(sourceLock)) continue;
                targetLock.lockSelected();
            }
            this.dispathingEvent = false;
        }
    }

    @Override
    public void pluginUnlockSelected(PluginEvent<ZoomLensPlugin> pluginEvent) {
        if (this.enabled && !this.dispathingEvent) {
            this.dispathingEvent = true;
            ZoomLensPlugin sourceLock = (ZoomLensPlugin)pluginEvent.getSource();
            for (ZoomLensPlugin targetLock : this.zoomObjectifsList) {
                if (targetLock.equals(sourceLock)) continue;
                targetLock.unlockSelected();
            }
            this.dispathingEvent = false;
        }
    }

    @Override
    public void zoomIn(ZoomLensEvent pluginEvent) {
        if (this.enabled && !this.dispathingEvent) {
            this.dispathingEvent = true;
            ZoomLensPlugin sourceObjectif = (ZoomLensPlugin)pluginEvent.getSource();
            for (ZoomLensPlugin targetObjectif : this.zoomObjectifsList) {
                if (targetObjectif.equals(sourceObjectif)) continue;
                targetObjectif.zoomIn(sourceObjectif.getProcessNature());
            }
            this.dispathingEvent = false;
        }
    }

    @Override
    public void zoomOut(ZoomLensEvent pluginEvent) {
        if (this.enabled && !this.dispathingEvent) {
            this.dispathingEvent = true;
            ZoomLensPlugin sourceObjectif = (ZoomLensPlugin)pluginEvent.getSource();
            for (ZoomLensPlugin targetObjectif : this.zoomObjectifsList) {
                if (targetObjectif.equals(sourceObjectif)) continue;
                targetObjectif.zoomOut(sourceObjectif.getProcessNature());
            }
            this.dispathingEvent = false;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

