/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.zoom.percent;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.SwingUtilities;
import org.jensoft.core.graphics.Antialiasing;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewPart;

public class ZoomPercentPlugin
extends AbstractPlugin
implements AbstractPlugin.OnMoveListener,
AbstractPlugin.OnPressListener,
AbstractPlugin.OnReleaseListener {
    private Rectangle2D dragBox;
    int dragBoxXmargin = 4;
    int dragBoxYmargin = 2;
    private double dragBoxX;
    private double dragBoxY;
    Rectangle2D percent25Box;
    boolean percent25BoxRollover = false;
    boolean percent25BoxLock = false;
    Rectangle2D percent50Box;
    boolean percent50BoxRollover = false;
    boolean percent50BoxLock = false;
    Rectangle2D percent100Box;
    boolean percent100BoxRollover = false;
    boolean percent100BoxLock = false;

    public ZoomPercentPlugin() {
        this.setName("ZoomPercentPlugin");
        this.setPriority(100);
        this.setAntialiasing(Antialiasing.On);
    }

    public void zoomInit() {
        if (this.getProjection() instanceof Projection.Linear) {
            Projection.Linear wl = (Projection.Linear)this.getProjection();
            double minx = wl.getInitialMinX();
            double maxx = wl.getInitialMaxX();
            double miny = wl.getInitialMinY();
            double maxy = wl.getInitialMaxY();
            wl.bound(minx, maxx, miny, maxy);
        }
    }

    public ZoomInitAction getZoomInitAction() {
        return new ZoomInitAction();
    }

    public ZoomPercentAction getZoomPercentAction(ZoomPercent zoomPercent) {
        return new ZoomPercentAction(zoomPercent);
    }

    @Override
    public void onRelease(MouseEvent me) {
        this.percent25BoxRollover = false;
        this.percent25BoxLock = false;
        this.percent50BoxRollover = false;
        this.percent50BoxLock = false;
        this.percent100BoxRollover = false;
        this.percent100BoxLock = false;
        this.getView().repaintDevice();
    }

    @Override
    public void onPress(MouseEvent me) {
        Point2D.Double p2d = new Point2D.Double(me.getX(), me.getY());
        this.percent25BoxLock = this.percent25Box.contains(p2d) && this.percent25BoxRollover;
        this.percent50BoxLock = this.percent50Box.contains(p2d) && this.percent50BoxRollover;
        this.percent100BoxLock = this.percent100Box.contains(p2d) && this.percent100BoxRollover;
        this.getView().repaintDevice();
    }

    @Override
    public void onMove(MouseEvent me) {
        Point2D.Double p2d = new Point2D.Double(me.getX(), me.getY());
        this.percent25BoxRollover = this.percent25Box.contains(p2d);
        this.percent50BoxRollover = this.percent50Box.contains(p2d);
        this.percent100BoxRollover = this.percent100Box.contains(p2d);
        this.getView().repaintDevice();
    }

    @Override
    protected void paintPlugin(View v2d, Graphics2D g2d, ViewPart viewPart) {
        if (viewPart != ViewPart.Device) {
            return;
        }
    }

    private void drawDragBox(Graphics2D g2d) {
        int dw = this.getProjection().getDevice2D().getDeviceWidth();
        int dh = this.getProjection().getDevice2D().getDeviceHeight();
        int dragBoxW = 100;
        int dragBoxH = 40;
        this.dragBox = new Rectangle2D.Double(this.dragBoxXmargin, dh - dragBoxH - this.dragBoxYmargin, dragBoxW, dragBoxH);
        g2d.setColor(this.getThemeColor().darker());
        int widthBar = 8;
        int interCell = 2;
        this.percent25Box = new Rectangle2D.Double(this.dragBoxXmargin, dh - 10 - this.dragBoxYmargin, widthBar, 10.0);
        if (this.percent25BoxRollover) {
            g2d.setColor(this.getThemeColor().brighter());
        } else {
            g2d.setColor(this.getThemeColor().darker());
        }
        g2d.fill(this.percent25Box);
        this.percent50Box = new Rectangle2D.Double(this.dragBoxXmargin + widthBar + interCell, dh - 20 - this.dragBoxYmargin, widthBar, 20.0);
        if (this.percent50BoxRollover) {
            g2d.setColor(this.getThemeColor().brighter());
        } else {
            g2d.setColor(this.getThemeColor().darker());
        }
        g2d.fill(this.percent50Box);
        this.percent100Box = new Rectangle2D.Double(this.dragBoxXmargin + 2 * widthBar + 2 * interCell, dh - 30 - this.dragBoxYmargin, widthBar, 30.0);
        if (this.percent100BoxRollover) {
            g2d.setColor(this.getThemeColor().brighter());
        } else {
            g2d.setColor(this.getThemeColor().darker());
        }
        g2d.fill(this.percent100Box);
    }

    public class ZoomPercentAction
    implements ActionListener {
        private ZoomPercent zoomPercent;

        public ZoomPercentAction(ZoomPercent zoomPercent) {
            this.zoomPercent = zoomPercent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ZoomPercentPlugin.this.getProjection() instanceof Projection.Linear) {
                Projection.Linear wl = (Projection.Linear)ZoomPercentPlugin.this.getProjection();
                if (this.zoomPercent != ZoomPercent.Init) {
                    float percentFactor = this.zoomPercent.getPercent();
                    Point2D center = wl.getUserCenter();
                    double width = ZoomPercentPlugin.this.getProjection().getUserWidth();
                    double partX = width / 2.0;
                    double minx = center.getX() - partX / (double)percentFactor;
                    double maxx = center.getX() + partX / (double)percentFactor;
                    double height = ZoomPercentPlugin.this.getProjection().getUserHeight();
                    double partY = height / 2.0;
                    double miny = center.getY() - partY / (double)percentFactor;
                    double maxy = center.getY() + partY / (double)percentFactor;
                    wl.bound(minx, maxx, miny, maxy);
                    ZoomPercentPlugin.this.getProjection().getView().repaint();
                } else {
                    ZoomPercentPlugin.this.zoomInit();
                    ZoomPercentPlugin.this.getProjection().getView().repaint();
                }
            }
        }
    }

    class ZoomInitAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ZoomPercentPlugin.this.zoomInit();
                }
            });
        }
    }

    public static enum ZoomPercent {
        Init(-1.0f),
        Zoom10(0.1f),
        Zoom25(0.25f),
        Zoom50(0.5f),
        Zoom200(2.0f),
        Zoom400(4.0f),
        Zoom800(8.0f);

        private float percent;

        private ZoomPercent(float percent) {
            this.percent = percent;
        }

        public float getPercent() {
            return this.percent;
        }
    }
}

