/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.plugin.zoom.wheel;

import java.util.ArrayList;
import java.util.List;
import org.jensoft.core.plugin.PluginEvent;
import org.jensoft.core.plugin.zoom.wheel.ZoomWheelEvent;
import org.jensoft.core.plugin.zoom.wheel.ZoomWheelListener;
import org.jensoft.core.plugin.zoom.wheel.ZoomWheelPlugin;

public class ZoomWheelSynchronizer
implements ZoomWheelListener {
    private List<ZoomWheelPlugin> zoomWheelList = new ArrayList<ZoomWheelPlugin>();
    private boolean enabled = true;
    private boolean dispathingEvent = false;

    public ZoomWheelSynchronizer(ZoomWheelPlugin ... zoomWheels) {
        for (int i = 0; i < zoomWheels.length; ++i) {
            ZoomWheelPlugin wheel = zoomWheels[i];
            wheel.addZoomWheelListener(this);
            this.zoomWheelList.add(wheel);
        }
    }

    public ZoomWheelSynchronizer(List<ZoomWheelPlugin> zoomWheels) {
        for (int i = 0; i < zoomWheels.size(); ++i) {
            ZoomWheelPlugin wheel = zoomWheels.get(i);
            wheel.addZoomWheelListener(this);
            wheel.addPluginListener(this);
            this.zoomWheelList.add(wheel);
        }
    }

    @Override
    public void pluginSelected(PluginEvent<ZoomWheelPlugin> pluginEvent) {
    }

    @Override
    public void pluginUnlockSelected(PluginEvent<ZoomWheelPlugin> pluginEvent) {
    }

    @Override
    public void zoomIn(ZoomWheelEvent pluginEvent) {
        if (this.enabled && !this.dispathingEvent) {
            this.dispathingEvent = true;
            ZoomWheelPlugin sourceZoomWheelPlugin = (ZoomWheelPlugin)pluginEvent.getSource();
            for (ZoomWheelPlugin targetZoomWheelPlugin : this.zoomWheelList) {
                if (targetZoomWheelPlugin.equals(sourceZoomWheelPlugin)) continue;
                targetZoomWheelPlugin.zoomIn();
                targetZoomWheelPlugin.fireZoomIn();
            }
            this.dispathingEvent = false;
        }
    }

    @Override
    public void zoomOut(ZoomWheelEvent pluginEvent) {
        if (this.enabled && !this.dispathingEvent) {
            this.dispathingEvent = true;
            ZoomWheelPlugin sourceZoomWheelPlugin = (ZoomWheelPlugin)pluginEvent.getSource();
            for (ZoomWheelPlugin targetZoomWheelPlugin : this.zoomWheelList) {
                if (targetZoomWheelPlugin.equals(sourceZoomWheelPlugin)) continue;
                targetZoomWheelPlugin.zoomOut();
                targetZoomWheelPlugin.fireZoomOut();
            }
            this.dispathingEvent = false;
        }
    }
}

