/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.projection;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jensoft.core.device.Device;
import org.jensoft.core.map.projection.DalleProjection;
import org.jensoft.core.map.projection.GeoPosition;
import org.jensoft.core.palette.color.ColorPalette;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.PluginEvent;
import org.jensoft.core.plugin.PluginListener;
import org.jensoft.core.projection.ProjectionEvent;
import org.jensoft.core.projection.ProjectionListener;
import org.jensoft.core.view.View;
import org.jensoft.core.view.ViewAdapter;
import org.jensoft.core.view.ViewEvent;

public abstract class Projection
implements PluginListener {
    private Device device2D;
    private View view;
    private String projID;
    private String name;
    private Color themeColor;
    private boolean visible = true;
    private boolean lockActive;
    protected EventListenerList listenerList = new EventListenerList();
    private List<AbstractPlugin> plugins = new ArrayList<AbstractPlugin>();

    protected Projection() {
    }

    public String getProjectionId() {
        return this.projID;
    }

    public void setProjectionId(String projID) {
        this.projID = projID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Device getDevice2D() {
        return this.device2D;
    }

    public void setDevice2D(Device device) {
        this.device2D = device;
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    public int getThemeRed() {
        return this.getThemeColor().getRed();
    }

    public int getThemeGreen() {
        return this.getThemeColor().getGreen();
    }

    public int getThemeBlue() {
        return this.getThemeColor().getBlue();
    }

    public Color getThemeColor() {
        if (this.themeColor == null) {
            this.themeColor = ColorPalette.getRandomColor();
        }
        return this.themeColor;
    }

    public void setThemeColor(Color themeColor) {
        this.themeColor = themeColor;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void lockActive() {
        this.lockActive = true;
        this.fireProjectionActivate();
    }

    public void unlockActive() {
        this.lockActive = false;
        this.fireProjectionPassivate();
    }

    public boolean isLockActive() {
        return this.lockActive;
    }

    public void addProjectionListener(ProjectionListener listener) {
        this.listenerList.add(ProjectionListener.class, listener);
    }

    public void removeProjectionListener(ProjectionListener listener) {
        this.listenerList.remove(ProjectionListener.class, listener);
    }

    public List<AbstractPlugin> getPluginRegistry() {
        return this.plugins;
    }

    public List<AbstractPlugin> getSelectablePlugins() {
        ArrayList<AbstractPlugin> selectablePlugins = new ArrayList<AbstractPlugin>();
        for (AbstractPlugin plugin : this.plugins) {
            if (!plugin.isSelectable()) continue;
            selectablePlugins.add(plugin);
        }
        return selectablePlugins;
    }

    public void registerPlugin(AbstractPlugin plugin) {
        if (this.plugins.contains(plugin)) {
            return;
        }
        plugin.setProjection(this);
        plugin.addPluginListener(this);
        this.plugins.add(plugin);
        plugin.onProjectionRegister();
    }

    public void onViewRegister() {
        this.getView().addViewListener(new ViewAdapter(){

            @Override
            public void viewResized(ViewEvent view2dEvent) {
                Projection.this.fireProjectionResized();
            }
        });
    }

    public void unregisterAll() {
        this.plugins.clear();
    }

    public void unregisterPlugin(AbstractPlugin plugin) {
        plugin.removePluginListener(this);
        this.plugins.remove(plugin);
    }

    public void pluginSelected(PluginEvent te) {
        AbstractPlugin selectedPlugin = (AbstractPlugin)te.getSource();
        for (AbstractPlugin plugin : this.plugins) {
            if (plugin.equals(selectedPlugin) || !plugin.isLockSelected()) continue;
            plugin.unlockSelected();
        }
    }

    public void pluginUnlockSelected(PluginEvent te) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProjectionActivate() {
        Object[] listeners;
        ProjectionEvent w2dEvent = new ProjectionEvent(this);
        Object[] objectArray = listeners = this.listenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != ProjectionListener.class) continue;
                ((ProjectionListener)listeners[i + 1]).projectionLockActive(w2dEvent);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProjectionPassivate() {
        Object[] listeners;
        ProjectionEvent w2dEvent = new ProjectionEvent(this);
        Object[] objectArray = listeners = this.listenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != ProjectionListener.class) continue;
                ((ProjectionListener)listeners[i + 1]).projectionUnlockActive(w2dEvent);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProjectionBoundChanged() {
        Object[] listeners;
        ProjectionEvent w2dEvent = new ProjectionEvent(this);
        Object[] objectArray = listeners = this.listenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != ProjectionListener.class) continue;
                ((ProjectionListener)listeners[i + 1]).projectionBoundChanged(w2dEvent);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProjectionResized() {
        Object[] listeners;
        ProjectionEvent w2dEvent = new ProjectionEvent(this);
        Object[] objectArray = listeners = this.listenerList.getListenerList();
        synchronized (listeners) {
            for (int i = 0; i < listeners.length; i += 2) {
                if (listeners[i] != ProjectionListener.class) continue;
                ((ProjectionListener)listeners[i + 1]).projectionResized(w2dEvent);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public boolean intercept(Point2D p2dUser) {
        return this.interceptX(p2dUser.getX()) && this.interceptY(p2dUser.getY());
    }

    public boolean interceptX(double userX) {
        return !(userX > this.getMaxX()) && !(userX < this.getMinX());
    }

    public boolean interceptY(double userY) {
        return !(userY > this.getMaxY()) && !(userY < this.getMinY());
    }

    public double getUserWidth() {
        return this.getMaxX() - this.getMinX();
    }

    public double getPixelWidth() {
        return this.getDevice2D().getDeviceWidth();
    }

    public double getUserHeight() {
        return this.getMaxY() - this.getMinY();
    }

    public double getPixelHeight() {
        return this.getDevice2D().getDeviceHeight();
    }

    public abstract double getMinX();

    public abstract double getMinY();

    public abstract double getMaxX();

    public abstract double getMaxY();

    public final Point2D userToPixel(Point2D userPoint) {
        return new Point2D.Double(this.userToPixelX(userPoint.getX()), this.userToPixelY(userPoint.getY()));
    }

    public final Point2D pixelToUser(Point2D pixelPoint) {
        return new Point2D.Double(this.pixelToUserX(pixelPoint.getX()), this.pixelToUserY(pixelPoint.getY()));
    }

    public abstract double userToPixelX(double var1);

    public abstract double userToPixelY(double var1);

    public abstract double pixelToUserX(double var1);

    public abstract double pixelToUserY(double var1);

    public static class SymbolY
    extends Linear
    implements Serializable {
        private static final long serialVersionUID = 5596190230123838729L;

        public SymbolY(double minx, double maxx) {
            super(minx, maxx, 0.0, 0.0);
        }
    }

    public static class SymbolX
    extends Linear
    implements Serializable {
        private static final long serialVersionUID = 5596190230123838729L;

        public SymbolX(double miny, double maxy) {
            super(0.0, 0.0, miny, maxy);
        }
    }

    public static class TimeY
    extends Time
    implements Serializable {
        private static final long serialVersionUID = -7000203845075240349L;

        public TimeY(double minx, double maxx, Date minYDate, Date maxYDate) {
            super(minx, maxx, minYDate.getTime(), maxYDate.getTime());
        }

        public Date getMinYAsDate() {
            return new Date(new Double(this.getMinY()).longValue());
        }

        public Date getMaxYAsDate() {
            return new Date(new Double(this.getMaxY()).longValue());
        }

        @Override
        public Date getMinDate() {
            return this.getMinYAsDate();
        }

        @Override
        public Date getMaxDate() {
            return this.getMaxYAsDate();
        }

        @Override
        public Date pixelToTime(double pixel) {
            double dateMillis = this.pixelToUserY(pixel);
            return new Date(new Double(dateMillis).longValue());
        }

        @Override
        public double timeToPixel(Date time) {
            double userValue = new Long(time.getTime()).doubleValue();
            return this.userToPixelY(userValue);
        }

        @Override
        public int getTimeDurationPixel() {
            return this.getDevice2D().getDeviceHeight();
        }

        public void bound(double minx, double maxx, Date minYDate, Date maxYDate) {
            super.bound(minx, maxx, minYDate.getTime(), maxYDate.getTime());
        }

        public long getHeightAsMinutes() {
            long startMillis = new Double(this.getMinY()).longValue();
            long endMillis = new Double(this.getMaxY()).longValue();
            long width = endMillis - startMillis;
            long minutesMillis = 60000L;
            long heightAsMinutes = width / minutesMillis;
            return heightAsMinutes;
        }
    }

    public static class TimeX
    extends Time
    implements Serializable {
        private static final long serialVersionUID = -1604008751024713864L;

        public TimeX(Date minXDate, Date maxXDate, double miny, double maxy) {
            super(minXDate.getTime(), maxXDate.getTime(), miny, maxy);
        }

        @Override
        public Date getMinDate() {
            return this.getMinXAsDate();
        }

        @Override
        public Date getMaxDate() {
            return this.getMaxXAsDate();
        }

        public Date getMinXAsDate() {
            return new Date(new Double(this.getMinX()).longValue());
        }

        public Date getMaxXAsDate() {
            return new Date(new Double(this.getMaxX()).longValue());
        }

        @Override
        public Date pixelToTime(double pixel) {
            double dateMillis = this.pixelToUserX(pixel);
            return new Date(new Double(dateMillis).longValue());
        }

        @Override
        public double timeToPixel(Date time) {
            double userValue = new Long(time.getTime()).doubleValue();
            return this.userToPixelX(userValue);
        }

        @Override
        public int getTimeDurationPixel() {
            return this.getDevice2D().getDeviceWidth();
        }

        public void bound(Date minXDate, Date maxXDate, double miny, double maxy) {
            super.bound(minXDate.getTime(), maxXDate.getTime(), miny, maxy);
        }
    }

    public static abstract class Time
    extends Linear
    implements Serializable {
        private static final long serialVersionUID = 5908781043325467240L;

        public Time(double minx, double maxx, double miny, double maxy) {
            super(minx, maxx, miny, maxy);
        }

        public abstract Date getMinDate();

        public abstract Date getMaxDate();

        public abstract Date pixelToTime(double var1);

        public abstract double timeToPixel(Date var1);

        public abstract int getTimeDurationPixel();

        public long durationMillis() {
            return this.getMaxDate().getTime() - this.getMinDate().getTime();
        }

        public long durationMinutes() {
            long minutesMillis = 60000L;
            long minutes = this.durationMillis() / minutesMillis;
            return minutes;
        }

        public long durationHours() {
            long hourMillis = 3600000L;
            long hours = this.durationMillis() / hourMillis;
            return hours;
        }

        public long durationDays() {
            long dayMillis = 86400000L;
            long days = this.durationMillis() / dayMillis;
            return days;
        }

        public long durationWeeks() {
            long weekMillis = 604800000L;
            long weeks = this.durationMillis() / weekMillis;
            return weeks;
        }

        public long durationMonth() {
            long monthMillis = 2419200000L;
            long months = this.durationMillis() / monthMillis;
            return months;
        }
    }

    public static class Map
    extends Projection
    implements Serializable {
        private DalleProjection projection;
        private GeoPosition centerPosition;
        private int level;
        private static final long serialVersionUID = -7328711106680920578L;

        public Map() {
            this.projection = new DalleProjection(16, 128);
            this.centerPosition = new GeoPosition(25.854, -80.134);
        }

        public Map(GeoPosition centerPosition, int level, int squareTile) {
            this.centerPosition = centerPosition;
            this.projection = new DalleProjection(level, squareTile);
        }

        public GeoPosition getCenterPosition() {
            return this.centerPosition;
        }

        public void setCenterPosition(GeoPosition centerPosition) {
            this.centerPosition = centerPosition;
        }

        public DalleProjection getProjection() {
            return this.projection;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        @Override
        public double getMinX() {
            double centerXPixel = this.projection.longitudeToPixel(this.getCenterPosition().getLongitude());
            return this.projection.pixelToLongitude(centerXPixel - this.getPixelWidth() / 2.0);
        }

        @Override
        public double getMaxX() {
            double centerXPixel = this.projection.longitudeToPixel(this.getCenterPosition().getLongitude());
            return this.projection.pixelToLongitude(centerXPixel + this.getPixelWidth() / 2.0);
        }

        @Override
        public double getMinY() {
            double centerYPixel = this.projection.latitudeToPixel(this.getCenterPosition().getLatitude());
            return this.projection.pixelToLatitude(centerYPixel + this.getPixelHeight() / 2.0);
        }

        @Override
        public double getMaxY() {
            double centerYPixel = this.projection.latitudeToPixel(this.getCenterPosition().getLatitude());
            return this.projection.pixelToLatitude(centerYPixel - this.getPixelHeight() / 2.0);
        }

        @Override
        public double userToPixelX(double userX) {
            double centerXPixel = this.projection.longitudeToPixel(this.getCenterPosition().getLongitude());
            return -centerXPixel + this.getPixelWidth() / 2.0 + this.projection.longitudeToPixel(userX);
        }

        @Override
        public double userToPixelY(double userY) {
            double centerYPixel = this.projection.latitudeToPixel(this.getCenterPosition().getLatitude());
            return -centerYPixel + this.getPixelHeight() / 2.0 + this.projection.latitudeToPixel(userY);
        }

        @Override
        public double pixelToUserX(double pixelX) {
            return 0.0;
        }

        @Override
        public double pixelToUserY(double pixelY) {
            return 0.0;
        }
    }

    public static class Log
    extends Linear
    implements Serializable {
        private static final long serialVersionUID = 6040320270911080943L;

        public Log(double minx, double maxx, double miny, double maxy) {
            if (minx <= 0.0) {
                throw new IllegalArgumentException("Log projection, minx should be greater than 0.");
            }
            if (miny <= 0.0) {
                throw new IllegalArgumentException("Log projection, miny should be greater than 0.");
            }
            this.bound(minx, maxx, miny, maxy);
        }

        @Override
        public Double getScaleX() {
            if (this.scaleX == null) {
                this.scaleX = (double)this.getDevice2D().getDeviceWidth() / (Math.log10(this.getMaxX()) - Math.log10(this.getMinX()));
            }
            return this.scaleX;
        }

        @Override
        public Double getScaleY() {
            if (this.scaleY == null) {
                this.scaleY = (double)this.getDevice2D().getDeviceHeight() / (Math.log10(this.getMaxY()) - Math.log10(this.getMinY()));
            }
            return this.scaleY;
        }

        @Override
        public double userToPixelX(double userX) {
            return this.getScaleX() * (Math.log10(userX) - Math.log10(this.getMinX()));
        }

        @Override
        public double pixelToUserX(double pixelX) {
            return Math.pow(10.0, pixelX / this.getScaleX() + Math.log10(this.getMinX()));
        }

        @Override
        public double userToPixelY(double userY) {
            return -this.getScaleY().doubleValue() * (Math.log10(userY) - Math.log10(this.getMaxY()));
        }

        @Override
        public double pixelToUserY(double pixelY) {
            return Math.pow(10.0, -(pixelY / this.getScaleY() - Math.log10(this.getMaxY())));
        }
    }

    public static class LogY
    extends Linear
    implements Serializable {
        private static final long serialVersionUID = -2268519178555649250L;

        public LogY(double minx, double maxx, double miny, double maxy) {
            if (miny <= 0.0) {
                throw new IllegalArgumentException("LogY window projection, miny should be greater than 0.");
            }
            this.bound(minx, maxx, miny, maxy);
        }

        @Override
        public Double getScaleY() {
            if (this.scaleY == null) {
                this.scaleY = (double)this.getDevice2D().getDeviceHeight() / (Math.log10(this.getMaxY()) - Math.log10(this.getMinY()));
            }
            return this.scaleY;
        }

        @Override
        public double userToPixelY(double userY) {
            return -this.getScaleY().doubleValue() * (Math.log10(userY) - Math.log10(this.getMaxY()));
        }

        @Override
        public double pixelToUserY(double pixelY) {
            return Math.pow(10.0, -(pixelY / this.getScaleY() - Math.log10(this.getMaxY())));
        }
    }

    public static class LogX
    extends Linear
    implements Serializable {
        private static final long serialVersionUID = -2274590506013668597L;

        public LogX(double minx, double maxx, double miny, double maxy) {
            if (minx <= 0.0) {
                throw new IllegalArgumentException("LogX projection, minx should be greater than 0.");
            }
            this.bound(minx, maxx, miny, maxy);
        }

        @Override
        public Double getScaleX() {
            if (this.scaleX == null) {
                this.scaleX = (double)this.getDevice2D().getDeviceWidth() / (Math.log10(this.getMaxX()) - Math.log10(this.getMinX()));
            }
            return this.scaleX;
        }

        @Override
        public double userToPixelX(double userX) {
            return this.getScaleX() * (Math.log10(userX) - Math.log10(this.getMinX()));
        }

        @Override
        public double pixelToUserX(double pixelX) {
            return Math.pow(10.0, pixelX / this.getScaleX() + Math.log10(this.getMinX()));
        }
    }

    public static class Linear
    extends Projection
    implements Serializable {
        private double initialMinX = 0.0;
        private double initialMaxX = 0.0;
        private double initialMinY = 0.0;
        private double initialMaxY = 0.0;
        private double minX = 0.0;
        private double maxX = 0.0;
        private double minY = 0.0;
        private double maxY = 0.0;
        private boolean initial = true;
        protected Double scaleX;
        protected Double scaleY;
        private static final long serialVersionUID = 5202790832488044493L;

        public Linear() {
        }

        public Linear(double minx, double maxx, double miny, double maxy) {
            this.bound(minx, maxx, miny, maxy);
        }

        public void bound(double minx, double maxx, double miny, double maxy) {
            if (minx > maxx) {
                throw new IllegalArgumentException("maxx argument should be greater than minx");
            }
            if (miny > maxy) {
                throw new IllegalArgumentException("maxy argument should be greater than miny");
            }
            if (this.initial) {
                this.setInitialMinX(minx);
                this.setInitialMaxX(maxx);
                this.setInitialMinY(miny);
                this.setInitialMaxY(maxy);
                this.initial = false;
            }
            this.setMinX(minx);
            this.setMaxX(maxx);
            this.setMinY(miny);
            this.setMaxY(maxy);
            this.scaleX = null;
            this.scaleY = null;
            ((Projection)this).fireProjectionBoundChanged();
        }

        protected void resetScale() {
            this.scaleX = null;
            this.scaleY = null;
        }

        @Override
        public void onViewRegister() {
            super.onViewRegister();
            this.getView().addViewListener(new ViewAdapter(){

                @Override
                public void viewResized(ViewEvent view2dEvent) {
                    Linear.this.resetScale();
                }
            });
        }

        public void setInitial(boolean initial) {
            this.initial = initial;
        }

        public Point2D getUserCenter() {
            return new Point2D.Double(this.minX + (this.maxX - this.minX) / 2.0, this.minY + (this.maxY - this.minY) / 2.0);
        }

        public double getInitialMinX() {
            return this.initialMinX;
        }

        public double getInitialMaxX() {
            return this.initialMaxX;
        }

        public double getInitialMinY() {
            return this.initialMinY;
        }

        public double getInitialMaxY() {
            return this.initialMaxY;
        }

        public double getInitialWidth() {
            return this.initialMaxX - this.initialMinX;
        }

        public double getInitialHeight() {
            return this.initialMaxY - this.initialMinY;
        }

        @Override
        public double getMinX() {
            return this.minX;
        }

        @Override
        public double getMaxX() {
            return this.maxX;
        }

        @Override
        public double getMinY() {
            return this.minY;
        }

        @Override
        public double getMaxY() {
            return this.maxY;
        }

        private void setInitialMinX(double initialMinX) {
            this.initialMinX = initialMinX;
        }

        private void setInitialMaxX(double initialMaxX) {
            this.initialMaxX = initialMaxX;
        }

        private void setInitialMinY(double initialMinY) {
            this.initialMinY = initialMinY;
        }

        private void setInitialMaxY(double initialMaxY) {
            this.initialMaxY = initialMaxY;
        }

        private void setMinX(double minX) {
            this.minX = minX;
        }

        private void setMaxX(double maxX) {
            this.maxX = maxX;
        }

        private void setMinY(double minY) {
            this.minY = minY;
        }

        private void setMaxY(double maxY) {
            this.maxY = maxY;
        }

        public Double getScaleX() {
            if (this.scaleX == null) {
                this.scaleX = this.getPixelWidth() / this.getUserWidth();
            }
            return this.scaleX;
        }

        public Double getScaleY() {
            if (this.scaleY == null) {
                this.scaleY = this.getPixelHeight() / this.getUserHeight();
            }
            return this.scaleY;
        }

        @Override
        public double userToPixelX(double userX) {
            return this.getScaleX() * (userX - this.getMinX());
        }

        @Override
        public double userToPixelY(double userY) {
            return -this.getScaleY().doubleValue() * (userY - this.getMaxY());
        }

        @Override
        public double pixelToUserX(double pixelX) {
            return pixelX / this.getScaleX() + this.getMinX();
        }

        @Override
        public double pixelToUserY(double pixelY) {
            return -(pixelY / this.getScaleY() - this.getMaxY());
        }

        public static class Identity
        extends Linear {
            private static final long serialVersionUID = -3789513878376535416L;

            public Identity() {
                super(-1.0, 1.0, -1.0, 1.0);
            }
        }
    }
}

