/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.sharedicon;

import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import org.jensoft.core.sharedicon.common.Common;
import org.jensoft.core.sharedicon.marker.Marker;
import org.jensoft.core.sharedicon.media.Media;
import org.jensoft.core.sharedicon.refresh.Refresh;
import org.jensoft.core.sharedicon.weather.Weather;

public class SharedIcon {
    private Map<String, ImageIcon> cache = new WeakHashMap<String, ImageIcon>();
    private static SharedIcon instance;

    public Map<String, ImageIcon> getCache() {
        return this.cache;
    }

    private SharedIcon() {
    }

    public static ImageIcon getCachedIcon(String nameSpace, String iconName) {
        String key = nameSpace + "/" + iconName;
        ImageIcon cacheObject = SharedIcon.getInstance().getCache().get(key);
        if (cacheObject != null) {
            return cacheObject;
        }
        return null;
    }

    public static void cacheIcon(String nameSpace, String iconName, ImageIcon icon) {
        String key = nameSpace + "/" + iconName;
        SharedIcon.getInstance().getCache().put(key, icon);
    }

    public static SharedIcon getInstance() {
        if (instance == null) {
            instance = new SharedIcon();
        }
        return instance;
    }

    public static ImageIcon getMarker(String marker) {
        URL imgURL;
        ImageIcon icon = SharedIcon.getCachedIcon(Marker.class.getName(), marker);
        if (icon == null && (imgURL = Marker.class.getResource(marker)) != null) {
            icon = new ImageIcon(imgURL);
            SharedIcon.cacheIcon(Marker.class.getName(), marker, icon);
        }
        return icon;
    }

    public static ImageIcon getWeather(String weather) {
        URL imgURL;
        ImageIcon icon = SharedIcon.getCachedIcon(Weather.class.getName(), weather);
        if (icon == null && (imgURL = Weather.class.getResource(weather)) != null) {
            icon = new ImageIcon(imgURL);
            SharedIcon.cacheIcon(Weather.class.getName(), weather, icon);
        }
        return icon;
    }

    public static ImageIcon getMedia(String media) {
        URL imgURL;
        ImageIcon icon = SharedIcon.getCachedIcon(Media.class.getName(), media);
        if (icon == null && (imgURL = Media.class.getResource(media)) != null) {
            icon = new ImageIcon(imgURL);
            SharedIcon.cacheIcon(Media.class.getName(), media, icon);
        }
        return icon;
    }

    public static ImageIcon getRefresh(String refresh) {
        URL imgURL;
        ImageIcon icon = SharedIcon.getCachedIcon(Refresh.class.getName(), refresh);
        if (icon == null && (imgURL = Refresh.class.getResource(refresh)) != null) {
            icon = new ImageIcon(imgURL);
            SharedIcon.cacheIcon(Refresh.class.getName(), refresh, icon);
        }
        return icon;
    }

    public static ImageIcon getCommon(String common) {
        URL imgURL;
        ImageIcon icon = SharedIcon.getCachedIcon(Common.class.getName(), common);
        if (icon == null && (imgURL = Common.class.getResource(common)) != null) {
            icon = new ImageIcon(imgURL);
            SharedIcon.cacheIcon(Common.class.getName(), common, icon);
        }
        return icon;
    }
}

