/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.view.background;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.jensoft.core.view.View;
import org.jensoft.core.view.background.ViewBackgroundPainter;

public class DualViewBackground
extends ViewBackgroundPainter {
    private int outlineRound = 20;
    private int paddingX = 2;
    private int paddingY = 2;
    private Color color1 = Color.BLACK;
    private Color color2 = Color.RED;
    private TexturePaint texture1;
    private TexturePaint texture2;

    public DualViewBackground() {
    }

    public DualViewBackground(Color color1, Color color2) {
        this.color1 = color1;
        this.color2 = color2;
    }

    public DualViewBackground(TexturePaint texture1, TexturePaint texture2) {
        this.texture1 = texture1;
        this.texture2 = texture2;
    }

    public DualViewBackground(Color color1, TexturePaint texture2) {
        this.color1 = color1;
        this.texture2 = texture2;
    }

    public DualViewBackground(TexturePaint texture1, Color color2) {
        this.texture1 = texture1;
        this.color2 = color2;
    }

    public int getOutlineRound() {
        return this.outlineRound;
    }

    public void setOutlineRound(int outlineRound) {
        this.outlineRound = outlineRound;
    }

    public int getPaddingX() {
        return this.paddingX;
    }

    public void setPaddingX(int paddingX) {
        this.paddingX = paddingX;
    }

    public int getPaddingY() {
        return this.paddingY;
    }

    public void setPaddingY(int paddingY) {
        this.paddingY = paddingY;
    }

    public Color getColor1() {
        return this.color1;
    }

    public void setColor1(Color color1) {
        this.color1 = color1;
    }

    public Color getColor2() {
        return this.color2;
    }

    public void setColor2(Color color2) {
        this.color2 = color2;
    }

    public TexturePaint getTexture1() {
        return this.texture1;
    }

    public void setTexture1(TexturePaint texture1) {
        this.texture1 = texture1;
    }

    public TexturePaint getTexture2() {
        return this.texture2;
    }

    public void setTexture2(TexturePaint texture2) {
        this.texture2 = texture2;
    }

    @Override
    public void paintViewBackground(View view, int viewWidth, int viewHeight, Graphics2D g2d) {
        int width = view.getWidth();
        int height = view.getHeight();
        RenderingHints qualityHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        qualityHints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        qualityHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHints(qualityHints);
        RoundRectangle2D.Double roundBackground = new RoundRectangle2D.Double(this.paddingX, this.paddingY, width - 1 - 2 * this.paddingX, height - 1 - 2 * this.paddingY, this.outlineRound, this.outlineRound);
        if (this.texture1 != null) {
            g2d.setPaint(this.texture1);
        } else {
            g2d.setColor(this.color1);
        }
        g2d.fill(roundBackground);
        if (this.texture2 != null) {
            g2d.setPaint(this.texture2);
        } else {
            g2d.setColor(this.color2);
        }
        Rectangle2D.Double rectDevice = new Rectangle2D.Double(view.getPlaceHolderAxisWest(), view.getPlaceHolderAxisNorth(), view.getDevice2D().getWidth(), view.getDevice2D().getHeight());
        g2d.fill(rectDevice);
    }
}

