/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.widget;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class WidgetFolder {
    private String id;
    private int xIndex;
    private int yIndex;
    private boolean lockRollover;
    private boolean lockPress;
    private double x;
    private double y;
    private double width;
    private double height;
    private int guardInterval;
    private PressTimer pressTimer;
    private int currentDragX;
    private int currentDragY;
    private Rectangle currentDragBound;
    private WidgetFolder potentialFolder;
    private WidgetFolder targetFolder;
    private OnPostWidgetListener onPostListener;
    private AsyncPressWidgetCallback asyncCallback;

    public WidgetFolder getTargetFolder() {
        return this.targetFolder;
    }

    public void setTargetFolder(WidgetFolder targetFolder) {
        this.targetFolder = targetFolder;
    }

    public int getCurrentDragX() {
        return this.currentDragX;
    }

    public void setCurrentDragX(int currentDragX) {
        this.currentDragX = currentDragX;
    }

    public int getCurrentDragY() {
        return this.currentDragY;
    }

    public void setCurrentDragY(int currentDragY) {
        this.currentDragY = currentDragY;
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public Rectangle getBounds() {
        return new Rectangle((int)this.getX(), (int)this.getY(), (int)this.getWidth(), (int)this.getHeight());
    }

    public Rectangle getCurentDragBound() {
        return this.currentDragBound;
    }

    public void setCurentDragBound(Rectangle currentDragBound) {
        this.currentDragBound = currentDragBound;
    }

    public WidgetFolder getPotentialFolder() {
        return this.potentialFolder;
    }

    public void setPotentialFolder(WidgetFolder potentialFolder) {
        this.potentialFolder = potentialFolder;
    }

    public void startPress(int delay, AsyncPressWidgetCallback asyncPressCallback) {
        this.setAsyncPressWidgetCallback(asyncPressCallback);
        this.interruptPress();
        this.pressTimer = new PressTimer(delay);
        this.pressTimer.start();
    }

    public OnPostWidgetListener getOnPostListener() {
        return this.onPostListener;
    }

    public void setOnPostListener(OnPostWidgetListener onPostListener) {
        this.onPostListener = onPostListener;
    }

    public AsyncPressWidgetCallback getAsyncPressWidgetCallback() {
        return this.asyncCallback;
    }

    public void setAsyncPressWidgetCallback(AsyncPressWidgetCallback asyncCallback) {
        this.asyncCallback = asyncCallback;
    }

    public void interruptPress() {
        this.setLockPress(false);
        if (this.pressTimer != null && this.pressTimer.isAlive()) {
            this.pressTimer.interrupt();
        }
    }

    public void updateFrame(double x, double y, double width, double height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getGuardInterval() {
        return this.guardInterval;
    }

    public void setGuardInterval(int guardInterval) {
        this.guardInterval = guardInterval;
    }

    public String toString() {
        return "WidgetFolder [xIndex=" + this.xIndex + ", yIndex=" + this.yIndex + ", x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "]";
    }

    public int getxIndex() {
        return this.xIndex;
    }

    public void setxIndex(int xIndex) {
        this.xIndex = xIndex;
    }

    public int getyIndex() {
        return this.yIndex;
    }

    public void setyIndex(int yIndex) {
        this.yIndex = yIndex;
    }

    public Rectangle2D getSensible() {
        return new Rectangle2D.Double(this.x - (double)this.guardInterval, this.y - (double)this.guardInterval, this.width + (double)(2 * this.guardInterval), this.height + (double)(2 * this.guardInterval));
    }

    public boolean intercept(int x, int y) {
        return (double)x > this.x && (double)x < this.x + this.width && (double)y > this.y && (double)y < this.y + this.height;
    }

    public boolean isLockRollover() {
        return this.lockRollover;
    }

    public void setLockRollover(boolean lockRollover) {
        this.lockRollover = lockRollover;
    }

    public boolean isLockPress() {
        return this.lockPress;
    }

    public void setLockPress(boolean lockPress) {
        this.lockPress = lockPress;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    class PressTimer
    extends Thread {
        private long timeInMillis;
        private long startTime;
        private int delay;
        private boolean press;

        public PressTimer(int delay) {
            this.delay = delay;
        }

        @Override
        public void run() {
            this.startTime = System.currentTimeMillis();
            try {
                while (!PressTimer.interrupted() && !this.press) {
                    Thread.sleep(100L);
                    this.timeInMillis = System.currentTimeMillis();
                    if (this.timeInMillis - this.startTime <= (long)this.delay) continue;
                    WidgetFolder.this.setLockPress(true);
                    WidgetFolder.this.asyncCallback.folderPress();
                    this.press = true;
                }
            }
            catch (InterruptedException e) {
                WidgetFolder.this.setLockPress(false);
                WidgetFolder.this.setLockRollover(false);
                Thread.currentThread().interrupt();
            }
        }
    }

    public static interface AsyncPressWidgetCallback {
        public void folderPress();
    }

    public static interface OnPostWidgetListener {
        public void onPostWidget();
    }
}

