/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.widget.bar;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.view.View;
import org.jensoft.core.widget.Widget;
import org.jensoft.core.widget.WidgetFolder;
import org.jensoft.core.widget.bar.AbstractBarGeometry;

public abstract class AbstractBarWidget<P extends AbstractPlugin>
extends Widget<P> {
    public static final String ID = "@widget/core/abstractbarwidget";
    private AbstractBarGeometry geometry;
    private Stroke defaultStroke = new BasicStroke(2.0f, 1, 2);
    private Stroke basicStroke = new BasicStroke(1.0f);
    private AbstractBarGeometry.BarWidgetOrientation barWidgetOrientation;
    private Color fillColor;
    private float[] shadeFractions;
    private Color[] shadeColors;
    private Color outlineColor;
    private Stroke outlineStroke;
    private Color button1FillColor;
    private Color button2FillColor;
    private Color button1DrawColor;
    private Color button2DrawColor;
    private Color button1RolloverFillColor;
    private Color button2RolloverFillColor;
    private Color button1RolloverDrawColor;
    private Color button2RolloverDrawColor;
    private boolean button1Visible = true;
    private boolean button2Visible = true;

    public AbstractBarWidget(AbstractBarGeometry geometry, AbstractBarGeometry.BarWidgetOrientation barWidgetOrientation) {
        super(ID, 80.0, 18.0, 2, 100);
        this.barWidgetOrientation = barWidgetOrientation;
        this.geometry = geometry;
    }

    public AbstractBarWidget(String id, double width, double height, int xIndex, int yIndex, AbstractBarGeometry geometry, AbstractBarGeometry.BarWidgetOrientation barWidgetOrientation) {
        super(id, width, height, xIndex, yIndex);
        this.barWidgetOrientation = barWidgetOrientation;
        this.geometry = geometry;
    }

    public Color getButton1RolloverFillColor() {
        return this.button1RolloverFillColor;
    }

    public void setButton1RolloverFillColor(Color button1RolloverFillColor) {
        this.button1RolloverFillColor = button1RolloverFillColor;
    }

    public Color getButton2RolloverFillColor() {
        return this.button2RolloverFillColor;
    }

    public void setButton2RolloverFillColor(Color button2RolloverFillColor) {
        this.button2RolloverFillColor = button2RolloverFillColor;
    }

    public void setButtonRolloverFillColor(Color buttonRolloverFillColor) {
        this.button1RolloverFillColor = buttonRolloverFillColor;
        this.button2RolloverFillColor = buttonRolloverFillColor;
    }

    public Color getButton1RolloverDrawColor() {
        return this.button1RolloverDrawColor;
    }

    public void setButton1RolloverDrawColor(Color button1RolloverDrawColor) {
        this.button1RolloverDrawColor = button1RolloverDrawColor;
    }

    public Color getButton2RolloverDrawColor() {
        return this.button2RolloverDrawColor;
    }

    public void setButton2RolloverDrawColor(Color button2RolloverDrawColor) {
        this.button2RolloverDrawColor = button2RolloverDrawColor;
    }

    public void setButtonRolloverDrawColor(Color buttonRolloverDrawColor) {
        this.button1RolloverDrawColor = buttonRolloverDrawColor;
        this.button2RolloverDrawColor = buttonRolloverDrawColor;
    }

    public Color getButton1FillColor() {
        return this.button1FillColor;
    }

    public void setButton1FillColor(Color button1FillColor) {
        this.button1FillColor = button1FillColor;
    }

    public Color getButton2FillColor() {
        return this.button2FillColor;
    }

    public void setButton2FillColor(Color button2FillColor) {
        this.button2FillColor = button2FillColor;
    }

    public void setButtonFillColor(Color buttonFillColor) {
        this.button1FillColor = buttonFillColor;
        this.button2FillColor = buttonFillColor;
    }

    public Color getButton1DrawColor() {
        return this.button1DrawColor;
    }

    public void setButton1DrawColor(Color button1DrawColor) {
        this.button1DrawColor = button1DrawColor;
    }

    public Color getButton2DrawColor() {
        return this.button2DrawColor;
    }

    public void setButton2DrawColor(Color button2DrawColor) {
        this.button2DrawColor = button2DrawColor;
    }

    public void setButtonDrawColor(Color buttonDrawColor) {
        this.button1DrawColor = buttonDrawColor;
        this.button2DrawColor = buttonDrawColor;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public float[] getShadeFractions() {
        return this.shadeFractions;
    }

    public Color[] getShadeColors() {
        return this.shadeColors;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke outlineStroke) {
        this.outlineStroke = outlineStroke;
    }

    public void setShader(float[] fractions, Color[] colors) {
        if (fractions.length != colors.length) {
            throw new IllegalArgumentException("length array does not match");
        }
        this.shadeFractions = fractions;
        this.shadeColors = colors;
    }

    public void setShader(Shader shader) {
        this.shadeFractions = shader.getFractions();
        this.shadeColors = shader.getColors();
    }

    public AbstractBarGeometry.BarWidgetOrientation getBarWidgetOrientation() {
        return this.barWidgetOrientation;
    }

    public boolean isButton1Visible() {
        return this.button1Visible;
    }

    public void setButton1Visible(boolean button1Visible) {
        this.button1Visible = button1Visible;
    }

    public boolean isButton2Visible() {
        return this.button2Visible;
    }

    public void setButton2Visible(boolean button2Visible) {
        this.button2Visible = button2Visible;
    }

    public AbstractBarGeometry getGeometry() {
        return this.geometry;
    }

    @Override
    public void interceptMove(int x, int y) {
        super.interceptMove(x, y);
        if (this.getWidgetFolder() == null) {
            return;
        }
        if (!this.getWidgetFolder().getBounds2D().contains(x, y)) {
            this.geometry.setRollover1(false);
            this.geometry.setRollover2(false);
            this.onButton1RolloverOff();
            this.onButton2RolloverOff();
            return;
        }
        this.checkMoveOperation(x, y);
        this.trackRollover(x, y);
    }

    private void trackRollover(int x, int y) {
        if (this.geometry.getRect1() != null && this.geometry.getRect1().contains(x, y)) {
            if (!this.geometry.isRollover1()) {
                this.geometry.setRollover1(true);
                this.onButton1RolloverOn();
            }
        } else if (this.geometry.isRollover1()) {
            this.geometry.setRollover1(false);
            this.onButton1RolloverOff();
        }
        if (this.geometry.getRect2() != null && this.geometry.getRect2().contains(x, y)) {
            if (!this.geometry.isRollover2()) {
                this.geometry.setRollover2(true);
                this.onButton2RolloverOn();
            }
        } else if (this.geometry.isRollover2()) {
            this.geometry.setRollover2(false);
            this.onButton2RolloverOff();
        }
    }

    public void onButton1RolloverOn() {
        this.repaintButton1();
    }

    public void onButton1RolloverOff() {
        this.repaintButton1();
    }

    public void onButton2RolloverOn() {
        this.repaintButton2();
    }

    public void onButton2RolloverOff() {
        this.repaintButton2();
    }

    public void onButton1Press() {
        this.repaintButton1();
    }

    public void onButton2Press() {
        this.repaintButton2();
    }

    public void onButton1Released() {
        this.repaintButton1();
    }

    public void onButton2Released() {
        this.repaintButton2();
    }

    public void repaintButton1() {
        if (this.geometry == null || this.geometry.getRect1() == null) {
            return;
        }
        ((AbstractPlugin)this.getHost()).getProjection().getView().repaintDevice(this.geometry.getRect1().getBounds());
    }

    public void repaintButton2() {
        if (this.geometry == null || this.geometry.getRect1() == null) {
            return;
        }
        ((AbstractPlugin)this.getHost()).getProjection().getView().repaintDevice(this.geometry.getRect2().getBounds());
    }

    @Override
    public void interceptPress(int x, int y) {
        super.interceptPress(x, y);
        if (!((AbstractPlugin)this.getHost()).isLockSelected() && this.isOrphanLock()) {
            return;
        }
        if (this.geometry.getRect1() != null && this.geometry.getRect1().contains(x, y)) {
            this.onButton1Press();
        }
        if (this.geometry.getRect2() != null && this.geometry.getRect2().contains(x, y)) {
            this.onButton2Press();
        }
    }

    @Override
    public void interceptDrag(int x, int y) {
        super.interceptDrag(x, y);
    }

    @Override
    public void interceptReleased(int x, int y) {
        super.interceptReleased(x, y);
        this.onButton1Released();
        this.onButton2Released();
    }

    public void onPaintStart() {
    }

    public void onPaintEnd() {
    }

    @Override
    protected void paintWidget(View v2d, Graphics2D g2d) {
        if (this.getWidgetFolder() == null || this.geometry == null) {
            return;
        }
        this.onPaintStart();
        WidgetFolder currentFolder = this.getWidgetFolder();
        Rectangle2D boundFolder = currentFolder.getBounds2D();
        this.geometry.setSolveRequest(true);
        this.geometry.solveGeometry(boundFolder);
        this.setSensibleShapes(this.geometry.getSensibleShapes());
        if (this.shadeFractions != null && this.shadeColors != null) {
            Point2D.Double start = null;
            Point2D.Double end = null;
            if (this.getBarWidgetOrientation() == AbstractBarGeometry.BarWidgetOrientation.Horizontal) {
                start = new Point2D.Double(boundFolder.getCenterX(), boundFolder.getY());
                end = new Point2D.Double(boundFolder.getCenterX(), boundFolder.getY() + boundFolder.getHeight());
            } else {
                start = new Point2D.Double(boundFolder.getX(), boundFolder.getCenterY());
                end = new Point2D.Double(boundFolder.getX() + boundFolder.getWidth(), boundFolder.getCenterY());
            }
            LinearGradientPaint lgp = new LinearGradientPaint(start, end, this.shadeFractions, this.shadeColors);
            g2d.setPaint(lgp);
            g2d.fill(this.geometry.getOutlineShape());
        }
        if (this.outlineColor != null) {
            g2d.setColor(this.outlineColor);
            if (this.outlineStroke != null) {
                g2d.setStroke(this.outlineStroke);
            }
            g2d.draw(this.geometry.getOutlineShape());
            g2d.setStroke(this.basicStroke);
        }
        if (this.button1Visible) {
            g2d.setStroke(this.defaultStroke);
            if (this.geometry.isRollover1()) {
                if (this.button1RolloverFillColor != null) {
                    g2d.setColor(this.button1RolloverFillColor);
                    g2d.fill(this.geometry.getButton1());
                }
            } else if (this.button1FillColor != null) {
                g2d.setColor(this.button1FillColor);
                g2d.fill(this.geometry.getButton1());
            }
        }
        if (this.button2Visible) {
            g2d.setStroke(this.defaultStroke);
            if (this.geometry.isRollover2()) {
                if (this.button2RolloverFillColor != null) {
                    g2d.setColor(this.button2RolloverFillColor);
                    g2d.fill(this.geometry.getButton2());
                }
            } else if (this.button2FillColor != null) {
                g2d.setColor(this.button2FillColor);
                g2d.fill(this.geometry.getButton2());
            }
        }
        if (this.button1Visible) {
            g2d.setStroke(this.defaultStroke);
            if (this.geometry.isRollover1()) {
                if (this.button1RolloverDrawColor != null) {
                    g2d.setColor(this.button1RolloverDrawColor);
                    g2d.draw(this.geometry.getButton1());
                }
            } else if (this.button1DrawColor != null) {
                g2d.setColor(this.button1DrawColor);
                g2d.draw(this.geometry.getButton1());
            }
        }
        if (this.button2Visible) {
            g2d.setStroke(this.defaultStroke);
            if (this.geometry.isRollover2()) {
                if (this.button2RolloverDrawColor != null) {
                    g2d.setColor(this.button2RolloverDrawColor);
                    g2d.draw(this.geometry.getButton2());
                }
            } else if (this.button2DrawColor != null) {
                g2d.setColor(this.button2DrawColor);
                g2d.draw(this.geometry.getButton2());
            }
        }
        this.onPaintEnd();
    }
}

