/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.widget.button;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.view.View;
import org.jensoft.core.widget.Widget;
import org.jensoft.core.widget.WidgetFolder;

public abstract class AbstractButtonWidget<P extends AbstractPlugin>
extends Widget<P> {
    private boolean lockEnter = false;

    public AbstractButtonWidget(String id, double width, double height, int xIndex, int yIndex) {
        super(id, width, height, xIndex, yIndex);
    }

    public boolean isLockEnter() {
        return this.lockEnter;
    }

    public void lockEnter() {
        this.lockEnter = true;
    }

    public void unlockEnter() {
        this.lockEnter = false;
    }

    public void onPress() {
    }

    public void onRelease() {
    }

    public void onEnter() {
    }

    public void onExit() {
    }

    private void trackRollover(int x, int y) {
        WidgetFolder folder = this.getWidgetFolder();
        if (folder == null) {
            return;
        }
        Rectangle2D bound = folder.getBounds2D();
        if (bound != null && bound.contains(x, y)) {
            if (!this.isLockEnter()) {
                this.lockEnter();
                this.onEnter();
            }
        } else if (this.isLockEnter()) {
            this.unlockEnter();
            this.onExit();
        }
    }

    @Override
    public void interceptMove(int x, int y) {
        super.interceptMove(x, y);
        this.trackRollover(x, y);
    }

    @Override
    public void interceptPress(int x, int y) {
        super.interceptPress(x, y);
        if (!this.isLockEnter()) {
            return;
        }
        WidgetFolder folder = this.getWidgetFolder();
        if (folder == null) {
            return;
        }
        Rectangle2D bound = folder.getBounds2D();
        if (bound != null && bound.contains(x, y)) {
            this.onPress();
        }
    }

    @Override
    public void interceptDrag(int x, int y) {
        super.interceptDrag(x, y);
    }

    @Override
    public void interceptReleased(int x, int y) {
        super.interceptReleased(x, y);
        if (!this.isLockEnter()) {
            return;
        }
        this.onRelease();
    }

    public abstract void paintButton(View var1, Graphics2D var2, Rectangle2D var3);

    @Override
    public final void paintWidget(View v2d, Graphics2D g2d) {
        Rectangle2D rect = this.getWidgetFolder().getBounds2D();
        if (rect != null) {
            this.paintButton(v2d, g2d, rect);
        }
    }
}

