/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.widget.button;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.pie.painter.label.AbstractPieSliceLabel;
import org.jensoft.core.view.View;
import org.jensoft.core.widget.button.AbstractButtonWidget;

public class ButtonWidget<P extends AbstractPlugin>
extends AbstractButtonWidget<P> {
    private int outlineRound = 4;
    private Color outlineColor;
    private Stroke outlineStroke;
    private Color fillColor;
    private float[] shadeFractions;
    private Color[] shadeColors;
    private Stroke defaultStroke = new BasicStroke();
    private AbstractPieSliceLabel.Style style = AbstractPieSliceLabel.Style.Both;

    public ButtonWidget(String id, double width, double height, int xIndex, int yIndex) {
        super(id, width, height, xIndex, yIndex);
    }

    public int getOutlineRound() {
        return this.outlineRound;
    }

    public void setOutlineRound(int outlineRound) {
        this.outlineRound = outlineRound;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke outlineStroke) {
        this.outlineStroke = outlineStroke;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public AbstractPieSliceLabel.Style getStyle() {
        return this.style;
    }

    public void setStyle(AbstractPieSliceLabel.Style style) {
        this.style = style;
    }

    public void setShader(float[] fractions, Color[] colors) {
        if (fractions.length != colors.length) {
            throw new IllegalArgumentException("length array does not match");
        }
        this.shadeFractions = fractions;
        this.shadeColors = colors;
    }

    public void setShader(Shader shader) {
        this.shadeFractions = shader.getFractions();
        this.shadeColors = shader.getColors();
    }

    public float[] getShadeFractions() {
        return this.shadeFractions;
    }

    public Color[] getShadeColors() {
        return this.shadeColors;
    }

    @Override
    public void paintButton(View v2d, Graphics2D g2d, Rectangle2D buttonDrawingRegion) {
        double x = buttonDrawingRegion.getX();
        double y = buttonDrawingRegion.getY();
        double width = buttonDrawingRegion.getWidth();
        double height = buttonDrawingRegion.getHeight();
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(x, y, width, height, this.outlineRound, this.outlineRound);
        if (this.style == AbstractPieSliceLabel.Style.Fill || this.style == AbstractPieSliceLabel.Style.Both) {
            Point2D.Double end2;
            Point2D.Double start2;
            if (this.fillColor != null && this.shadeFractions == null) {
                g2d.setColor(this.fillColor);
                g2d.fill(rect);
            }
            if (this.shadeFractions != null && this.shadeColors != null && !(start2 = new Point2D.Double(((RectangularShape)rect).getX(), ((RectangularShape)rect).getY() + ((RectangularShape)rect).getHeight())).equals(end2 = new Point2D.Double(((RectangularShape)rect).getX(), ((RectangularShape)rect).getY()))) {
                LinearGradientPaint p2 = new LinearGradientPaint(start2, end2, this.shadeFractions, this.shadeColors);
                g2d.setPaint(p2);
                g2d.fill(rect);
            }
        }
        if ((this.style == AbstractPieSliceLabel.Style.Stroke || this.style == AbstractPieSliceLabel.Style.Both) && this.outlineColor != null) {
            if (this.outlineStroke != null) {
                g2d.setStroke(this.outlineStroke);
            }
            g2d.setColor(this.outlineColor);
            g2d.draw(rect);
            g2d.setStroke(this.defaultStroke);
        }
    }

    @Override
    public boolean isCompatiblePlugin() {
        return false;
    }
}

