/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.widget.button;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import org.jensoft.core.device.DevicePartComponent;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.view.View;
import org.jensoft.core.widget.button.ButtonWidget;
import org.jensoft.core.widget.button.PullItem;

public class PullDownButtonWidget<P extends AbstractPlugin>
extends ButtonWidget<P> {
    public static final String ID = "@widget/core/pulldownwidget";
    private PullOrderComparator pullComparator = new PullOrderComparator();
    private int pullInsetX = 5;
    private int pullInsetY = 7;
    private Rectangle2D pullFrame;
    private Rectangle2D sensiblePull;
    private GeneralPath pullPath;
    private List<PullItem> actionItems = new ArrayList<PullItem>();
    private Rectangle2D rectItemRegion;
    private int regionInsetX = 8;
    private int regionInsetY = 3;
    private Stroke defaultStroke = new BasicStroke();
    private Color pullDrawColor;
    private Color pullFillColor = Color.DARK_GRAY;
    private int pressX;
    private int pressY;

    public PullDownButtonWidget(String id, double width, double height, int xIndex, int yIndex) {
        super(id, width, height, xIndex, yIndex);
    }

    public void updatePull(PullItem pullItem) {
        int maxOrder = pullItem.getOrder();
        for (PullItem item : this.actionItems) {
            if (item.getOrder() <= maxOrder) continue;
            maxOrder = item.getOrder();
        }
        pullItem.setOrder(maxOrder + 2);
    }

    public void sortPull() {
        Collections.sort(this.actionItems, this.pullComparator);
    }

    public void addPullAction(PullItem actionItem) {
        actionItem.setPullDownWidget(this);
        this.actionItems.add(actionItem);
    }

    @Override
    public void interceptPress(int x, int y) {
        this.pressX = x;
        this.pressY = y;
        super.interceptPress(x, y);
    }

    private void pullDown() {
        JPopupMenu popup = ((AbstractPlugin)this.getHost()).getProjection().getDevice2D().getDeviceMenuManager().getContextMenu();
        popup.removeAll();
        this.sortPull();
        for (PullItem actionItem : this.actionItems) {
            popup.add(actionItem.getPullEntry());
        }
        int x = (int)this.getWidgetFolder().getX();
        int y = (int)this.getWidgetFolder().getY();
        DevicePartComponent device = ((AbstractPlugin)this.getHost()).getProjection().getView().getDevice2D();
        popup.show(device, x, y + (int)this.getWidgetFolder().getHeight());
    }

    @Override
    public void onPress() {
        super.onPress();
        if (this.sensiblePull.contains(this.pressX, this.pressY)) {
            this.pullDown();
        } else if (this.rectItemRegion.contains(this.pressX, this.pressY)) {
            this.sortPull();
            if (this.actionItems.size() > 0) {
                PullItem item = this.actionItems.get(0);
                item.getPullEntry().doClick();
            }
        }
    }

    public Color getPullDrawColor() {
        return this.pullDrawColor;
    }

    public void setPullDrawColor(Color pullDrawColor) {
        this.pullDrawColor = pullDrawColor;
    }

    public Color getPullFillColor() {
        return this.pullFillColor;
    }

    public void setPullFillColor(Color pullFillColor) {
        this.pullFillColor = pullFillColor;
    }

    public void paintItemButton(View v2d, Graphics2D g2d, Rectangle2D itemRegion) {
        this.sortPull();
        if (this.actionItems.size() > 0) {
            PullItem item = this.actionItems.get(0);
            ImageIcon icon = item.getPullIcon();
            if ((double)icon.getIconWidth() > itemRegion.getWidth() && (double)icon.getIconHeight() > itemRegion.getHeight()) {
                g2d.drawImage(icon.getImage(), (int)itemRegion.getX(), (int)itemRegion.getY(), (int)itemRegion.getWidth(), (int)itemRegion.getHeight(), null);
            } else if ((double)icon.getIconWidth() > itemRegion.getWidth() && !((double)icon.getIconHeight() > itemRegion.getHeight())) {
                g2d.drawImage(icon.getImage(), (int)itemRegion.getX(), (int)(itemRegion.getY() + itemRegion.getHeight() / 2.0 - (double)(icon.getIconHeight() / 2)), (int)itemRegion.getWidth(), icon.getIconHeight(), null);
            } else if (!((double)icon.getIconWidth() > itemRegion.getWidth()) && (double)icon.getIconHeight() > itemRegion.getHeight()) {
                g2d.drawImage(icon.getImage(), (int)(itemRegion.getX() + itemRegion.getWidth() / 2.0 - (double)(icon.getIconWidth() / 2)), (int)itemRegion.getY(), icon.getIconWidth(), (int)itemRegion.getHeight(), null);
            } else {
                g2d.drawImage(icon.getImage(), (int)(itemRegion.getX() + itemRegion.getWidth() / 2.0 - (double)(icon.getIconWidth() / 2)), (int)(itemRegion.getY() + itemRegion.getHeight() / 2.0 - (double)(icon.getIconHeight() / 2)), icon.getIconWidth(), icon.getIconHeight(), null);
            }
        }
    }

    @Override
    public void paintButton(View v2d, Graphics2D g2d, Rectangle2D buttonDrawingRegion) {
        super.paintButton(v2d, g2d, buttonDrawingRegion);
        Rectangle2D r = buttonDrawingRegion;
        double squarePull = r.getHeight() - (double)(2 * this.pullInsetY);
        this.pullFrame = new Rectangle2D.Double(r.getX() + r.getWidth() - (double)this.pullInsetX - squarePull, r.getY() + (double)this.pullInsetY, squarePull, squarePull);
        this.pullPath = new GeneralPath();
        this.pullPath.moveTo(this.pullFrame.getX(), this.pullFrame.getY());
        this.pullPath.lineTo(this.pullFrame.getX() + this.pullFrame.getWidth(), this.pullFrame.getY());
        this.pullPath.lineTo(this.pullFrame.getX() + this.pullFrame.getWidth() / 2.0, this.pullFrame.getY() + this.pullFrame.getHeight());
        this.pullPath.closePath();
        if (this.pullFillColor != null) {
            g2d.setColor(this.pullFillColor);
            g2d.fill(this.pullPath);
        }
        if (this.pullDrawColor != null) {
            g2d.setColor(this.pullDrawColor);
            g2d.setStroke(this.defaultStroke);
            g2d.draw(this.pullPath);
        }
        double x1 = this.pullFrame.getX() - (double)this.pullInsetX;
        double y1 = r.getY();
        double x2 = this.pullFrame.getX() - (double)this.pullInsetX;
        double y2 = r.getY() + r.getHeight();
        if (this.getOutlineColor() != null) {
            g2d.setColor(this.getOutlineColor());
            if (this.getOutlineStroke() != null) {
                g2d.setStroke(this.getOutlineStroke());
            }
            g2d.draw(new Line2D.Double(x1, y1 + 2.0, x2, y2 - 2.0));
        }
        this.sensiblePull = new Rectangle2D.Double(x1, y1, Math.abs(r.getX() + r.getWidth() - x1), r.getHeight());
        this.rectItemRegion = new Rectangle2D.Double(r.getX() + (double)this.regionInsetX, r.getY() + (double)this.regionInsetY, Math.abs(r.getX() - x1) - (double)(2 * this.regionInsetX), r.getHeight() - (double)(2 * this.regionInsetY));
        this.clearSensibleShape();
        this.addSensibleShape(this.sensiblePull);
        this.addSensibleShape(this.rectItemRegion);
        this.paintItemButton(v2d, g2d, this.rectItemRegion);
        g2d.setColor(Color.RED);
        g2d.setColor(Color.CYAN);
    }

    class PullOrderComparator
    implements Comparator<PullItem> {
        @Override
        public int compare(PullItem pi1, PullItem pi2) {
            if (pi1.getOrder() > pi2.getOrder()) {
                return -1;
            }
            if (pi1.getOrder() < pi2.getOrder()) {
                return 1;
            }
            return 0;
        }
    }
}

