/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.widget.pad;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.jensoft.core.widget.AbstractWidgetGeometry;

public abstract class AbstractPadGeometry
extends AbstractWidgetGeometry {
    private Rectangle2D bound2D;
    private double centerX;
    private double centerY;
    private double radius;
    private double fragmentRadius;
    private Ellipse2D baseShape;
    private GeneralPath controlShape;
    private Rectangle2D rectNorth;
    private Rectangle2D rectSouth;
    private Rectangle2D rectWest;
    private Rectangle2D rectEast;
    private Shape northButton;
    private Shape eastButton;
    private Shape southButton;
    private Shape westButton;
    private boolean northRollover = false;
    private boolean eastRollover = false;
    private boolean southRollover = false;
    private boolean westRollover = false;
    private int inset = 6;
    private boolean solveRequest = true;

    public boolean isSolveRequest() {
        return this.solveRequest;
    }

    public void setSolveRequest(boolean solveRequest) {
        this.solveRequest = solveRequest;
    }

    public final void solvePadGeometry() {
        this.baseShape = new Ellipse2D.Double(this.centerX - this.radius, this.centerY - this.radius, 2.0 * this.radius, 2.0 * this.radius);
        this.controlShape = new GeneralPath();
        this.controlShape.moveTo(this.centerX - this.fragmentRadius, this.centerY - this.fragmentRadius);
        this.controlShape.lineTo(this.centerX - this.fragmentRadius, this.centerY - 2.0 * this.fragmentRadius);
        this.controlShape.curveTo(this.centerX - this.fragmentRadius, this.centerY - this.radius, this.centerX + this.fragmentRadius, this.centerY - this.radius, this.centerX + this.fragmentRadius, this.centerY - 2.0 * this.fragmentRadius);
        this.controlShape.lineTo(this.centerX + this.fragmentRadius, this.centerY - this.fragmentRadius);
        this.controlShape.lineTo(this.centerX + 2.0 * this.fragmentRadius, this.centerY - this.fragmentRadius);
        this.controlShape.curveTo(this.centerX + this.radius, this.centerY - this.fragmentRadius, this.centerX + this.radius, this.centerY + this.fragmentRadius, this.centerX + 2.0 * this.fragmentRadius, this.centerY + this.fragmentRadius);
        this.controlShape.lineTo(this.centerX + this.fragmentRadius, this.centerY + this.fragmentRadius);
        this.controlShape.lineTo(this.centerX + this.fragmentRadius, this.centerY + 2.0 * this.fragmentRadius);
        this.controlShape.curveTo(this.centerX + this.fragmentRadius, this.centerY + this.radius, this.centerX - this.fragmentRadius, this.centerY + this.radius, this.centerX - this.fragmentRadius, this.centerY + 2.0 * this.fragmentRadius);
        this.controlShape.lineTo(this.centerX - this.fragmentRadius, this.centerY + this.fragmentRadius);
        this.controlShape.lineTo(this.centerX - 2.0 * this.fragmentRadius, this.centerY + this.fragmentRadius);
        this.controlShape.curveTo(this.centerX - this.radius, this.centerY + this.fragmentRadius, this.centerX - this.radius, this.centerY - this.fragmentRadius, this.centerX - 2.0 * this.fragmentRadius, this.centerY - this.fragmentRadius);
        this.controlShape.closePath();
        this.rectNorth = new Rectangle2D.Double(this.centerX - this.fragmentRadius + (double)this.inset, this.centerY - 3.0 * this.fragmentRadius + (double)this.inset, 2.0 * this.fragmentRadius - (double)(2 * this.inset), 2.0 * this.fragmentRadius - (double)(2 * this.inset));
        this.rectSouth = new Rectangle2D.Double(this.centerX - this.fragmentRadius + (double)this.inset, this.centerY + this.fragmentRadius + (double)this.inset, 2.0 * this.fragmentRadius - (double)(2 * this.inset), 2.0 * this.fragmentRadius - (double)(2 * this.inset));
        this.rectWest = new Rectangle2D.Double(this.centerX - 3.0 * this.fragmentRadius + (double)this.inset, this.centerY - this.fragmentRadius + (double)this.inset, 2.0 * this.fragmentRadius - (double)(2 * this.inset), 2.0 * this.fragmentRadius - (double)(2 * this.inset));
        this.rectEast = new Rectangle2D.Double(this.centerX + this.fragmentRadius + (double)this.inset, this.centerY - this.fragmentRadius + (double)this.inset, 2.0 * this.fragmentRadius - (double)(2 * this.inset), 2.0 * this.fragmentRadius - (double)(2 * this.inset));
        this.clearSensibleShape();
        this.addSensibleShape(this.rectNorth);
        this.addSensibleShape(this.rectSouth);
        this.addSensibleShape(this.rectWest);
        this.addSensibleShape(this.rectEast);
    }

    abstract void solveButtonNorthGeometry(Rectangle2D var1);

    abstract void solveButtonSouthGeometry(Rectangle2D var1);

    abstract void solveButtonWestGeometry(Rectangle2D var1);

    abstract void solveButtonEastGeometry(Rectangle2D var1);

    @Override
    public final void solveGeometry(Rectangle2D bound2D) {
        if (this.solveRequest) {
            this.bound2D = bound2D;
            this.centerX = bound2D.getCenterX();
            this.centerY = bound2D.getCenterY();
            this.radius = bound2D.getWidth() / 2.0;
            this.fragmentRadius = new Double(this.radius) / 3.0;
            this.solvePadGeometry();
            this.solveButtonNorthGeometry(this.rectNorth);
            this.solveButtonSouthGeometry(this.rectSouth);
            this.solveButtonWestGeometry(this.rectWest);
            this.solveButtonEastGeometry(this.rectEast);
            this.solveRequest = false;
        }
    }

    public Rectangle2D getBound2D() {
        return this.bound2D;
    }

    public void setBound2D(Rectangle2D bound2d) {
        Rectangle2D oldBound = this.bound2D;
        this.bound2D = bound2d;
        if (!oldBound.equals(bound2d)) {
            this.solveRequest = true;
        }
    }

    public Ellipse2D getBaseShape() {
        return this.baseShape;
    }

    public void setBaseShape(Ellipse2D baseShape) {
        this.baseShape = baseShape;
    }

    public GeneralPath getControlShape() {
        return this.controlShape;
    }

    public void setControlShape(GeneralPath controlShape) {
        this.controlShape = controlShape;
    }

    public Rectangle2D getRectNorth() {
        return this.rectNorth;
    }

    public void setRectNorth(Rectangle2D rectNorth) {
        this.rectNorth = rectNorth;
    }

    public Rectangle2D getRectSouth() {
        return this.rectSouth;
    }

    public void setRectSouth(Rectangle2D rectSouth) {
        this.rectSouth = rectSouth;
    }

    public Rectangle2D getRectWest() {
        return this.rectWest;
    }

    public void setRectWest(Rectangle2D rectWest) {
        this.rectWest = rectWest;
    }

    public Rectangle2D getRectEast() {
        return this.rectEast;
    }

    public void setRectEast(Rectangle2D rectEast) {
        this.rectEast = rectEast;
    }

    public Shape getNorthButton() {
        return this.northButton;
    }

    public void setNorthButton(Shape northButton) {
        this.northButton = northButton;
    }

    public Shape getEastButton() {
        return this.eastButton;
    }

    public void setEastButton(Shape eastButton) {
        this.eastButton = eastButton;
    }

    public Shape getSouthButton() {
        return this.southButton;
    }

    public void setSouthButton(Shape southButton) {
        this.southButton = southButton;
    }

    public Shape getWestButton() {
        return this.westButton;
    }

    public void setWestButton(Shape westButton) {
        this.westButton = westButton;
    }

    public boolean isNorthRollover() {
        return this.northRollover;
    }

    public void setNorthRollover(boolean northRollover) {
        this.northRollover = northRollover;
    }

    public boolean isEastRollover() {
        return this.eastRollover;
    }

    public void setEastRollover(boolean eastRollover) {
        this.eastRollover = eastRollover;
    }

    public boolean isSouthRollover() {
        return this.southRollover;
    }

    public void setSouthRollover(boolean southRollover) {
        this.southRollover = southRollover;
    }

    public boolean isWestRollover() {
        return this.westRollover;
    }

    public void setWestRollover(boolean westRollover) {
        this.westRollover = westRollover;
    }

    public int getInset() {
        return this.inset;
    }

    public void setInset(int inset) {
        this.inset = inset;
    }
}

