/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.x2d.binding;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.plugin.AbstractPlugin;
import org.jensoft.core.plugin.PluginPlatform;
import org.jensoft.core.projection.Projection;
import org.jensoft.core.view.View;
import org.jensoft.core.view.background.ViewBackgroundPainter;
import org.jensoft.core.view.background.ViewDefaultBackground;
import org.jensoft.core.x2d.X2DException;
import org.jensoft.core.x2d.binding.AbstractX2DPluginInflater;
import org.jensoft.core.x2d.binding.InflaterUtil;
import org.jensoft.core.x2d.binding.X2DBinding;
import org.jensoft.core.x2d.lang.X2DViewElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class X2DViewInflater
implements X2DViewElement {
    private Document x2dDocument;
    private Element viewRoot;
    private View view2D;
    private List<AbstractX2DPluginInflater<?>> inflaters = new ArrayList();

    public X2DViewInflater() {
        System.err.println("--X2DViewInflater--");
    }

    public void setX2D(Document x2dDocument) {
        this.x2dDocument = x2dDocument;
        this.viewRoot = x2dDocument.getDocumentElement();
    }

    public View inflate() throws X2DException {
        this.view2D = this.generateView2D();
        return this.view2D;
    }

    protected void initCoreInflater() {
        System.err.println("--initCoreInflater--");
        List<Class<?>> inflaters = PluginPlatform.scanX2DInflater(X2DBinding.class.getPackage().getName());
        for (Class<?> inflaterClass : inflaters) {
            try {
                AbstractX2DPluginInflater inflater = (AbstractX2DPluginInflater)inflaterClass.newInstance();
                this.registerInflater(inflater);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public List<AbstractX2DPluginInflater<?>> getInflaters() {
        return this.inflaters;
    }

    public void setInflaters(List<AbstractX2DPluginInflater<?>> inflaters) {
        this.inflaters = inflaters;
    }

    public void registerInflater(AbstractX2DPluginInflater<?> inflater) {
        if (inflater.getBinding().xsi() == null) {
            throw new IllegalArgumentException("X2D Binding Error, XSI Type for Inflater :" + inflater.getClass() + " is null. it should be provided");
        }
        System.err.println("--registerInflater::" + inflater.getClass());
        this.inflaters.add(inflater);
    }

    public String getViewKey() {
        Element e = (Element)this.viewRoot.getElementsByTagName("view-key").item(0);
        String imageID = e.getTextContent().trim();
        return imageID;
    }

    public String getAPIKey() {
        Element e = (Element)this.viewRoot.getElementsByTagName("api-key").item(0);
        String apiKey = e.getTextContent().trim();
        return apiKey;
    }

    public int getWidth() {
        Element e = (Element)this.viewRoot.getElementsByTagName("width").item(0);
        String width = e.getTextContent().trim();
        return Integer.parseInt(width);
    }

    public int getHeight() {
        Element e = (Element)this.viewRoot.getElementsByTagName("height").item(0);
        String height = e.getTextContent().trim();
        return Integer.parseInt(height);
    }

    protected AbstractX2DPluginInflater<?> lookupType(String xsiType) {
        for (AbstractX2DPluginInflater<?> inflater : this.inflaters) {
            if (inflater.getXSIType() == null || !inflater.getXSIType().equals(xsiType)) continue;
            return inflater;
        }
        return null;
    }

    protected AbstractX2DPluginInflater<?> lookupTypeClass(String xsiType, String typeClass) {
        for (AbstractX2DPluginInflater<?> inflater : this.inflaters) {
            if (inflater.getXSIType() == null || !inflater.getXSIType().equals(xsiType) || !inflater.getBinding().plugin().getName().equals(typeClass)) continue;
            return inflater;
        }
        return null;
    }

    public ViewBackgroundPainter parseBackground(Element background) {
        if (background == null) {
            return null;
        }
        ViewDefaultBackground roundView = null;
        try {
            Stroke stroke;
            Shader shader;
            roundView = new ViewDefaultBackground();
            String outlineround = background.getElementsByTagName("outline-round").item(0).getTextContent();
            Element outlinecolorElement = (Element)background.getElementsByTagName("outline-color").item(0);
            Element shaderElement = (Element)background.getElementsByTagName("background-shader").item(0);
            Element strokeElement = (Element)background.getElementsByTagName("outline-stroke").item(0);
            if (shaderElement != null && (shader = InflaterUtil.elementShader(shaderElement)) != null) {
                roundView.setShader(shader);
            }
            if (strokeElement != null && (stroke = InflaterUtil.elementStroke(strokeElement)) != null) {
                roundView.setOutlineStroke(stroke);
            }
            roundView.setOutlineRound(Integer.parseInt(outlineround));
            roundView.setOutlineColor(InflaterUtil.elementColor(outlinecolorElement));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return roundView;
    }

    private View generateView2D() throws X2DException {
        View view2D = new View();
        view2D.setSize(new Dimension(this.getWidth(), this.getHeight()));
        Integer holderWest = InflaterUtil.elementInteger(this.viewRoot, "west");
        Integer holderSouth = InflaterUtil.elementInteger(this.viewRoot, "south");
        Integer holderEast = InflaterUtil.elementInteger(this.viewRoot, "east");
        Integer holderNorth = InflaterUtil.elementInteger(this.viewRoot, "north");
        view2D.setPlaceHolderAxisWest(holderWest);
        view2D.setPlaceHolderAxisSouth(holderSouth);
        view2D.setPlaceHolderAxisEast(holderEast);
        view2D.setPlaceHolderAxisNorth(holderNorth);
        Element viewBackground = (Element)this.viewRoot.getElementsByTagName("background").item(0);
        view2D.setBackgroundPainter(this.parseBackground(viewBackground));
        NodeList windowsElements = this.viewRoot.getElementsByTagName("window2d");
        for (int i = 0; i < windowsElements.getLength(); ++i) {
            Element w2dElement = (Element)windowsElements.item(i);
            try {
                Date maxDate;
                Date minDate;
                String windowID = InflaterUtil.elementText(w2dElement, "id");
                String name = InflaterUtil.elementText(w2dElement, "name");
                Double minx = InflaterUtil.elementDouble(w2dElement, "min-x");
                Double maxx = InflaterUtil.elementDouble(w2dElement, "max-x");
                Double miny = InflaterUtil.elementDouble(w2dElement, "min-y");
                Double maxy = InflaterUtil.elementDouble(w2dElement, "max-y");
                Color themeColor = InflaterUtil.elementColor(w2dElement, "theme-color");
                Projection.Linear w2d = null;
                String windowType = InflaterUtil.getType(w2dElement);
                if (windowType.equals("Window2DLinear")) {
                    w2d = new Projection.Linear(minx, maxx, miny, maxy);
                } else if (windowType.equals("Window2DLogX")) {
                    w2d = new Projection.LogX(minx, maxx, miny, maxy);
                } else if (windowType.equals("Window2DLogY")) {
                    w2d = new Projection.LogY(minx, maxx, miny, maxy);
                } else if (windowType.equals("Window2DLog")) {
                    w2d = new Projection.Log(minx, maxx, miny, maxy);
                } else if (windowType.equals("Window2DTimeX")) {
                    String minXDate = InflaterUtil.elementText(w2dElement, "min-x-datetime");
                    String maxXDate = InflaterUtil.elementText(w2dElement, "max-x-datetime");
                    minDate = DatatypeConverter.parseDateTime((String)minXDate).getTime();
                    maxDate = DatatypeConverter.parseDateTime((String)maxXDate).getTime();
                    w2d = new Projection.TimeX(minDate, maxDate, (double)miny, (double)maxy);
                } else if (windowType.equals("Window2DTimeY")) {
                    String minYDate = InflaterUtil.elementText(w2dElement, "min-y-datetime");
                    String maxYDate = InflaterUtil.elementText(w2dElement, "max-y-datetime");
                    minDate = DatatypeConverter.parseDateTime((String)minYDate).getTime();
                    maxDate = DatatypeConverter.parseDateTime((String)maxYDate).getTime();
                    w2d = new Projection.TimeY((double)minx, (double)maxx, minDate, maxDate);
                }
                w2d.setName(name);
                w2d.setProjectionId(windowID);
                w2d.setThemeColor(themeColor);
                view2D.registerProjection(w2d);
                NodeList pluginsElements = w2dElement.getElementsByTagName("plugin");
                for (int j = 0; j < pluginsElements.getLength(); ++j) {
                    Element pluginElement = (Element)pluginsElements.item(j);
                    String pluginType = InflaterUtil.getType(pluginElement);
                    String pluginID = InflaterUtil.elementText(pluginElement, "id");
                    String pluginName = InflaterUtil.elementText(pluginElement, "name");
                    String pluginClass = InflaterUtil.elementText(pluginElement, "class");
                    AbstractX2DPluginInflater<?> inflater = null;
                    inflater = pluginClass == null ? this.lookupType(pluginType) : this.lookupTypeClass(pluginType, pluginClass);
                    if (inflater != null) {
                        Object plugin = inflater.inflate(pluginElement);
                        ((AbstractPlugin)plugin).setPluginID(pluginID);
                        ((AbstractPlugin)plugin).setName(pluginName);
                        w2d.registerPlugin((AbstractPlugin)plugin);
                        continue;
                    }
                    if (pluginClass == null) {
                        System.err.println("Plugin inflater type not found : " + pluginType + "\n");
                        throw new X2DException("Plugin inflater type not found : " + pluginType + "\n");
                    }
                    if (pluginClass == null) continue;
                    System.err.println("Plugin inflater type not found : " + pluginType + " for plugin class " + pluginClass + "\n");
                    throw new X2DException("Plugin inflater type not found : " + pluginType + " for plugin class " + pluginClass + "\n");
                }
                continue;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return view2D;
    }
}

