/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.x2d.binding.function;

import java.awt.Color;
import java.awt.Stroke;
import org.jensoft.core.glyphmetrics.GlyphMetric;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.plugin.function.FunctionPlugin;
import org.jensoft.core.plugin.function.area.Area;
import org.jensoft.core.plugin.function.area.painter.draw.AbstractAreaDraw;
import org.jensoft.core.plugin.function.area.painter.draw.AreaDefaultDraw;
import org.jensoft.core.plugin.function.area.painter.fill.AbstractAreaFill;
import org.jensoft.core.plugin.function.area.painter.fill.AreaDefaultFill;
import org.jensoft.core.plugin.function.area.painter.fill.AreaGradientFill;
import org.jensoft.core.plugin.function.source.SourceFunction;
import org.jensoft.core.x2d.binding.AbstractX2DPluginInflater;
import org.jensoft.core.x2d.binding.X2DBinding;
import org.jensoft.core.x2d.binding.function.FunctionUtil;
import org.jensoft.core.x2d.binding.function.X2DAreaElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@X2DBinding(xsi="AreaPlugin", plugin=FunctionPlugin.AreaFunction.class)
public class AreaFunctionInflater
extends AbstractX2DPluginInflater<FunctionPlugin.AreaFunction>
implements X2DAreaElement {
    @Override
    public FunctionPlugin.AreaFunction inflate(Element pluginElement) {
        FunctionPlugin.AreaFunction area = new FunctionPlugin.AreaFunction();
        NodeList curveElementList = pluginElement.getElementsByTagName("area-function");
        for (int i = 0; i < curveElementList.getLength(); ++i) {
            Element curveElement = (Element)curveElementList.item(i);
            Area function = this.inflateFunction(curveElement);
            if (function == null) continue;
            area.addFunction(function);
        }
        return area;
    }

    private AbstractAreaDraw inflateFunctionDraw(Element drawElement) {
        if (drawElement == null) {
            return new AreaDefaultDraw();
        }
        String type = AreaFunctionInflater.getType(drawElement);
        if (type.equals("AreaDefaultDraw")) {
            Color curveColor = AreaFunctionInflater.elementColor(drawElement, "area-color");
            Stroke curveStroke = AreaFunctionInflater.elementStroke(drawElement, "area-stroke");
            Color baseColor = AreaFunctionInflater.elementColor(drawElement, "base-color");
            Stroke baseStroke = AreaFunctionInflater.elementStroke(drawElement, "base-stroke");
            AreaDefaultDraw draw = new AreaDefaultDraw(curveColor, curveStroke, baseColor, baseStroke);
            return draw;
        }
        return new AreaDefaultDraw();
    }

    private AbstractAreaFill inflateFunctionFill(Element fillElement) {
        if (fillElement == null) {
            return new AreaDefaultFill();
        }
        String type = AreaFunctionInflater.getType(fillElement);
        if (type.equals("AreaDefaultFill")) {
            Color fillColor = AreaFunctionInflater.elementColor(fillElement, "color");
            return new AreaDefaultFill(fillColor);
        }
        if (type.equals("AreaGradientFill")) {
            Color fillColor1 = AreaFunctionInflater.elementColor(fillElement, "color-1");
            Color fillColor2 = AreaFunctionInflater.elementColor(fillElement, "color-2");
            Shader shader = AreaFunctionInflater.elementShader(fillElement, "shader");
            AreaGradientFill gradient = new AreaGradientFill();
            gradient.setColor1(fillColor1);
            gradient.setColor2(fillColor2);
            if (shader != null) {
                gradient.setShader(shader);
            }
            return gradient;
        }
        return new AreaDefaultFill();
    }

    private Area inflateFunction(Element areaFunctionElement) {
        Element sourceFunctionElement = (Element)areaFunctionElement.getElementsByTagName("source-function").item(0);
        SourceFunction sourceFunction = FunctionUtil.inflateSourceFunction(sourceFunctionElement);
        if (sourceFunction == null) {
            return null;
        }
        Area areaFunction = new Area(sourceFunction);
        String name = AreaFunctionInflater.elementText(areaFunctionElement, "name");
        areaFunction.setName(name);
        Double areaBase = AreaFunctionInflater.elementDouble(areaFunctionElement, "base");
        areaFunction.setAreaBase(areaBase);
        Color c = AreaFunctionInflater.elementColor(areaFunctionElement, "theme-color");
        areaFunction.setThemeColor(c);
        Element drawElement = (Element)areaFunctionElement.getElementsByTagName("area-draw").item(0);
        AbstractAreaDraw areaDraw = this.inflateFunctionDraw(drawElement);
        areaFunction.setAreaDraw(areaDraw);
        Element fillElement = (Element)areaFunctionElement.getElementsByTagName("area-fill").item(0);
        AbstractAreaFill areaFill = this.inflateFunctionFill(fillElement);
        areaFunction.setAreaFill(areaFill);
        NodeList glyphElements = areaFunctionElement.getElementsByTagName("glyph");
        for (int i = 0; i < glyphElements.getLength(); ++i) {
            Element element = (Element)glyphElements.item(i);
            GlyphMetric glyphMetrics = FunctionUtil.parseGlyphMetrics(element);
            if (glyphMetrics == null) continue;
            areaFunction.addMetricsLabel(glyphMetrics);
        }
        return areaFunction;
    }
}

