/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.x2d.binding.function;

import java.awt.Color;
import java.awt.Stroke;
import org.jensoft.core.glyphmetrics.GlyphMetric;
import org.jensoft.core.plugin.function.FunctionPlugin;
import org.jensoft.core.plugin.function.curve.Curve;
import org.jensoft.core.plugin.function.curve.painter.draw.AbstractCurveDraw;
import org.jensoft.core.plugin.function.curve.painter.draw.CurveDefaultDraw;
import org.jensoft.core.plugin.function.source.SourceFunction;
import org.jensoft.core.x2d.binding.AbstractX2DPluginInflater;
import org.jensoft.core.x2d.binding.X2DBinding;
import org.jensoft.core.x2d.binding.function.FunctionUtil;
import org.jensoft.core.x2d.binding.function.X2DCurveElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@X2DBinding(xsi="CurvePlugin", plugin=FunctionPlugin.AreaFunction.class)
public class CurveFunctionInflater
extends AbstractX2DPluginInflater<FunctionPlugin.CurveFunction>
implements X2DCurveElement {
    @Override
    public FunctionPlugin.CurveFunction inflate(Element pluginElement) {
        FunctionPlugin.CurveFunction curve = new FunctionPlugin.CurveFunction();
        NodeList curveElementList = pluginElement.getElementsByTagName("curve-function");
        for (int i = 0; i < curveElementList.getLength(); ++i) {
            Element curveElement = (Element)curveElementList.item(i);
            Curve function = this.inflateFunction(curveElement);
            if (function == null) continue;
            curve.addFunction(function);
        }
        return curve;
    }

    private AbstractCurveDraw inflateFunctionDraw(Element drawElement) {
        if (drawElement == null) {
            return new CurveDefaultDraw();
        }
        String type = CurveFunctionInflater.getType(drawElement);
        if (type.equals("CurveDefaultDraw")) {
            Color curveColor = CurveFunctionInflater.elementColor(drawElement, "color");
            Stroke curveStroke = CurveFunctionInflater.elementStroke(drawElement, "stroke");
            CurveDefaultDraw draw = new CurveDefaultDraw(curveColor, curveStroke);
            return draw;
        }
        return new CurveDefaultDraw();
    }

    private Curve inflateFunction(Element curveFunctionElement) {
        Element sourceFunctionElement = (Element)curveFunctionElement.getElementsByTagName("source-function").item(0);
        SourceFunction sourceFunction = FunctionUtil.inflateSourceFunction(sourceFunctionElement);
        if (sourceFunction == null) {
            return null;
        }
        Curve areaFunction = new Curve(sourceFunction);
        String name = CurveFunctionInflater.elementText(curveFunctionElement, "name");
        areaFunction.setName(name);
        Color c = CurveFunctionInflater.elementColor(curveFunctionElement, "theme-color");
        areaFunction.setThemeColor(c);
        Element drawElement = (Element)curveFunctionElement.getElementsByTagName("curve-draw").item(0);
        AbstractCurveDraw curveDraw = this.inflateFunctionDraw(drawElement);
        areaFunction.setCurveDraw(curveDraw);
        NodeList glyphElements = curveFunctionElement.getElementsByTagName("glyph");
        for (int i = 0; i < glyphElements.getLength(); ++i) {
            Element element = (Element)glyphElements.item(i);
            GlyphMetric glyphMetrics = FunctionUtil.parseGlyphMetrics(element);
            if (glyphMetrics == null) continue;
            areaFunction.addMetricsLabel(glyphMetrics);
        }
        return areaFunction;
    }
}

