/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.x2d.binding.function;

import java.awt.Color;
import org.jensoft.core.plugin.function.FunctionPlugin;
import org.jensoft.core.plugin.function.scatter.Scatter;
import org.jensoft.core.plugin.function.scatter.morphe.EllipseMorphe;
import org.jensoft.core.plugin.function.scatter.morphe.PolygonMorphe;
import org.jensoft.core.plugin.function.scatter.morphe.QInverseMorphe;
import org.jensoft.core.plugin.function.scatter.morphe.RectangleMorphe;
import org.jensoft.core.plugin.function.scatter.morphe.StarMorphe;
import org.jensoft.core.plugin.function.scatter.painter.fill.ScatterDefaultFill;
import org.jensoft.core.plugin.function.source.SourceFunction;
import org.jensoft.core.x2d.binding.AbstractX2DPluginInflater;
import org.jensoft.core.x2d.binding.X2DBinding;
import org.jensoft.core.x2d.binding.function.FunctionUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@X2DBinding(xsi="ScatterPlugin", plugin=FunctionPlugin.ScatterFunction.class)
public class ScatterFunctionInflater
extends AbstractX2DPluginInflater<FunctionPlugin.ScatterFunction> {
    @Override
    public FunctionPlugin.ScatterFunction inflate(Element paramsElement) {
        FunctionPlugin.ScatterFunction scatter = new FunctionPlugin.ScatterFunction();
        Element curvesElement = (Element)paramsElement.getElementsByTagName("curves").item(0);
        NodeList curveElements = curvesElement.getElementsByTagName("curve");
        for (int i = 0; i < curveElements.getLength(); ++i) {
            Element labelElement = (Element)curveElements.item(i);
            Scatter curve = this.inflateCurve(labelElement);
            scatter.addFunction(curve);
        }
        return scatter;
    }

    private Scatter inflateCurve(Element curveElement) {
        String morphe;
        Element serieElement = (Element)curveElement.getElementsByTagName("serie2d").item(0);
        SourceFunction serie2D = FunctionUtil.inflateSourceFunction(serieElement);
        Scatter curve = new Scatter(serie2D);
        curve.setScatterFill(new ScatterDefaultFill());
        Element tc = (Element)curveElement.getElementsByTagName("themecolor").item(0);
        Color c = ScatterFunctionInflater.elementColor(tc);
        if (c != null) {
            curve.setThemeColor(c);
        }
        if ((morphe = ScatterFunctionInflater.elementText(curveElement, "morphe")) != null && !morphe.equals("undefined")) {
            if (morphe.equals("ellipse")) {
                curve.setScatterMorphe(new EllipseMorphe(8.0, 8.0));
            } else if (morphe.equals("polygon")) {
                curve.setScatterMorphe(new PolygonMorphe(5.0, 6.0));
            } else if (morphe.equals("qinverse")) {
                curve.setScatterMorphe(new QInverseMorphe(5.0, 3.0));
            } else if (morphe.equals("rectangle")) {
                curve.setScatterMorphe(new RectangleMorphe(4.0, 4.0));
            } else if (morphe.equals("star")) {
                curve.setScatterMorphe(new StarMorphe(3, 6, 5));
            }
        } else {
            curve.setScatterMorphe(new QInverseMorphe(5.0, 3.0));
        }
        return curve;
    }
}

