/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.x2d.binding.pie;

import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import org.jensoft.core.drawable.text.TextPath;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.plugin.pie.Pie;
import org.jensoft.core.plugin.pie.PiePlugin;
import org.jensoft.core.plugin.pie.PieSlice;
import org.jensoft.core.plugin.pie.PieToolkit;
import org.jensoft.core.plugin.pie.painter.effect.AbstractPieEffect;
import org.jensoft.core.plugin.pie.painter.effect.CubicEffectFrame;
import org.jensoft.core.plugin.pie.painter.effect.CubicEffectKey;
import org.jensoft.core.plugin.pie.painter.effect.PieCompoundEffect;
import org.jensoft.core.plugin.pie.painter.effect.PieCubicEffect;
import org.jensoft.core.plugin.pie.painter.effect.PieLinearEffect;
import org.jensoft.core.plugin.pie.painter.effect.PieRadialEffect;
import org.jensoft.core.plugin.pie.painter.effect.PieReflectionEffect;
import org.jensoft.core.plugin.pie.painter.fill.AbstractPieFill;
import org.jensoft.core.plugin.pie.painter.fill.PieDefaultFill;
import org.jensoft.core.plugin.pie.painter.fill.PieRadialFill;
import org.jensoft.core.plugin.pie.painter.label.AbstractPieSliceLabel;
import org.jensoft.core.plugin.pie.painter.label.PieBorderLabel;
import org.jensoft.core.plugin.pie.painter.label.PieBoundLabel;
import org.jensoft.core.plugin.pie.painter.label.PiePathLabel;
import org.jensoft.core.plugin.pie.painter.label.PieRadialLabel;
import org.jensoft.core.x2d.binding.AbstractX2DPluginInflater;
import org.jensoft.core.x2d.binding.X2DBinding;
import org.jensoft.core.x2d.binding.pie.X2DPieElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@X2DBinding(xsi="PiePlugin", plugin=PiePlugin.class)
public class PieInflater
extends AbstractX2DPluginInflater<PiePlugin>
implements X2DPieElement {
    private PieCubicEffect inflatePieCubicEffect(Element effectElement) {
        CubicEffectFrame frame;
        String frameText;
        NodeList cubicKeyNL;
        PieCubicEffect cubicEffect = new PieCubicEffect();
        Integer incidence = PieInflater.elementInteger(effectElement, "incidence-angle");
        Integer offsetRadius = PieInflater.elementInteger(effectElement, "offset-radius");
        if (incidence != null) {
            cubicEffect.setIncidenceAngleDegree(incidence);
        }
        if (offsetRadius != null) {
            cubicEffect.setOffsetRadius(offsetRadius);
        }
        if ((cubicKeyNL = effectElement.getElementsByTagName("cubic-key")) != null && cubicKeyNL.getLength() > 0) {
            Element cubicKeyElement = (Element)cubicKeyNL.item(0);
            Integer startAngleDelta = PieInflater.elementInteger(cubicKeyElement, "start-angle-delta");
            Integer endAngleDelta = PieInflater.elementInteger(cubicKeyElement, "end-angle-delta");
            Float startRadiusFraction = PieInflater.elementFloat(cubicKeyElement, "start-radius-fraction");
            Float endRadiusFraction = PieInflater.elementFloat(cubicKeyElement, "end-radius-fraction");
            CubicEffectKey key = new CubicEffectKey(startAngleDelta, startRadiusFraction.floatValue(), endAngleDelta, endRadiusFraction.floatValue());
            cubicEffect.setCubicKey(key);
        }
        if ((frameText = PieInflater.elementText(effectElement, "cubic-frame")) != null && (frame = CubicEffectFrame.valueOf(frameText)) != null) {
            cubicEffect.setFrame(frame);
        }
        return cubicEffect;
    }

    private PieLinearEffect inflatePieLinearEffect(Element effectElement) {
        PieLinearEffect linearEffect = new PieLinearEffect();
        Integer incidence = PieInflater.elementInteger(effectElement, "incidence-angle");
        Integer offsetRadius = PieInflater.elementInteger(effectElement, "offset-radius");
        if (incidence != null) {
            linearEffect.setIncidenceAngleDegree(incidence);
        }
        if (offsetRadius != null) {
            linearEffect.setOffsetRadius(offsetRadius);
        }
        return linearEffect;
    }

    private PieRadialEffect inflatePieRadialEffect(Element effectElement) {
        PieRadialEffect radialEffect = new PieRadialEffect();
        Integer focusAngle = PieInflater.elementInteger(effectElement, "focus-angle");
        Integer focusRadius = PieInflater.elementInteger(effectElement, "focus-radius");
        Integer offsetRadius = PieInflater.elementInteger(effectElement, "offset-radius");
        if (focusAngle != null) {
            radialEffect.setFocusAngle(focusAngle);
        }
        if (focusRadius != null) {
            radialEffect.setFocusRadius(focusRadius);
        }
        if (offsetRadius != null) {
            radialEffect.setOffsetRadius(offsetRadius);
        }
        return radialEffect;
    }

    private PieReflectionEffect inflatePieReflectionEffect(Element effectElement) {
        PieReflectionEffect reflectionEffect = new PieReflectionEffect();
        Boolean blurEnable = PieInflater.elementBoolean(effectElement, "blur-enable");
        Float opacity = PieInflater.elementFloat(effectElement, "mask-opacity");
        Float length = PieInflater.elementFloat(effectElement, "reflection-length");
        if (blurEnable != null) {
            reflectionEffect.setBlurEnabled(blurEnable);
        }
        if (opacity != null) {
            reflectionEffect.setOpacity(opacity.floatValue());
        }
        if (length != null) {
            reflectionEffect.setLength(length.floatValue());
        }
        return reflectionEffect;
    }

    private AbstractPieFill inflatePieFill(Element pieFillElement) {
        if (pieFillElement == null || pieFillElement.getAttribute("xsi:type") == null) {
            return new PieDefaultFill();
        }
        if (PieInflater.getType(pieFillElement).equals("PieLinearFill")) {
            return new PieDefaultFill();
        }
        if (PieInflater.getType(pieFillElement).equals("PieRadialFill")) {
            return new PieRadialFill();
        }
        return new PieDefaultFill();
    }

    private AbstractPieEffect inflatePieEffect(Element pieEffectElement) {
        if (pieEffectElement == null) {
            return null;
        }
        String type = pieEffectElement.getAttribute("xsi:type");
        if (type == null) {
            return null;
        }
        if (PieInflater.getType(pieEffectElement).equals("PieCompoundEffect")) {
            NodeList effectElementList = pieEffectElement.getElementsByTagName("effect");
            AbstractPieEffect[] fxs = new AbstractPieEffect[effectElementList.getLength()];
            for (int i = 0; i < effectElementList.getLength(); ++i) {
                Element subEffectElement = (Element)effectElementList.item(i);
                fxs[i] = this.inflatePieEffect(subEffectElement);
            }
            return new PieCompoundEffect(fxs);
        }
        if (PieInflater.getType(pieEffectElement).equals("PieLinearEffect")) {
            return this.inflatePieLinearEffect(pieEffectElement);
        }
        if (PieInflater.getType(pieEffectElement).equals("PieRadialEffect")) {
            return this.inflatePieRadialEffect(pieEffectElement);
        }
        if (PieInflater.getType(pieEffectElement).equals("PieReflectionEffect")) {
            return this.inflatePieReflectionEffect(pieEffectElement);
        }
        if (PieInflater.getType(pieEffectElement).equals("PieCubicEffect")) {
            return this.inflatePieCubicEffect(pieEffectElement);
        }
        return null;
    }

    private PieBorderLabel inflatePieSliceBorderLabel(Element labelElement) {
        PieBorderLabel sliceLabel = new PieBorderLabel();
        this.inflatePieSliceLabel(sliceLabel, labelElement);
        Boolean linkEnabled = PieInflater.elementBoolean(labelElement, "link-enable");
        String linkStyle = PieInflater.elementText(labelElement, "link-style");
        Color linkColor = PieInflater.elementColor(labelElement, "link-color");
        Stroke linkStroke = PieInflater.elementStroke(labelElement, "link-stroke");
        Integer linkExtends = PieInflater.elementInteger(labelElement, "link-extends");
        Boolean markerEnabled = PieInflater.elementBoolean(labelElement, "marker-enable");
        Color linkMarkerDrawColor = PieInflater.elementColor(labelElement, "marker-draw");
        Color linkMarkerFillColor = PieInflater.elementColor(labelElement, "marker-fill");
        Integer margin = PieInflater.elementInteger(labelElement, "label-margin");
        if (linkEnabled != null && !linkEnabled.equals("undefined")) {
            sliceLabel.setLink(linkEnabled);
        }
        if (linkStyle != null && !linkStyle.equals("undefined")) {
            sliceLabel.setLinkStyle(PieBorderLabel.LinkStyle.parseStyle(linkStyle));
        }
        if (linkExtends != null && !linkExtends.equals("undefined")) {
            sliceLabel.setLinkExtends(linkExtends);
        }
        sliceLabel.setLinkColor(linkColor);
        sliceLabel.setLinkStroke(linkStroke);
        if (markerEnabled != null && !markerEnabled.equals("undefined")) {
            sliceLabel.setLinkMarker(markerEnabled);
        }
        sliceLabel.setLinkMarkerDrawColor(linkMarkerDrawColor);
        sliceLabel.setLinkMarkerFillColor(linkMarkerFillColor);
        if (margin != null && !margin.equals("undefined")) {
            sliceLabel.setMargin(margin);
        }
        return sliceLabel;
    }

    private PieRadialLabel inflatePieSliceRadialLabel(Element labelElement) {
        PieRadialLabel sliceLabel = new PieRadialLabel();
        this.inflatePieSliceLabel(sliceLabel, labelElement);
        Integer offsetRadius = PieInflater.elementInteger(labelElement, "offset-radius");
        if (offsetRadius != null && !offsetRadius.equals("undefined")) {
            sliceLabel.setOffsetRadius(offsetRadius);
        }
        return sliceLabel;
    }

    private PieBoundLabel inflatePieSliceBoundLabel(Element labelElement) {
        PieBoundLabel sliceLabel = new PieBoundLabel();
        this.inflatePieSliceLabel(sliceLabel, labelElement);
        return sliceLabel;
    }

    private PiePathLabel inflatePieSlicePathLabel(Element labelElement) {
        PiePathLabel sliceLabel = new PiePathLabel();
        this.inflatePieSliceLabel(sliceLabel, labelElement);
        Integer pathDivergence = PieInflater.elementInteger(labelElement, "text-divergence");
        String textposition = PieInflater.elementText(labelElement, "text-position");
        String pathside = PieInflater.elementText(labelElement, "text-side");
        String pathname = PieInflater.elementText(labelElement, "segment-path");
        Shader shader = PieInflater.elementShader(labelElement, "text-shader");
        sliceLabel.setDivergence(pathDivergence);
        sliceLabel.setPathName(PiePathLabel.PathName.parse(pathname));
        sliceLabel.setTextPosition(TextPath.TextPosition.parse(textposition));
        sliceLabel.setPathSide(TextPath.PathSide.parse(pathside));
        sliceLabel.setTextShader(shader);
        return sliceLabel;
    }

    private void inflatePieSliceLabel(AbstractPieSliceLabel abstractLabel, Element labelElement) {
        String text = PieInflater.elementText(labelElement, "text");
        Color textColor = PieInflater.elementColor(labelElement, "text-color");
        Font textFont = PieInflater.elementFont(labelElement, "font");
        Integer labelPaddingX = PieInflater.elementInteger(labelElement, "text-padding-x");
        Integer labelPaddingY = PieInflater.elementInteger(labelElement, "text-padding-y");
        Integer outlineRound = PieInflater.elementInteger(labelElement, "outline-round");
        Color outlineColor = PieInflater.elementColor(labelElement, "outline-color");
        Stroke outlineStroke = PieInflater.elementStroke(labelElement, "outline-stroke");
        Color fillColor = PieInflater.elementColor(labelElement, "fill-color");
        Shader shader = PieInflater.elementShader(labelElement, "shader");
        String style = PieInflater.elementText(labelElement, "style");
        if (text != null) {
            abstractLabel.setLabel(text);
        }
        if (textColor != null) {
            abstractLabel.setLabelColor(textColor);
        }
        if (textFont != null) {
            abstractLabel.setLabelFont(textFont);
        }
        if (labelPaddingX != null) {
            abstractLabel.setLabelPaddingX(labelPaddingX);
        }
        if (labelPaddingY != null) {
            abstractLabel.setLabelPaddingY(labelPaddingY);
        }
        if (outlineRound != null) {
            abstractLabel.setOutlineRound(outlineRound);
        }
        if (outlineColor != null) {
            abstractLabel.setOutlineColor(outlineColor);
        }
        if (outlineStroke != null) {
            abstractLabel.setOutlineStroke(outlineStroke);
        }
        if (fillColor != null) {
            abstractLabel.setFillColor(fillColor);
        }
        if (shader != null) {
            abstractLabel.setShader(shader);
        }
        if (style != null) {
            abstractLabel.setStyle(AbstractPieSliceLabel.Style.parseStyle(style));
        }
    }

    private AbstractPieSliceLabel inflatePieSliceLabel(Element labelElement) {
        if (PieInflater.getType(labelElement).equals("PieRadialLabel")) {
            return this.inflatePieSliceRadialLabel(labelElement);
        }
        if (PieInflater.getType(labelElement).equals("PieBorderLabel")) {
            return this.inflatePieSliceBorderLabel(labelElement);
        }
        if (PieInflater.getType(labelElement).equals("PieBoundLabel")) {
            return this.inflatePieSliceBoundLabel(labelElement);
        }
        if (PieInflater.getType(labelElement).equals("PiePathLabel")) {
            return this.inflatePieSlicePathLabel(labelElement);
        }
        return null;
    }

    private PieSlice inflatePieSlice(Element sliceElement) {
        String sliceName = PieInflater.elementText(sliceElement, "name");
        String value = PieInflater.elementText(sliceElement, "value");
        String divergence = PieInflater.elementText(sliceElement, "divergence");
        Color color = PieInflater.elementColor(sliceElement, "slice-color");
        PieSlice s = PieToolkit.createSlice(sliceName, color, Double.parseDouble(value), Integer.parseInt(divergence));
        NodeList labelListElement = sliceElement.getElementsByTagName("label");
        for (int i = 0; i < labelListElement.getLength(); ++i) {
            Element labelElement = (Element)labelListElement.item(i);
            AbstractPieSliceLabel sliceLabel = this.inflatePieSliceLabel(labelElement);
            if (sliceLabel == null) continue;
            s.addSliceLabel(sliceLabel);
        }
        return s;
    }

    private Pie inflatePie(Element pieElement) {
        String name = PieInflater.elementText(pieElement, "name");
        Double x = PieInflater.elementDouble(pieElement, "x");
        Double y = PieInflater.elementDouble(pieElement, "y");
        Double radius = PieInflater.elementDouble(pieElement, "radius");
        Double startAngleDegree = PieInflater.elementDouble(pieElement, "start-angle");
        String nature = PieInflater.elementText(pieElement, "nature");
        Pie pie = PieToolkit.createPie(name, radius);
        pie.setCenterX(x);
        pie.setCenterY(y);
        pie.setStartAngleDegree(startAngleDegree);
        pie.setPieNature(Pie.PieNature.parseNature(nature));
        NodeList slices = pieElement.getElementsByTagName("slice");
        for (int i = 0; i < slices.getLength(); ++i) {
            Element pieSliceElement = (Element)slices.item(i);
            PieSlice pieSlice = this.inflatePieSlice(pieSliceElement);
            pie.addSlice(pieSlice);
        }
        Element fillElement = (Element)pieElement.getElementsByTagName("fill").item(0);
        AbstractPieFill fill = this.inflatePieFill(fillElement);
        pie.setPieFill(fill);
        Element effectElement = (Element)pieElement.getElementsByTagName("effect").item(0);
        AbstractPieEffect effect = this.inflatePieEffect(effectElement);
        pie.setPieEffect(effect);
        return pie;
    }

    @Override
    public PiePlugin inflate(Element pluginElement) {
        PiePlugin piePlugin = new PiePlugin();
        NodeList pieElementList = pluginElement.getElementsByTagName("pie");
        for (int i = 0; i < pieElementList.getLength(); ++i) {
            Element pieElement = (Element)pieElementList.item(i);
            Pie pie = this.inflatePie(pieElement);
            pie.setHostPlugin(piePlugin);
            piePlugin.addPie(pie);
        }
        return piePlugin;
    }
}

