/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.x2d.binding.stripe;

import java.awt.Color;
import org.jensoft.core.plugin.stripe.Stripe;
import org.jensoft.core.plugin.stripe.StripePlugin;
import org.jensoft.core.plugin.stripe.manager.FlowStripeManager;
import org.jensoft.core.plugin.stripe.manager.FreeStripeManager;
import org.jensoft.core.plugin.stripe.painter.StripePaint;
import org.jensoft.core.plugin.stripe.painter.StripePalette;
import org.jensoft.core.x2d.binding.AbstractX2DPluginInflater;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StripeInflater
extends AbstractX2DPluginInflater<StripePlugin> {
    @Override
    public StripePlugin inflate(Element pluginElement) {
        Element managersElement = (Element)pluginElement.getElementsByTagName("managers").item(0);
        NodeList managerElements = managersElement.getElementsByTagName("manager");
        for (int i = 0; i < managerElements.getLength(); ++i) {
            Element managerElement = (Element)managerElements.item(0);
            String type = StripeInflater.elementText(managerElement, "type");
            if (type == null) continue;
            if (type.equals("dynamic")) {
                this.inflateDynamicManager(managerElement);
                continue;
            }
            if (type.equals("flow")) {
                this.inflateFlowManager(managerElement);
                continue;
            }
            if (!type.equals("free")) continue;
            this.inflateFreeManager(managerElement);
        }
        return null;
    }

    public StripePalette parsePalette(Element paletteElement) {
        if (paletteElement == null) {
            return null;
        }
        StripePalette palette = new StripePalette();
        NodeList colorElements = paletteElement.getElementsByTagName("c");
        for (int i = 0; i < colorElements.getLength(); ++i) {
            Element colorElement = (Element)colorElements.item(i);
            Color c = StripeInflater.elementColor(colorElement);
            if (c == null) continue;
            palette.addPaint(c);
        }
        return palette;
    }

    public void inflateDynamicManager(Element managerElement) {
        String orientation = StripeInflater.elementText(managerElement, "orientation");
        String ref = StripeInflater.elementText(managerElement, "ref");
        String interval = StripeInflater.elementText(managerElement, "interval");
        Element paletteElement = (Element)((Object)managerElement.getElementsByTagName("palette"));
        StripePlugin.StripeOrientation bo = null;
        Double bandRef = null;
        Double bandInterval = null;
        StripePalette palette = null;
        if (orientation != null && !orientation.equals("undefined")) {
            bo = StripePlugin.StripeOrientation.parse(orientation);
        }
        if (ref != null && !ref.equals("undefined")) {
            bandRef = Double.parseDouble(ref);
        }
        if (interval != null && !interval.equals("undefined")) {
            bandInterval = Double.parseDouble(interval);
        }
        palette = this.parsePalette(paletteElement);
        if (bo == null || bandRef == null || bandInterval == null || palette != null) {
            // empty if block
        }
    }

    public void inflateFlowManager(Element managerElement) {
        String orientation = StripeInflater.elementText(managerElement, "orientation");
        String startband = StripeInflater.elementText(managerElement, "startband");
        String endband = StripeInflater.elementText(managerElement, "endband");
        String interval = StripeInflater.elementText(managerElement, "interval");
        Element paletteElement = (Element)((Object)managerElement.getElementsByTagName("palette"));
        StripePlugin.StripeOrientation bo = null;
        Double bandStart = null;
        Double bandEnd = null;
        Double bandInterval = null;
        if (orientation != null && !orientation.equals("undefined")) {
            bo = StripePlugin.StripeOrientation.parse(orientation);
        }
        if (startband != null && !startband.equals("undefined")) {
            bandStart = Double.parseDouble(startband);
        }
        if (endband != null && !endband.equals("undefined")) {
            bandEnd = Double.parseDouble(endband);
        }
        if (interval != null && !interval.equals("undefined")) {
            bandInterval = Double.parseDouble(interval);
        }
        StripePalette palette = this.parsePalette(paletteElement);
        if (bo != null && bandStart != null && bandEnd != null && bandInterval != null) {
            FlowStripeManager manager = new FlowStripeManager(bo, bandStart, bandEnd, bandInterval);
            manager.setStripePalette(palette);
        }
    }

    public void inflateFreeManager(Element managerElement) {
        String orientation = StripeInflater.elementText(managerElement, "orientation");
        StripePlugin.StripeOrientation go = null;
        if (orientation != null && !orientation.equals("undefined")) {
            go = StripePlugin.StripeOrientation.parse(orientation);
        }
        FreeStripeManager freeBandManager = null;
        if (go != null) {
            freeBandManager = new FreeStripeManager(go);
        }
        Element bandsElement = (Element)((Object)managerElement.getElementsByTagName("bands"));
        NodeList bandElements = bandsElement.getElementsByTagName("band");
        for (int i = 0; i < bandElements.getLength(); ++i) {
            Element bandElement = (Element)bandElements.item(i);
            Element colorElement = (Element)bandElement.getElementsByTagName("color").item(0);
            String startband = StripeInflater.elementText(bandElement, "start");
            String endband = StripeInflater.elementText(bandElement, "end");
            Double bandStart = null;
            Double bandEnd = null;
            Color bandColor = null;
            if (startband != null && !startband.equals("undefined")) {
                bandStart = Double.parseDouble(startband);
            }
            if (endband != null && !endband.equals("undefined")) {
                bandEnd = Double.parseDouble(endband);
            }
            if (colorElement != null) {
                bandColor = StripeInflater.elementColor(colorElement);
            }
            if (freeBandManager == null || bandStart == null || bandEnd == null || bandColor == null) continue;
            Stripe b = new Stripe();
            b.setUserStart(bandStart);
            b.setUserEnd(bandEnd);
            b.setStripePaint(new StripePaint(bandColor));
            freeBandManager.addStripe(b);
        }
    }
}

