/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.x2d.binding.symbol;

import java.awt.Color;
import java.awt.Stroke;
import org.jensoft.core.graphics.Shader;
import org.jensoft.core.plugin.symbol.BarSymbol;
import org.jensoft.core.plugin.symbol.BarSymbolGroup;
import org.jensoft.core.plugin.symbol.BarSymbolLayer;
import org.jensoft.core.plugin.symbol.Stack;
import org.jensoft.core.plugin.symbol.StackedBarSymbol;
import org.jensoft.core.plugin.symbol.SymbolComponent;
import org.jensoft.core.plugin.symbol.SymbolPlugin;
import org.jensoft.core.plugin.symbol.SymbolToolkit;
import org.jensoft.core.plugin.symbol.painter.AbstractSymbolPainter;
import org.jensoft.core.plugin.symbol.painter.axis.AbstractBarAxisLabel;
import org.jensoft.core.plugin.symbol.painter.axis.BarDefaultAxisLabel;
import org.jensoft.core.plugin.symbol.painter.draw.BarDefaultDraw;
import org.jensoft.core.plugin.symbol.painter.effect.BarEffect1;
import org.jensoft.core.plugin.symbol.painter.effect.BarEffect2;
import org.jensoft.core.plugin.symbol.painter.effect.BarEffect3;
import org.jensoft.core.plugin.symbol.painter.effect.BarEffect4;
import org.jensoft.core.plugin.symbol.painter.fill.BarDefaultFill;
import org.jensoft.core.plugin.symbol.painter.fill.BarFill1;
import org.jensoft.core.plugin.symbol.painter.fill.BarFill2;
import org.jensoft.core.plugin.symbol.painter.label.AbstractBarLabel;
import org.jensoft.core.plugin.symbol.painter.label.BarSymbolRelativeLabel;
import org.jensoft.core.x2d.binding.AbstractX2DPluginInflater;
import org.jensoft.core.x2d.binding.InflaterUtil;
import org.jensoft.core.x2d.binding.X2DBinding;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@X2DBinding(xsi="SymbolPlugin", plugin=SymbolPlugin.class)
public class SymbolInflater
extends AbstractX2DPluginInflater<SymbolPlugin> {
    @Override
    public SymbolPlugin inflate(Element paramsElement) {
        SymbolPlugin symbolPlugin = new SymbolPlugin();
        String nature = SymbolInflater.elementText(paramsElement, "nature");
        SymbolPlugin.SymbolNature barnature = SymbolPlugin.SymbolNature.parse(nature);
        if (barnature == null) {
            return null;
        }
        symbolPlugin.setNature(barnature);
        Element layersElement = (Element)((Object)paramsElement.getElementsByTagName("layers"));
        NodeList layerElements = layersElement.getElementsByTagName("layer");
        for (int i = 0; i < layerElements.getLength(); ++i) {
            Element layerElement = (Element)layerElements.item(i);
            String type = SymbolInflater.elementText(layerElement, "type");
            if (type.equals("BarSymbolLayer")) {
                symbolPlugin.addLayer(this.inflateBarSymbolLayer(layerElement));
                continue;
            }
            if (!type.equals("PointSymbolLayer")) continue;
        }
        return symbolPlugin;
    }

    public BarSymbolLayer inflateBarSymbolLayer(Element layerElement) {
        BarSymbolLayer layer = new BarSymbolLayer();
        Element symbolsElement = (Element)layerElement.getElementsByTagName("symbols").item(0);
        NodeList symbolElements = symbolsElement.getElementsByTagName("symbol");
        for (int i = 0; i < symbolElements.getLength(); ++i) {
            Element symbolRootElement = (Element)symbolElements.item(i);
            String type = SymbolInflater.elementText(symbolRootElement, "type");
            if (type.equals("bar")) {
                layer.addSymbol(this.inflateBar(symbolRootElement));
                continue;
            }
            if (type.equals("stackedbar")) {
                layer.addSymbol(this.inflateStackedBar(symbolRootElement));
                continue;
            }
            if (type.equals("glue")) {
                layer.addSymbol(SymbolComponent.createGlue(BarSymbol.class));
                continue;
            }
            if (type.equals("strut")) {
                String strutValue = SymbolInflater.elementText(symbolRootElement, "value");
                BarSymbol strut = SymbolComponent.createStrut(BarSymbol.class, Double.parseDouble(strutValue));
                layer.addSymbol(strut);
                continue;
            }
            if (!type.equals("group")) continue;
            layer.addSymbol(this.inflateBarGroup(symbolRootElement));
        }
        return layer;
    }

    public BarSymbolGroup inflateBarGroup(Element symbolElement) {
        String name = SymbolInflater.elementText(symbolElement, "name");
        Element themecolor = (Element)symbolElement.getElementsByTagName("themecolor").item(0);
        String thickness = SymbolInflater.elementText(symbolElement, "thickness");
        String base = SymbolInflater.elementText(symbolElement, "base");
        String morphestyle = SymbolInflater.elementText(symbolElement, "morphestyle");
        String morpheround = SymbolInflater.elementText(symbolElement, "morpheround");
        Element draw = (Element)symbolElement.getElementsByTagName("draw").item(0);
        Element fill = (Element)symbolElement.getElementsByTagName("fill").item(0);
        Element effect = (Element)symbolElement.getElementsByTagName("effect").item(0);
        NodeList labelElements = symbolElement.getElementsByTagName("label");
        BarSymbolGroup barGroup = new BarSymbolGroup(name);
        if (themecolor != null && !themecolor.equals("undefined")) {
            barGroup.setThemeColor(SymbolInflater.elementColor(themecolor));
        }
        if (thickness != null && !thickness.equals("undefined")) {
            barGroup.setThickness(Double.parseDouble(thickness));
        }
        if (base != null && !base.equals("undefined")) {
            barGroup.setBase(Double.parseDouble(base));
        }
        if (morphestyle != null && !morphestyle.equals("undefined") && morphestyle.equals("round")) {
            barGroup.setMorpheStyle(BarSymbol.MorpheStyle.Round);
            barGroup.setRound(Integer.parseInt(morpheround));
        }
        if (draw != null && !draw.equals("undefined")) {
            barGroup.setBarDraw(new BarDefaultDraw(SymbolInflater.elementColor(draw)));
        } else {
            barGroup.setBarDraw(new BarDefaultDraw());
        }
        if (fill != null && !fill.equals("undefined")) {
            if (fill.equals("fill1")) {
                barGroup.setBarFill(new BarFill1());
            }
            if (fill.equals("fill2")) {
                barGroup.setBarFill(new BarFill2());
            }
        } else {
            barGroup.setBarFill(new BarDefaultFill());
        }
        if (effect != null && !effect.equals("undefined")) {
            if (effect.equals("fx1")) {
                barGroup.setBarEffect(new BarEffect1());
            }
            if (effect.equals("fx2")) {
                barGroup.setBarEffect(new BarEffect2());
            }
            if (effect.equals("fx3")) {
                barGroup.setBarEffect(new BarEffect3());
            }
            if (effect.equals("fx4")) {
                barGroup.setBarEffect(new BarEffect4());
            }
        }
        for (int i = 0; i < labelElements.getLength(); ++i) {
            AbstractSymbolPainter label;
            Element element = (Element)labelElements.item(i);
            String type = SymbolInflater.elementText(element, "type");
            if (type.equals("relative")) {
                label = this.inflateRelativeLabel(element);
                barGroup.setBarLabel((AbstractBarLabel)label);
            }
            if (!type.equals("axis")) continue;
            label = this.inflateAxisLabel(element);
            barGroup.setAxisLabel((AbstractBarAxisLabel)label);
        }
        Element childrenElement = (Element)symbolElement.getElementsByTagName("children").item(0);
        NodeList symbolElements = childrenElement.getElementsByTagName("symbol");
        for (int i = 0; i < symbolElements.getLength(); ++i) {
            Element element = (Element)symbolElements.item(i);
            String type = SymbolInflater.elementText(element, "type");
            if (type.equals("bar")) {
                barGroup.addSymbol(this.inflateBar(element));
                continue;
            }
            if (type.equals("stackedbar")) {
                barGroup.addSymbol(this.inflateStackedBar(element));
                continue;
            }
            if (type.equals("strut")) {
                String strutValue = SymbolInflater.elementText(element, "value");
                BarSymbol strut = SymbolComponent.createStrut(BarSymbol.class, Double.parseDouble(strutValue));
                barGroup.addSymbol(strut);
                continue;
            }
            if (!type.equals("group")) continue;
            barGroup.addSymbol(this.inflateBarGroup(element));
        }
        return barGroup;
    }

    public BarSymbol inflateBar(Element symbolElement) {
        String name = SymbolInflater.elementText(symbolElement, "name");
        Element themecolor = (Element)symbolElement.getElementsByTagName("themecolor").item(0);
        String thickness = SymbolInflater.elementText(symbolElement, "thickness");
        String base = SymbolInflater.elementText(symbolElement, "base");
        String value = SymbolInflater.elementText(symbolElement, "value");
        String inflate = SymbolInflater.elementText(symbolElement, "inflate");
        String morphestyle = SymbolInflater.elementText(symbolElement, "morphestyle");
        String morpheround = SymbolInflater.elementText(symbolElement, "morpheround");
        Element draw = (Element)symbolElement.getElementsByTagName("draw").item(0);
        Element fill = (Element)symbolElement.getElementsByTagName("fill").item(0);
        Element effect = (Element)symbolElement.getElementsByTagName("effect").item(0);
        NodeList labelElements = symbolElement.getElementsByTagName("label");
        BarSymbol bar = new BarSymbol(name);
        if (themecolor != null && !themecolor.equals("undefined")) {
            bar.setThemeColor(SymbolInflater.elementColor(themecolor));
        }
        if (thickness != null && !thickness.equals("undefined")) {
            bar.setThickness(Double.parseDouble(thickness));
        }
        if (base != null && !base.equals("undefined")) {
            bar.setBase(Double.parseDouble(base));
        }
        if (inflate != null && !inflate.equals("undefined")) {
            if (inflate.equals("ascent")) {
                bar.setAscentValue(Double.parseDouble(value));
            } else if (inflate.equals("descent")) {
                bar.setDescentValue(Double.parseDouble(value));
            }
        }
        if (morphestyle != null && !morphestyle.equals("undefined") && morphestyle.equals("round")) {
            bar.setMorpheStyle(BarSymbol.MorpheStyle.Round);
            bar.setRound(Integer.parseInt(morpheround));
        }
        if (draw != null && !draw.equals("undefined")) {
            bar.setBarDraw(new BarDefaultDraw(SymbolInflater.elementColor(draw)));
        } else {
            bar.setBarDraw(new BarDefaultDraw());
        }
        if (fill != null && !fill.equals("undefined")) {
            if (fill.equals("fill1")) {
                bar.setBarFill(new BarFill1());
            }
            if (fill.equals("fill2")) {
                bar.setBarFill(new BarFill2());
            }
        } else {
            bar.setBarFill(new BarDefaultFill());
        }
        if (effect != null && !effect.equals("undefined")) {
            if (effect.equals("fx1")) {
                bar.setBarEffect(new BarEffect1());
            }
            if (effect.equals("fx2")) {
                bar.setBarEffect(new BarEffect2());
            }
            if (effect.equals("fx3")) {
                bar.setBarEffect(new BarEffect3());
            }
            if (effect.equals("fx4")) {
                bar.setBarEffect(new BarEffect4());
            }
        }
        for (int i = 0; i < labelElements.getLength(); ++i) {
            AbstractSymbolPainter label;
            Element element = (Element)labelElements.item(i);
            String type = SymbolInflater.elementText(element, "type");
            if (type.equals("relative")) {
                label = this.inflateRelativeLabel(element);
                bar.setBarLabel((AbstractBarLabel)label);
            }
            if (!type.equals("axis")) continue;
            label = this.inflateAxisLabel(element);
            bar.setAxisLabel((AbstractBarAxisLabel)label);
        }
        return bar;
    }

    public BarSymbolRelativeLabel inflateRelativeLabel(Element relativeLabel) {
        BarSymbolRelativeLabel label = new BarSymbolRelativeLabel();
        try {
            BarSymbolRelativeLabel.HorizontalAlignment horiAl;
            BarSymbolRelativeLabel.VerticalAlignment vertAl;
            Element shaderElement;
            Element strokeElement;
            String text = SymbolInflater.elementText(relativeLabel, "text");
            String va = SymbolInflater.elementText(relativeLabel, "valign");
            String ha = SymbolInflater.elementText(relativeLabel, "halign");
            Element tc = (Element)relativeLabel.getElementsByTagName("textcolor").item(0);
            Element dc = (Element)relativeLabel.getElementsByTagName("drawcolor").item(0);
            Element fc = (Element)relativeLabel.getElementsByTagName("fillcolor").item(0);
            String a = SymbolInflater.elementText(relativeLabel, "alpha");
            String or = SymbolInflater.elementText(relativeLabel, "outlineround");
            Color textColor = SymbolInflater.elementColor(tc);
            Color drawColor = SymbolInflater.elementColor(dc);
            Color fillColor = SymbolInflater.elementColor(fc);
            String ox = SymbolInflater.elementText(relativeLabel, "offsetX");
            String oy = SymbolInflater.elementText(relativeLabel, "offsetY");
            String tpx = SymbolInflater.elementText(relativeLabel, "textpaddingX");
            String tpy = SymbolInflater.elementText(relativeLabel, "textpaddingY");
            label.setText(text);
            label.setOffsetX(Integer.parseInt(ox));
            label.setOffsetY(Integer.parseInt(oy));
            label.setTextPaddingX(Integer.parseInt(tpx));
            label.setTextPaddingY(Integer.parseInt(tpy));
            label.setAlpha(Float.parseFloat(a));
            label.setOutlineRound(Integer.parseInt(or));
            if (textColor != null) {
                label.setTextColor(textColor);
            }
            if (drawColor != null) {
                label.setDrawColor(drawColor);
            }
            if (fillColor != null) {
                label.setFillColor(fillColor);
            }
            if ((strokeElement = (Element)relativeLabel.getElementsByTagName("stroke").item(0)) != null) {
                Stroke outlineStroke = InflaterUtil.elementStroke(strokeElement);
                label.setOutlineStroke(outlineStroke);
            }
            if ((shaderElement = (Element)relativeLabel.getElementsByTagName("shader").item(0)) != null) {
                Shader shader = InflaterUtil.elementShader(shaderElement);
                label.setShader(shader);
            }
            if (va != null && (vertAl = BarSymbolRelativeLabel.VerticalAlignment.parse(va)) != null) {
                label.setVerticalAlignment(vertAl);
            }
            if (ha != null && (horiAl = BarSymbolRelativeLabel.HorizontalAlignment.parse(ha)) != null) {
                label.setHorizontalAlignment(horiAl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return label;
    }

    public AbstractBarAxisLabel inflateAxisLabel(Element axisLabel) {
        BarDefaultAxisLabel label = new BarDefaultAxisLabel();
        try {
            Element shaderElement;
            Element strokeElement;
            String text = SymbolInflater.elementText(axisLabel, "text");
            Element tc = (Element)axisLabel.getElementsByTagName("textcolor").item(0);
            Element dc = (Element)axisLabel.getElementsByTagName("drawcolor").item(0);
            Element fc = (Element)axisLabel.getElementsByTagName("fillcolor").item(0);
            String a = SymbolInflater.elementText(axisLabel, "alpha");
            String or = SymbolInflater.elementText(axisLabel, "outlineround");
            Color textColor = SymbolInflater.elementColor(tc);
            Color drawColor = SymbolInflater.elementColor(dc);
            Color fillColor = SymbolInflater.elementColor(fc);
            label.setText(text);
            label.setAlpha(Float.parseFloat(a));
            label.setOutlineRound(Integer.parseInt(or));
            String ox = SymbolInflater.elementText(axisLabel, "offsetX");
            String oy = SymbolInflater.elementText(axisLabel, "offsetY");
            String tpx = SymbolInflater.elementText(axisLabel, "textpaddingX");
            String tpy = SymbolInflater.elementText(axisLabel, "textpaddingY");
            label.setOffsetX(Integer.parseInt(ox));
            label.setOffsetY(Integer.parseInt(oy));
            label.setTextPaddingX(Integer.parseInt(tpx));
            label.setTextPaddingY(Integer.parseInt(tpy));
            if (textColor != null) {
                label.setTextColor(textColor);
            }
            if (drawColor != null) {
                label.setDrawColor(drawColor);
            }
            if (fillColor != null) {
                label.setFillColor(fillColor);
            }
            if ((strokeElement = (Element)axisLabel.getElementsByTagName("stroke").item(0)) != null) {
                Stroke outlineStroke = InflaterUtil.elementStroke(strokeElement);
                label.setOutlineStroke(outlineStroke);
            }
            if ((shaderElement = (Element)axisLabel.getElementsByTagName("shader").item(0)) != null) {
                Shader shader = InflaterUtil.elementShader(shaderElement);
                label.setShader(shader);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return label;
    }

    public StackedBarSymbol inflateStackedBar(Element symbolElement) {
        String name = SymbolInflater.elementText(symbolElement, "name");
        Element themecolor = (Element)symbolElement.getElementsByTagName("themecolor").item(0);
        String thickness = SymbolInflater.elementText(symbolElement, "thickness");
        String base = SymbolInflater.elementText(symbolElement, "base");
        String value = SymbolInflater.elementText(symbolElement, "value");
        String inflate = SymbolInflater.elementText(symbolElement, "inflate");
        String morphestyle = SymbolInflater.elementText(symbolElement, "morphestyle");
        String morpheround = SymbolInflater.elementText(symbolElement, "morpheround");
        Element draw = (Element)symbolElement.getElementsByTagName("draw").item(0);
        Element fill = (Element)symbolElement.getElementsByTagName("fill").item(0);
        Element effect = (Element)symbolElement.getElementsByTagName("effect").item(0);
        NodeList labelElements = symbolElement.getElementsByTagName("label");
        StackedBarSymbol bar = new StackedBarSymbol(name);
        if (themecolor != null && !themecolor.equals("undefined")) {
            bar.setThemeColor(SymbolInflater.elementColor(themecolor));
        }
        if (thickness != null && !thickness.equals("undefined")) {
            bar.setThickness(Double.parseDouble(thickness));
        }
        if (base != null && !base.equals("undefined")) {
            bar.setBase(Double.parseDouble(base));
        }
        if (inflate != null && !inflate.equals("undefined")) {
            if (inflate.equals("ascent")) {
                bar.setAscentValue(Double.parseDouble(value));
            } else if (inflate.equals("descent")) {
                bar.setDescentValue(Double.parseDouble(value));
            }
        }
        if (morphestyle != null && !morphestyle.equals("undefined") && morphestyle.equals("round")) {
            bar.setMorpheStyle(BarSymbol.MorpheStyle.Round);
            bar.setRound(Integer.parseInt(morpheround));
        }
        if (draw != null && !draw.equals("undefined")) {
            try {
                bar.setBarDraw(new BarDefaultDraw(SymbolInflater.elementColor(draw)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            bar.setBarDraw(new BarDefaultDraw());
        }
        if (fill != null && !fill.equals("undefined")) {
            if (fill.equals("fill1")) {
                bar.setBarFill(new BarFill1());
            }
            if (fill.equals("fill2")) {
                bar.setBarFill(new BarFill2());
            }
        } else {
            bar.setBarFill(new BarDefaultFill());
        }
        if (effect != null && !effect.equals("undefined")) {
            if (effect.equals("fx1")) {
                bar.setBarEffect(new BarEffect1());
            }
            if (effect.equals("fx2")) {
                bar.setBarEffect(new BarEffect2());
            }
            if (effect.equals("fx3")) {
                bar.setBarEffect(new BarEffect3());
            }
            if (effect.equals("fx4")) {
                bar.setBarEffect(new BarEffect4());
            }
        }
        for (int i = 0; i < labelElements.getLength(); ++i) {
            AbstractSymbolPainter label;
            Element element = (Element)labelElements.item(i);
            String type = SymbolInflater.elementText(element, "type");
            if (type.equals("relative")) {
                label = this.inflateRelativeLabel(element);
                bar.setBarLabel((AbstractBarLabel)label);
            }
            if (!type.equals("axis")) continue;
            label = this.inflateAxisLabel(element);
            bar.setAxisLabel((AbstractBarAxisLabel)label);
        }
        Element stacksElement = (Element)symbolElement.getElementsByTagName("stacks").item(0);
        NodeList stacks = stacksElement.getElementsByTagName("stack");
        for (int i = 0; i < stacks.getLength(); ++i) {
            String type;
            Element element = (Element)stacks.item(i);
            String sname = SymbolInflater.elementText(element, "name");
            Element sthemecolor = (Element)element.getElementsByTagName("themecolor").item(0);
            String svalue = SymbolInflater.elementText(element, "value");
            Element stackLabelElement = (Element)element.getElementsByTagName("label").item(0);
            Stack s = SymbolToolkit.createStack(sname, SymbolInflater.elementColor(sthemecolor), Double.parseDouble(svalue));
            if (stackLabelElement != null && (type = SymbolInflater.elementText(stackLabelElement, "type")).equals("relative")) {
                BarSymbolRelativeLabel label = this.inflateRelativeLabel(stackLabelElement);
                s.setBarLabel(label);
            }
            bar.addStack(s);
        }
        return bar;
    }
}

