/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.util.OS;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboPopup;

public class Popup
extends javax.swing.Popup {
    public static final String POPUP_BACKGROUND = "POPUP_BACKGROUND";
    public static final String POPUP_LIGHTWEIGHT = "POPUP_LIGHTWEIGHT";
    private Component owner;
    private Component contents;
    private int x;
    private int y;
    private javax.swing.Popup popup;
    private Container heavyWeightContainer;
    private boolean lightWeight;

    public Popup(Component component, Component component2, int n, int n2, javax.swing.Popup popup) {
        this.owner = component;
        this.contents = component2;
        this.popup = popup;
        this.x = n;
        this.y = n2;
        Container container = component2.getParent();
        ((JComponent)container).putClientProperty(POPUP_BACKGROUND, null);
        ((JComponent)container).putClientProperty(POPUP_LIGHTWEIGHT, null);
        if (!this.isWindowOpacityEnabled(null)) {
            ((JComponent)container).setDoubleBuffered(false);
        }
        this.lightWeight = true;
        while (container != null) {
            if (container instanceof JWindow || container instanceof Panel || container instanceof Window) {
                this.heavyWeightContainer = container;
                this.lightWeight = false;
                break;
            }
            container = container.getParent();
        }
        this.internalFrameCursorBugfix(component);
        if (this.heavyWeightContainer != null && OS.getCurrentOS() == OS.Mac && !UIManager.getBoolean("Synthetica.popup.osShadow.enabled")) {
            this.heavyWeightContainer.setBackground(new Color(0x1000000, true));
            this.heavyWeightContainer.setBackground(new Color(0, true));
            if (this.heavyWeightContainer instanceof JWindow) {
                ((JWindow)this.heavyWeightContainer).getRootPane().putClientProperty("apple.awt.draggableWindowBackground", Boolean.FALSE);
                ((JWindow)this.heavyWeightContainer).getRootPane().putClientProperty("Window.shadow", Boolean.FALSE);
            }
        }
    }

    private void internalFrameCursorBugfix(Component component) {
        if (component != null && component instanceof JInternalFrame) {
            Container container = ((JInternalFrame)component).getTopLevelAncestor();
            Cursor cursor = Cursor.getPredefinedCursor(0);
            if (container instanceof JFrame) {
                ((JFrame)container).getGlassPane().setCursor(cursor);
                ((JFrame)container).getGlassPane().setVisible(false);
            } else if (container instanceof JWindow) {
                ((JWindow)container).getGlassPane().setCursor(cursor);
                ((JWindow)container).getGlassPane().setVisible(false);
            } else if (container instanceof JDialog) {
                ((JDialog)container).getGlassPane().setCursor(cursor);
                ((JDialog)container).getGlassPane().setVisible(false);
            }
        }
    }

    @Override
    public void hide() {
        Container container;
        Object object;
        if (this.contents instanceof BasicComboPopup && SyntheticaLookAndFeel.getBoolean("Synthetica.workaround.8173744.enabled", null, false)) {
            try {
                long l;
                long l2;
                Field field = BasicComboPopup.class.getDeclaredField("comboBox");
                field.setAccessible(true);
                final JComboBox jComboBox = (JComboBox)field.get(this.contents);
                object = "Synthetica.comboBox.popupWorkaround";
                if (this.isBugPosition(jComboBox) && (l2 = (l = System.currentTimeMillis()) - SyntheticaLookAndFeel.getClientProperty("Synthetica.comboBox.popupWorkaround", jComboBox, l)) < 100L) {
                    if (this.heavyWeightContainer instanceof Window) {
                        this.popup.hide();
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jComboBox.setPopupVisible(true);
                            jComboBox.putClientProperty("Synthetica.comboBox.popupWorkaround", System.currentTimeMillis());
                        }
                    });
                    return;
                }
                jComboBox.putClientProperty("Synthetica.comboBox.popupWorkaround", null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.heavyWeightContainer instanceof Window && SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.fade-out.enabled", this.contents)) {
            int n = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.fade-out.delay", this.contents, 25);
            int n2 = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.fade-out.duration", this.contents, 150);
            object = new WindowFader((Window)this.heavyWeightContainer, this.popup, n, n2, false, true);
            ((Timer)object).start();
        } else if (this.popup != null) {
            this.popup.hide();
        }
        Container container2 = container = this.contents == null ? null : this.contents.getParent();
        if (container instanceof JComponent) {
            ((JComponent)container).putClientProperty(POPUP_BACKGROUND, null);
        }
        if (this.heavyWeightContainer != null) {
            this.heavyWeightContainer = null;
        }
        this.contents = null;
        this.popup = null;
    }

    private boolean isBugPosition(JComponent jComponent) {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        Point point = (Point)pointerInfo.getLocation().clone();
        SwingUtilities.convertPointFromScreen(point, jComponent);
        if (point.x == jComponent.getWidth() - 1 || point.y == jComponent.getHeight() - 1) {
            return true;
        }
        if ((jComponent = (JComponent)SyntheticaLookAndFeel.findComponent("ComboBox.arrowButton", (Container)jComponent)) == null) {
            return false;
        }
        point = pointerInfo.getLocation();
        SwingUtilities.convertPointFromScreen(point, jComponent);
        Rectangle rectangle = new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight());
        return rectangle.contains(point) && (point.x == rectangle.width - 1 || point.y == rectangle.height - 1);
    }

    public javax.swing.Popup getDelegate() {
        return this.popup;
    }

    public Component getContents() {
        return this.contents;
    }

    @Override
    public void show() {
        boolean bl;
        if (this.contents instanceof JPopupMenu && this.contents.getClass().getName().contains("SynthInternalFrameTitlePane") && !SyntheticaLookAndFeel.getBoolean("Synthetica.internalFrame.systemMenu.enabled", this.contents, true)) {
            return;
        }
        boolean bl2 = bl = this.contents instanceof JPopupMenu && SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.blur.enabled", this.contents);
        if (bl && this.heavyWeightContainer == null) {
            this.heavyWeightContainer = this.contents.getParent();
        }
        if (this.heavyWeightContainer == null) {
            this.showPopup(this.popup);
            return;
        }
        if (this.showPopupMenuLater()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Popup.this.showPopup(bl);
                }
            });
        } else {
            this.showPopup(bl);
        }
    }

    private void showPopup(boolean bl) {
        boolean bl2;
        if (this.heavyWeightContainer == null) {
            return;
        }
        if (OS.getCurrentOS() == OS.Mac && this.contents instanceof JToolTip) {
            SyntheticaLookAndFeel.setChildrenOpaque(this.heavyWeightContainer, false);
        }
        if ((bl2 = SyntheticaLookAndFeel.getBoolean("Synthetica.popupRobot.enabled", this.contents.getParent(), true)) && this.isSnapshotRequired(this.heavyWeightContainer instanceof Window ? (Window)this.heavyWeightContainer : null, bl)) {
            if (this.showPopupLater(this.heavyWeightContainer, bl)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Container container;
                        if (Popup.this.contents != null && (container = Popup.this.contents.getParent()) instanceof JComponent) {
                            ((JComponent)container).putClientProperty(Popup.POPUP_BACKGROUND, Popup.this.snapshot());
                            ((JComponent)container).putClientProperty(Popup.POPUP_LIGHTWEIGHT, Popup.this.lightWeight);
                        }
                    }
                });
            } else {
                ((JComponent)this.contents.getParent()).putClientProperty(POPUP_BACKGROUND, this.snapshot());
                ((JComponent)this.contents.getParent()).putClientProperty(POPUP_LIGHTWEIGHT, this.lightWeight);
            }
        }
        if (this.heavyWeightContainer instanceof Window && SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.fade-in.enabled", this.contents)) {
            int n = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.fade-in.delay", this.contents, 25);
            int n2 = SyntheticaLookAndFeel.getInt("Synthetica.popupMenu.fade-in.duration", this.contents, 200);
            WindowFader windowFader = new WindowFader((Window)this.heavyWeightContainer, null, n, n2, true, false);
            windowFader.start();
        }
        if (this.heavyWeightContainer instanceof Window && OS.getCurrentOS() == OS.Linux && this.isWindowOpacityEnabled((Window)this.heavyWeightContainer) && !SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.linuxWindowShadow.enabled", this.contents, false)) {
            Popup.setWindowOpacity((Window)this.heavyWeightContainer, 0.99999f);
        }
        if (this.showPopupLater(this.heavyWeightContainer, bl)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Popup.this.showPopup(Popup.this.popup);
                }
            });
        } else {
            this.showPopup(this.popup);
        }
        if (this.heavyWeightContainer instanceof Window && !this.isWindowOpacityEnabled((Window)this.heavyWeightContainer) && !bl) {
            if (OS.getCurrentOS() == OS.Windows && !this.showPopupMenuLater()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SyntheticaLookAndFeel.setWindowOpaque((Window)Popup.this.heavyWeightContainer, false);
                    }
                });
            } else {
                SyntheticaLookAndFeel.setWindowOpaque((Window)this.heavyWeightContainer, false);
            }
        }
    }

    private void showPopup(javax.swing.Popup popup) {
        if (popup == null) {
            return;
        }
        Container container = null;
        if (this.owner != null) {
            container = this.owner instanceof Container ? (Container)this.owner : this.owner.getParent();
        }
        Container container2 = container;
        while (container2 != null) {
            if (container2 instanceof JRootPane) {
                if (!(container2.getParent() instanceof JInternalFrame)) {
                    container = ((JRootPane)container2).getLayeredPane();
                }
            } else if (container2 instanceof Window) {
                if (container != null) break;
                container = container2;
                break;
            }
            container2 = container2.getParent();
        }
        if (container != null) {
            popup.show();
        }
    }

    private boolean showPopupLater(Container container, boolean bl) {
        return container instanceof Window && this.isSnapshotRequired((Window)this.heavyWeightContainer, bl) && this.showPopupMenuLater();
    }

    private boolean isSnapshotRequired(Window window, boolean bl) {
        return OS.getCurrentOS() != OS.Mac && (this.isWindowOpacityEnabled(window) || bl) || OS.getCurrentOS() == OS.Mac && bl;
    }

    private boolean isWindowOpacityEnabled(Window window) {
        boolean bl = SyntheticaLookAndFeel.isWindowOpacityEnabled(window);
        if (!bl) {
            return false;
        }
        return this.isPopupMenuWindowOpaque();
    }

    private boolean isPopupMenuWindowOpaque() {
        return SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.window.opaque", this.contents, true);
    }

    private boolean showPopupMenuLater() {
        return SyntheticaLookAndFeel.getBoolean("Synthetica.popupMenu.showLater", this.contents, true);
    }

    private BufferedImage snapshot() {
        BufferedImage bufferedImage = null;
        try {
            Dimension dimension = this.heavyWeightContainer.getPreferredSize();
            if (dimension.width > 0 && dimension.height > 0) {
                Rectangle rectangle = new Rectangle(this.x, this.y, dimension.width, dimension.height);
                bufferedImage = this.createScreenCapture(rectangle);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bufferedImage;
    }

    private BufferedImage createScreenCapture(Rectangle rectangle) throws AWTException {
        return new Robot().createScreenCapture(rectangle);
    }

    private static void setWindowOpacity(Window window, float f) {
        if (GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT)) {
            window.setOpacity(f);
        }
    }

    private static class WindowFader
    extends Timer {
        private static ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WindowFader windowFader = (WindowFader)actionEvent.getSource();
                float f = (float)windowFader.counter / windowFader.repeats;
                Popup.setWindowOpacity(windowFader.window, windowFader.fadein ? f : 1.0f - f);
                if ((float)windowFader.counter == windowFader.repeats) {
                    windowFader.counter = 0;
                    windowFader.stop();
                    if (windowFader.hidePopup) {
                        if (windowFader.popup != null) {
                            windowFader.popup.hide();
                        }
                        Popup.setWindowOpacity(windowFader.window, 1.0f);
                    }
                    windowFader.popup = null;
                    windowFader.window = null;
                } else {
                    WindowFader windowFader2 = windowFader;
                    windowFader2.counter = windowFader2.counter + 1;
                }
            }
        };
        private Window window;
        private javax.swing.Popup popup;
        private boolean fadein;
        private boolean hidePopup;
        private float repeats;
        private int counter;

        public WindowFader(Window window, javax.swing.Popup popup, int n, int n2, boolean bl, boolean bl2) {
            super(0, listener);
            this.window = window;
            this.popup = popup;
            this.setDelay(n);
            this.repeats = n2 / n;
            this.fadein = bl;
            this.hidePopup = bl2;
            Popup.setWindowOpacity(window, bl ? 0.01f : 1.0f);
        }
    }
}

