/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class SyntheticaComboBoxUI
extends BasicComboBoxUI {
    protected JComboBox<Object> delegate = new JComboBox();
    private BasicComboBoxUI ui = (BasicComboBoxUI)this.delegate.getUI();

    public static ComponentUI createUI(JComponent jComponent) {
        return new SyntheticaComboBoxUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        SyntheticaLookAndFeel.getStyleFactory().getStyle(jComponent, Region.COMBO_BOX);
        super.installUI(jComponent);
        Border border = jComponent.getBorder();
        if (border == null || border instanceof DefaultListCellRenderer.UIResource) {
            jComponent.setBorder(this.delegate.getBorder());
        }
    }

    @Override
    protected JButton createArrowButton() {
        JButton jButton = null;
        try {
            Method method = this.ui.getClass().getDeclaredMethod("createArrowButton", new Class[0]);
            method.setAccessible(true);
            jButton = (JButton)method.invoke((Object)this.ui, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jButton;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Border border;
        Boolean bl;
        super.update(graphics, jComponent);
        SynthStyle synthStyle = SynthLookAndFeel.getStyle(this.delegate, Region.COMBO_BOX);
        this.delegate.setOpaque(jComponent.isOpaque());
        this.delegate.putClientProperty("Synthetica.opaque", SyntheticaLookAndFeel.isOpaque(jComponent));
        if (this.delegate.isEnabled() != jComponent.isEnabled()) {
            this.delegate.setEnabled(jComponent.isEnabled());
        }
        if (this.delegate.isEditable() != ((JComboBox)jComponent).isEditable()) {
            this.delegate.setEditable(((JComboBox)jComponent).isEditable());
        }
        if ((bl = (Boolean)jComponent.getClientProperty("ComboBox.arrowButton.enabled")) != null && bl.booleanValue() != this.arrowButton.isEnabled()) {
            this.arrowButton.setEnabled(jComponent.isEnabled() & bl);
        }
        if ((border = jComponent.getBorder()) == null || border instanceof DefaultListCellRenderer.UIResource) {
            jComponent.setBorder(this.delegate.getBorder());
        }
        if (((JComboBox)jComponent).isEditable()) {
            ((JComponent)this.editor).setOpaque(jComponent.isOpaque());
            ((JComponent)this.editor).putClientProperty("Synthetica.opaque", jComponent.getClientProperty("Synthetica.opaque"));
            ((JComponent)this.editor).setBorder(((JComponent)this.delegate.getEditor().getEditorComponent()).getBorder());
        }
        int n = 0;
        if (jComponent.isEnabled()) {
            n |= 1;
        } else if (!jComponent.isEnabled()) {
            n |= 8;
        }
        if (jComponent.hasFocus()) {
            n |= 0x100;
        }
        SynthContext synthContext = new SynthContext(jComponent, Region.COMBO_BOX, synthStyle, n);
        if (SyntheticaLookAndFeel.isOpaque(jComponent)) {
            synthStyle.getPainter(synthContext).paintComboBoxBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
            this.paint(graphics, jComponent);
        }
    }

    @Override
    protected ListCellRenderer<Object> createRenderer() {
        return this.delegate.getRenderer();
    }

    @Override
    public int getBaseline(JComponent jComponent, int n, int n2) {
        Font font = jComponent.getFont();
        if (this.delegate.getFont() != font) {
            this.delegate.setFont(font);
        }
        return this.delegate.getBaseline(n, n2);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            if (jComponent.getForeground() instanceof ColorUIResource) {
                jComponent.setForeground(this.listBox.getForeground());
            }
            Rectangle rectangle = this.rectangleForCurrentValue();
            this.paintCurrentValue(graphics, rectangle, this.hasFocus);
        }
    }
}

